/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import ptolemy.graph.CPO;
import ptolemy.graph.Inequality;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.NamedObj;

public class InequalitySolver {
    private CPO _cpo = null;
    private ArrayList _Ilist = new ArrayList();
    private Hashtable _Clist = new Hashtable();

    public InequalitySolver(CPO cpo) {
        this._cpo = cpo;
    }

    public void addInequalities(Iterator inequalities) {
        while (inequalities.hasNext()) {
            this.addInequality((Inequality)inequalities.next());
        }
    }

    public void addInequality(Inequality ineq) {
        Integer indexWrap = this._Ilist.size();
        Info info = new Info(ineq);
        this._Ilist.add(info);
        this._addToClist(ineq.getLesserTerm().getVariables(), indexWrap);
        this._addToClist(ineq.getGreaterTerm().getVariables(), indexWrap);
    }

    public Iterator bottomVariables() throws IllegalActionException {
        Object bottom = this._cpo.bottom();
        if (bottom == null) {
            throw new InvalidStateException("The underlying CPO does not have a bottom element.");
        }
        return this._filterVariables(bottom);
    }

    public String description() {
        StringBuffer results = new StringBuffer("{_Ilist:\n ");
        for (int i = 0; i < this._Ilist.size(); ++i) {
            Info info = (Info)this._Ilist.get(i);
            results.append("{_ineq: " + info._ineq + " _inCvar: " + info._inCvar + " _inserted: " + info._inserted + "}\n  ");
        }
        results.append("}\n{Clist:\n ");
        Enumeration e = this._Clist.keys();
        while (e.hasMoreElements()) {
            InequalityTerm variable = (InequalityTerm)e.nextElement();
            results.append("{" + (variable == null ? "variable == null" : variable.toString()) + "}\n ");
        }
        results.append("}\n");
        return results.toString();
    }

    public boolean solveGreatest() throws IllegalActionException {
        return this._solve(false);
    }

    public boolean solveLeast() throws IllegalActionException {
        return this._solve(true);
    }

    public Iterator topVariables() throws IllegalActionException {
        Object top = this._cpo.top();
        if (top == null) {
            throw new InvalidStateException("The underlying CPO does not have a top element.");
        }
        return this._filterVariables(top);
    }

    public Iterator unsatisfiedInequalities() throws IllegalActionException {
        LinkedList<Inequality> result = new LinkedList<Inequality>();
        for (int i = 0; i < this._Ilist.size(); ++i) {
            Info info = (Info)this._Ilist.get(i);
            if (info._ineq.isSatisfied(this._cpo)) continue;
            result.addLast(info._ineq);
        }
        return result.iterator();
    }

    public Iterator variables() {
        LinkedList<InequalityTerm> result = new LinkedList<InequalityTerm>();
        Enumeration e = this._Clist.keys();
        while (e.hasMoreElements()) {
            InequalityTerm variable = (InequalityTerm)e.nextElement();
            result.addLast(variable);
        }
        return result.iterator();
    }

    private void _addToClist(InequalityTerm[] variables, Integer indexWrap) {
        for (int i = 0; i < variables.length; ++i) {
            if (!variables[i].isSettable()) {
                Object variableValue = null;
                try {
                    variableValue = variables[i].getValue();
                }
                catch (IllegalActionException ex) {
                    variableValue = ex.toString();
                }
                Object variableObject = null;
                try {
                    variableObject = variables[i].getAssociatedObject();
                    if (variableObject instanceof NamedObj) {
                        variableObject = ((NamedObj)variableObject).getFullName();
                    }
                }
                catch (Exception ex) {
                    variableObject = ex.toString();
                }
                throw new InvalidStateException("Port \" " + variableObject + "\" of type \"" + variableValue + "\" in an InequalityTerm is not settable." + " If the port is an input and has a type constraint," + " try removing the type constraint and possibly" + " placing it on the output.");
            }
            ArrayList<Integer> entry = (ArrayList<Integer>)this._Clist.get(variables[i]);
            if (entry == null) {
                entry = new ArrayList<Integer>();
                this._Clist.put(variables[i], entry);
            }
            entry.add(indexWrap);
        }
    }

    private Iterator _filterVariables(Object value) throws IllegalActionException {
        LinkedList<InequalityTerm> result = new LinkedList<InequalityTerm>();
        Enumeration e = this._Clist.keys();
        while (e.hasMoreElements()) {
            InequalityTerm variable = (InequalityTerm)e.nextElement();
            if (value != null && !variable.getValue().equals(value)) continue;
            result.addLast(variable);
        }
        return result.iterator();
    }

    private boolean _solve(boolean least) throws IllegalActionException {
        Info info;
        Object init;
        Object object = init = least ? this._cpo.bottom() : this._cpo.top();
        if (init == null) {
            throw new InvalidStateException("The underlying CPO is not a lattice because the CPO has no " + (least ? "bottom" : "top") + ". The CPO was a " + this._cpo.getClass().getName());
        }
        Enumeration e = this._Clist.keys();
        while (e.hasMoreElements()) {
            InequalityTerm variable = (InequalityTerm)e.nextElement();
            try {
                variable.initialize(init);
            }
            catch (IllegalActionException ex) {
                throw new InvalidStateException(null, null, ex, "Cannot initialize variable.");
            }
        }
        LinkedList<Integer> _NS = new LinkedList<Integer>();
        for (int i = 0; i < this._Ilist.size(); ++i) {
            Info info2 = (Info)this._Ilist.get(i);
            info2._inCvar = least ? info2._ineq.getGreaterTerm().isSettable() : info2._ineq.getLesserTerm().isSettable();
            if (!info2._inCvar) continue;
            if (info2._ineq.isSatisfied(this._cpo)) {
                info2._inserted = false;
                continue;
            }
            _NS.addLast(i);
            info2._inserted = true;
        }
        boolean allSatisfied = false;
        while (!allSatisfied) {
            while (_NS.size() > 0) {
                int index = (Integer)_NS.removeFirst();
                info = (Info)this._Ilist.get(index);
                info._inserted = false;
                Object value = null;
                InequalityTerm updateTerm = null;
                if (least) {
                    updateTerm = info._ineq.getGreaterTerm();
                    value = this._cpo.leastUpperBound(info._ineq.getLesserTerm().getValue(), updateTerm.getValue());
                } else {
                    updateTerm = info._ineq.getLesserTerm();
                    value = this._cpo.greatestLowerBound(updateTerm.getValue(), info._ineq.getGreaterTerm().getValue());
                }
                if (value == null) {
                    throw new InvalidStateException("The CPO over which the inequalities are defined is not a lattice.");
                }
                try {
                    updateTerm.setValue(value);
                }
                catch (IllegalActionException ex) {
                    throw new InvalidStateException(null, null, ex, "Can't update variable.\n");
                }
                ArrayList affected = (ArrayList)this._Clist.get(updateTerm);
                for (int i = 0; i < affected.size(); ++i) {
                    Integer index1Wrap = (Integer)affected.get(i);
                    int index1 = index1Wrap;
                    Info affectedInfo = (Info)this._Ilist.get(index1);
                    if (index1 == index || !affectedInfo._inCvar) continue;
                    if (affectedInfo._ineq.isSatisfied(this._cpo)) {
                        if (!affectedInfo._inserted) continue;
                        _NS.remove(index1Wrap);
                        continue;
                    }
                    if (affectedInfo._inserted) continue;
                    _NS.addFirst(index1Wrap);
                }
            }
            allSatisfied = true;
            for (int i = 0; i < this._Ilist.size(); ++i) {
                info = (Info)this._Ilist.get(i);
                if (!info._inCvar) continue;
                if (info._ineq.isSatisfied(this._cpo)) {
                    info._inserted = false;
                    continue;
                }
                _NS.addLast(i);
                info._inserted = true;
                allSatisfied = false;
            }
        }
        for (int i = 0; i < this._Ilist.size(); ++i) {
            info = (Info)this._Ilist.get(i);
            if (info._inCvar || info._ineq.isSatisfied(this._cpo)) continue;
            return false;
        }
        return true;
    }

    private static class Info {
        private Inequality _ineq;
        private boolean _inCvar = false;
        private boolean _inserted = false;

        private Info(Inequality ineq) {
            this._ineq = ineq;
        }
    }
}

