/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Graph;
import ptolemy.graph.analysis.analyzer.CycleExistenceAnalyzer;
import ptolemy.graph.analysis.strategy.CachedStrategy;
import ptolemy.graph.analysis.strategy.FloydWarshallTransitiveClosureStrategy;

public class FloydWarshallCycleExistenceStrategy
extends CachedStrategy
implements CycleExistenceAnalyzer {
    private FloydWarshallTransitiveClosureStrategy _strategy = new FloydWarshallTransitiveClosureStrategy(this.graph());

    public FloydWarshallCycleExistenceStrategy(Graph graph) {
        super(graph);
    }

    @Override
    public boolean hasCycle() {
        return (Boolean)this._result();
    }

    @Override
    public String toString() {
        return "Cycle existence analyzer based on the Floyd-Warshall algorithm.";
    }

    @Override
    public boolean valid() {
        return this.graph() instanceof DirectedGraph;
    }

    @Override
    protected Object _compute() {
        boolean cyclic = false;
        boolean[][] transitiveClosure = this._strategy.transitiveClosureMatrix();
        for (int i = 0; i < transitiveClosure.length; ++i) {
            if (!transitiveClosure[i][i]) continue;
            cyclic = true;
            break;
        }
        return cyclic;
    }
}

