/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Graph;
import ptolemy.graph.analysis.analyzer.NegativeLengthCycleAnalyzer;
import ptolemy.graph.analysis.strategy.CachedStrategy;
import ptolemy.graph.analysis.strategy.FloydWarshallAllPairShortestPathStrategy;
import ptolemy.graph.mapping.ToDoubleMapping;

public class FloydWarshallZeroLengthCycleStrategy
extends CachedStrategy
implements NegativeLengthCycleAnalyzer {
    private FloydWarshallAllPairShortestPathStrategy _strategy;
    private ToDoubleMapping _edgeLengths;

    public FloydWarshallZeroLengthCycleStrategy(Graph graph, ToDoubleMapping edgeLengths) {
        super(graph);
        this._edgeLengths = edgeLengths;
        this._strategy = new FloydWarshallAllPairShortestPathStrategy(graph, this._edgeLengths);
    }

    @Override
    public boolean hasNegativeLengthCycle() {
        return (Boolean)this._result();
    }

    @Override
    public String toString() {
        return "Zero Length analyzer based on the Floyd-Warshall algorithm.";
    }

    @Override
    public boolean valid() {
        return this.graph() instanceof DirectedGraph;
    }

    @Override
    protected Object _compute() {
        double[][] allPairShortestPath = this._strategy.shortestPathMatrix();
        boolean zeroCycle = false;
        int n = this.graph().nodeCount();
        for (int i = 0; i < n; ++i) {
            if (allPairShortestPath[i][i] != 0.0) continue;
            zeroCycle = true;
            break;
        }
        return zeroCycle;
    }
}

