/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Edge;
import ptolemy.graph.Graph;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.SingleSourceLongestPathAnalysis;
import ptolemy.graph.analysis.analyzer.MaximumProfitToCostRatioAnalyzer;
import ptolemy.graph.analysis.strategy.CachedStrategy;
import ptolemy.graph.analysis.strategy.FloydWarshallCycleExistenceStrategy;
import ptolemy.graph.analysis.strategy.KarpCycleMeanStrategy;
import ptolemy.graph.mapping.ToDoubleMapMapping;
import ptolemy.graph.mapping.ToDoubleMapping;
import ptolemy.graph.mapping.ToIntMapping;

public class ParhiMaximumProfitToCostRatioStrategy
extends CachedStrategy
implements MaximumProfitToCostRatioAnalyzer {
    private double[][] _firstOrderLongestPathMatrix;
    private List _delayCycle;
    private ArrayList _delayNodeList;
    private ArrayList _maximumProfitToCostRatioCycle;
    private ToDoubleMapping _edgeProfits;
    private ToIntMapping _edgeCosts;

    public ParhiMaximumProfitToCostRatioStrategy(Graph graph, ToDoubleMapping edgeProfits, ToIntMapping edgeCosts) {
        super(graph);
        this._edgeProfits = edgeProfits;
        this._edgeCosts = edgeCosts;
    }

    @Override
    public List cycle() {
        this._result();
        return this._maximumProfitToCostRatioCycle;
    }

    @Override
    public double maximumRatio() {
        return (Double)this._result();
    }

    @Override
    public String toString() {
        return "All pair shortest path analyzer based on Parhi's algorithm.";
    }

    @Override
    public boolean valid() {
        boolean result = false;
        if (this.graph() instanceof DirectedGraph) {
            FloydWarshallCycleExistenceStrategy analyzer = new FloydWarshallCycleExistenceStrategy(this.graph());
            result = analyzer.hasCycle();
        }
        return result;
    }

    @Override
    protected Object _compute() {
        int i;
        this._delayNodeList = new ArrayList();
        this._maximumProfitToCostRatioCycle = new ArrayList();
        DirectedGraph originalGraph = (DirectedGraph)this.graph();
        DirectedGraph graphPlusDelaysAsNodes = (DirectedGraph)originalGraph.cloneAs(new DirectedGraph());
        Object[] edges = graphPlusDelaysAsNodes.edges().toArray();
        HashMap<Edge, Double> edgeProfitsMap = new HashMap<Edge, Double>();
        for (int j = 0; j < edges.length; ++j) {
            Edge edge = (Edge)edges[j];
            Node source = edge.source();
            Node sink = edge.sink();
            if (this._edgeCosts.toInt(edge) != 0) {
                graphPlusDelaysAsNodes.removeEdge(edge);
                int delays = this._edgeCosts.toInt(edge);
                for (int i2 = 0; i2 < delays; ++i2) {
                    Node addedNode = graphPlusDelaysAsNodes.addNodeWeight("D" + j + i2);
                    this._delayNodeList.add(addedNode);
                    Edge addedEdge = graphPlusDelaysAsNodes.addEdge(source, addedNode);
                    edgeProfitsMap.put(addedEdge, 0.0);
                    source = addedNode;
                }
                Edge lastAddedEdge = graphPlusDelaysAsNodes.addEdge(source, sink);
                edgeProfitsMap.put(lastAddedEdge, this._edgeProfits.toDouble(edge));
                continue;
            }
            edgeProfitsMap.put(edge, this._edgeProfits.toDouble(edge));
        }
        HashMap<Node, SingleSourceLongestPathAnalysis> D = new HashMap<Node, SingleSourceLongestPathAnalysis>(this._delayNodeList.size());
        edges = graphPlusDelaysAsNodes.edges().toArray();
        HashMap<Node, Node> predecessorMap = new HashMap<Node, Node>();
        for (Node delayNode : this._delayNodeList) {
            DirectedGraph thisRoundGraph = (DirectedGraph)graphPlusDelaysAsNodes.clone();
            HashMap delayGraphProfitMap = new HashMap();
            for (int j = 0; j < edges.length; ++j) {
                Edge edge = (Edge)edges[j];
                Node source = edge.source();
                Node sink = edge.sink();
                if (sink == delayNode) {
                    predecessorMap.put(delayNode, source);
                }
                if (this._delayNodeList.contains(source) || this._delayNodeList.contains(sink)) {
                    if (source == delayNode) {
                        delayGraphProfitMap.put(edge, edgeProfitsMap.get(edge));
                    }
                    if (sink == delayNode) {
                        thisRoundGraph.removeEdge(edge);
                    }
                    if (source == delayNode || sink == delayNode) continue;
                    if (this._delayNodeList.contains(source)) {
                        thisRoundGraph.removeEdge(edge);
                        continue;
                    }
                    delayGraphProfitMap.put(edge, edgeProfitsMap.get(edge));
                    continue;
                }
                delayGraphProfitMap.put(edge, edgeProfitsMap.get(edge));
            }
            SingleSourceLongestPathAnalysis longestPath = null;
            longestPath = new SingleSourceLongestPathAnalysis(thisRoundGraph, delayNode, new ToDoubleMapMapping(delayGraphProfitMap));
            D.put(delayNode, longestPath);
        }
        this._makeFirstOrderLongestPathMatrix(D, graphPlusDelaysAsNodes, predecessorMap);
        DirectedGraph delayGraph = new DirectedGraph();
        HashMap<Edge, Double> delayGraphEdgeProfits = new HashMap<Edge, Double>();
        for (i = 0; i < this._delayNodeList.size(); ++i) {
            delayGraph.addNode((Node)this._delayNodeList.get(i));
        }
        for (i = 0; i < this._delayNodeList.size(); ++i) {
            for (int j = 0; j < this._delayNodeList.size(); ++j) {
                Node source = (Node)this._delayNodeList.get(i);
                Node sink = (Node)this._delayNodeList.get(j);
                if (!(this._firstOrderLongestPathMatrix[i][j] >= 0.0) || source == sink && this._firstOrderLongestPathMatrix[i][j] == 0.0) continue;
                Edge addedEdge = delayGraph.addEdge(source, sink);
                delayGraphEdgeProfits.put(addedEdge, this._firstOrderLongestPathMatrix[i][j]);
            }
        }
        double result = this._computeMCM(delayGraph, new ToDoubleMapMapping(delayGraphEdgeProfits));
        edges = graphPlusDelaysAsNodes.edges().toArray();
        Object[] delayNodes = this._delayCycle.toArray();
        for (int i3 = 0; i3 < delayNodes.length; ++i3) {
            Node delayNode = (Node)delayNodes[i3];
            for (int j = 0; j < delayNodes.length; ++j) {
                Node predecessor;
                int k;
                List path;
                if (i3 != j || delayNodes.length != 1) {
                    Node endDelayNode = (Node)delayNodes[j];
                    path = ((SingleSourceLongestPathAnalysis)D.get(delayNode)).path(endDelayNode);
                    for (k = 0; k < path.size(); ++k) {
                        if (this._delayNodeList.contains(path.get(k))) continue;
                        this._maximumProfitToCostRatioCycle.add(path.get(k));
                    }
                    continue;
                }
                if (delayNodes.length != 1 || this._delayNodeList.contains(predecessor = (Node)predecessorMap.get(delayNode))) continue;
                path = ((SingleSourceLongestPathAnalysis)D.get(delayNode)).path(predecessor);
                for (k = 0; k < path.size(); ++k) {
                    if (this._delayNodeList.contains(path.get(k))) continue;
                    this._maximumProfitToCostRatioCycle.add(path.get(k));
                }
            }
        }
        return result;
    }

    private double _computeMCM(DirectedGraph graph, ToDoubleMapping edgeLength) {
        KarpCycleMeanStrategy cycleMean = new KarpCycleMeanStrategy(graph, edgeLength);
        double result = cycleMean.maximumCycleMean();
        this._delayCycle = cycleMean.cycle();
        return result;
    }

    private double[][] _makeFirstOrderLongestPathMatrix(HashMap D, DirectedGraph graph, HashMap predecessorMap) {
        this._firstOrderLongestPathMatrix = new double[this._delayNodeList.size()][this._delayNodeList.size()];
        for (int i = 0; i < this._delayNodeList.size(); ++i) {
            for (int j = 0; j < this._delayNodeList.size(); ++j) {
                Node column = (Node)this._delayNodeList.get(i);
                Node row = (Node)this._delayNodeList.get(j);
                double value = 0.0;
                double[] distances = ((SingleSourceLongestPathAnalysis)D.get(column)).distance();
                Node predecessor = (Node)predecessorMap.get(row);
                value = i != j || this._delayNodeList.contains(predecessor) ? distances[graph.nodeLabel(row)] : distances[graph.nodeLabel(predecessor)];
                this._firstOrderLongestPathMatrix[i][j] = value;
            }
        }
        return this._firstOrderLongestPathMatrix;
    }
}

