/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.sched;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import ptolemy.graph.sched.Firing;
import ptolemy.graph.sched.ScheduleElement;

public class Schedule
extends ScheduleElement {
    protected List _schedule = new LinkedList();
    private int _treeDepth = 3;
    private List _firingInstancesList;
    private Map _firingElementFiringsMap;

    public Schedule() {
    }

    public Schedule(Class firingElementClass) {
        super(firingElementClass);
    }

    public void add(ScheduleElement element) {
        this.add(this._schedule.size(), element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(int index, ScheduleElement element) {
        if (this.firingElementClass() != null) {
            Class firingElementClass = this.firingElementClass();
            Class elementClass = element.firingElementClass();
            if (elementClass == null) throw new RuntimeException("Attempt to add a non authorized firing element");
            if (!firingElementClass.isAssignableFrom(elementClass)) throw new RuntimeException("Attempt to add a non authorized firing element");
            element.setParent(this);
            this._incrementVersion();
            this._schedule.add(index, element);
            return;
        } else {
            element.setParent(this);
            this._incrementVersion();
            this._schedule.add(index, element);
        }
    }

    public int appearanceCount(Object firingElement) {
        return this.firings(firingElement).size();
    }

    @Override
    public Iterator firingElementIterator() {
        return new FiringElementIterator();
    }

    @Override
    public Iterator firingIterator() {
        return new FiringIterator(this);
    }

    public List firings(Object firingElement) {
        Map firingElementFiringsMap = this._getFiringElementFiringsMap();
        return Collections.unmodifiableList((List)firingElementFiringsMap.get(firingElement));
    }

    public ScheduleElement get(int index) {
        return (ScheduleElement)this._schedule.get(index);
    }

    public Iterator iterator() {
        return this._schedule.iterator();
    }

    public List lexicalOrder() {
        ArrayList<Object> lexicalList = new ArrayList<Object>();
        for (Firing firing : this._getFiringInstancesList()) {
            Object firingElement = firing.getFiringElement();
            if (lexicalList.contains(firingElement)) {
                throw new IllegalStateException("Not a single appearance schedule to compute the lexical order of nodes.");
            }
            lexicalList.add(firingElement);
        }
        return Collections.unmodifiableList(lexicalList);
    }

    public int maxAppearanceCount() {
        int maxCount = 0;
        Iterator firingLists = this._getFiringElementFiringsMap().values().iterator();
        while (firingLists.hasNext()) {
            int firingListSize = ((List)firingLists.next()).size();
            if (maxCount >= firingListSize) continue;
            maxCount = firingListSize;
        }
        return maxCount;
    }

    public ScheduleElement remove(int index) {
        this._incrementVersion();
        return (ScheduleElement)this._schedule.remove(index);
    }

    public int size() {
        return this._schedule.size();
    }

    @Override
    public String toParenthesisString(Map nameMap, String delimiter) {
        StringBuffer result = new StringBuffer("(");
        int iterations = this.getIterationCount();
        if (iterations > 1) {
            result.append(iterations);
        }
        Iterator schedules = this.iterator();
        while (schedules.hasNext()) {
            ScheduleElement schedule = (ScheduleElement)schedules.next();
            result.append(delimiter + schedule.toParenthesisString(nameMap, delimiter));
        }
        result.append(")");
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Execute Schedule{\n");
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ScheduleElement e = (ScheduleElement)i.next();
            result.append(e + "\n");
        }
        result.append("}");
        if (this.getIterationCount() > 1) {
            result.append(" " + this.getIterationCount() + " times");
        }
        return result.toString();
    }

    private List _getFiringInstancesList() {
        if (this._firingInstancesList == null) {
            this._firingInstancesList = new ArrayList();
            Iterator originalFirings = this.firingIterator();
            while (originalFirings.hasNext()) {
                Object firing = originalFirings.next();
                if (this._firingInstancesList.contains(firing)) continue;
                this._firingInstancesList.add(firing);
            }
        }
        return this._firingInstancesList;
    }

    private Map _getFiringElementFiringsMap() {
        if (this._firingElementFiringsMap == null) {
            this._firingElementFiringsMap = new HashMap();
            for (Firing firing : this._getFiringInstancesList()) {
                Object node = firing.getFiringElement();
                List<Firing> firingList = null;
                if (!this._firingElementFiringsMap.containsKey(node)) {
                    firingList = new ArrayList();
                    this._firingElementFiringsMap.put(node, firingList);
                } else {
                    firingList = (List)this._firingElementFiringsMap.get(node);
                }
                firingList.add(firing);
            }
        }
        return Collections.unmodifiableMap(this._firingElementFiringsMap);
    }

    private class FiringIterator
    implements Iterator {
        private boolean _advance = true;
        private ScheduleElement _currentNode;
        private boolean _lastHasNext;
        private int _currentDepth;
        private long _startingVersion;
        private int[] _iterationCounts;
        private int[] _horizontalNodePosition;

        public FiringIterator(Schedule schedule2) {
            this._startingVersion = Schedule.this._getVersion();
            this._currentNode = schedule2;
            this._currentDepth = 0;
            this._iterationCounts = new int[Schedule.this._treeDepth];
            this._horizontalNodePosition = new int[Schedule.this._treeDepth];
        }

        @Override
        public boolean hasNext() {
            if (this._startingVersion != Schedule.this._getVersion()) {
                throw new ConcurrentModificationException("Schedule structure changed while iterator is active.");
            }
            if (this._advance) {
                if (this._currentNode instanceof Firing) {
                    Schedule scheduleNode = this._backTrack(this._currentNode);
                    this._currentNode = this._findLeafNode(scheduleNode);
                    if (this._currentNode == null) {
                        this._advance = false;
                        this._lastHasNext = false;
                        return this._lastHasNext;
                    }
                } else if (this._currentNode instanceof Schedule) {
                    this._currentNode = this._findLeafNode((Schedule)this._currentNode);
                    if (this._currentNode == null) {
                        this._advance = false;
                        this._lastHasNext = false;
                        return this._lastHasNext;
                    }
                } else {
                    throw new RuntimeException("Encountered a ScheduleElement that is not an instance of Schedule or Firing.");
                }
                this._advance = false;
                this._lastHasNext = true;
                return this._lastHasNext;
            }
            return this._lastHasNext;
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element to return.");
            }
            if (this._startingVersion != Schedule.this._getVersion()) {
                throw new ConcurrentModificationException("Schedule structure changed while iterator is active.");
            }
            this._advance = true;
            return this._currentNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Schedule _backTrack(ScheduleElement firingNode) {
            if (this._currentDepth == 0) {
                return null;
            }
            --this._currentDepth;
            Schedule node = (Schedule)firingNode.getParent();
            if (node == null) {
                return null;
            }
            int n = this._currentDepth + 1;
            if (node.size() > (this._horizontalNodePosition[n] = this._horizontalNodePosition[n] + 1)) {
                return node;
            }
            int n2 = this._currentDepth;
            this._iterationCounts[n2] = this._iterationCounts[n2] + 1;
            if (this._iterationCounts[n2] < node.getIterationCount()) {
                this._horizontalNodePosition[this._currentDepth + 1] = 0;
                return node;
            }
            this._horizontalNodePosition[this._currentDepth + 1] = 0;
            this._iterationCounts[this._currentDepth] = 0;
            return this._backTrack(node);
        }

        private ScheduleElement _findLeafNode(Schedule node) {
            ScheduleElement nodeElement;
            if (this._iterationCounts.length - 1 < this._currentDepth + 2) {
                int[] temp = new int[this._currentDepth + 2];
                for (int i = 0; i < this._iterationCounts.length; ++i) {
                    temp[i] = this._iterationCounts[i];
                }
                this._iterationCounts = temp;
                int[] temp2 = new int[this._currentDepth + 2];
                for (int i = 0; i < this._horizontalNodePosition.length; ++i) {
                    temp2[i] = this._horizontalNodePosition[i];
                }
                this._horizontalNodePosition = temp2;
                Schedule.this._treeDepth = this._currentDepth + 2;
            }
            if (node == null) {
                return null;
            }
            if (node.size() > this._horizontalNodePosition[this._currentDepth + 1]) {
                ++this._currentDepth;
                nodeElement = node.get(this._horizontalNodePosition[this._currentDepth]);
                if (nodeElement instanceof Firing) {
                    return nodeElement;
                }
                return this._findLeafNode((Schedule)nodeElement);
            }
            if (node.size() == 0) {
                Schedule scheduleNode = this._backTrack(this._currentNode);
                return this._findLeafNode(scheduleNode);
            }
            if (this._iterationCounts[this._currentDepth] < node.getIterationCount()) {
                nodeElement = node.get(0);
                ++this._currentDepth;
                if (nodeElement instanceof Firing) {
                    return nodeElement;
                }
                return this._findLeafNode((Schedule)nodeElement);
            }
            return null;
        }
    }

    private class FiringElementIterator
    implements Iterator {
        private Iterator _firingIterator;
        private Firing _currentFiring;
        private Object _currentFiringElement;
        private long _currentVersion;
        private int _currentIteration;
        private boolean _advance = true;
        private boolean _lastHasNext;

        public FiringElementIterator() {
            this._firingIterator = Schedule.this.firingIterator();
            this._currentVersion = Schedule.this._getVersion();
            this._currentIteration = 0;
        }

        @Override
        public boolean hasNext() {
            if (this._currentVersion != Schedule.this._getVersion()) {
                throw new ConcurrentModificationException("Schedule structure changed while iterator is active.");
            }
            if (this._advance) {
                if (this._currentFiring == null) {
                    boolean returnValue = this._firingIterator.hasNext();
                    if (returnValue) {
                        this._currentFiring = (Firing)this._firingIterator.next();
                        this._currentFiringElement = this._currentFiring.getFiringElement();
                        ++this._currentIteration;
                        this._advance = false;
                        this._lastHasNext = true;
                        return this._lastHasNext;
                    }
                    this._advance = false;
                    this._lastHasNext = false;
                    return this._lastHasNext;
                }
                if (this._currentIteration < this._currentFiring.getIterationCount()) {
                    ++this._currentIteration;
                    this._advance = false;
                    this._lastHasNext = true;
                    return this._lastHasNext;
                }
                this._currentIteration = 0;
                boolean returnValue = this._firingIterator.hasNext();
                if (returnValue) {
                    this._currentFiring = (Firing)this._firingIterator.next();
                    this._currentFiringElement = this._currentFiring.getFiringElement();
                    ++this._currentIteration;
                    this._advance = false;
                    this._lastHasNext = true;
                    return this._lastHasNext;
                }
                this._advance = false;
                this._lastHasNext = false;
                return this._lastHasNext;
            }
            return this._lastHasNext;
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element to return.");
            }
            if (this._currentVersion != Schedule.this._getVersion()) {
                throw new ConcurrentModificationException("Schedule structure changed while iterator is active.");
            }
            this._advance = true;
            return this._currentFiringElement;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

