/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class ComponentRelation
extends Relation {
    private CompositeEntity _container;
    private transient List _deepLinkedPorts;
    private transient long _deepLinkedPortsVersion = -1L;

    public ComponentRelation() {
    }

    public ComponentRelation(Workspace workspace) {
        super(workspace);
    }

    public ComponentRelation(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container.workspace(), name);
        this.setContainer(container);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ComponentRelation newObject = (ComponentRelation)super.clone(workspace);
        newObject._container = null;
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List deepLinkedPortList() {
        try {
            this._workspace.getReadAccess();
            if (this._deepLinkedPortsVersion == this._workspace.getVersion()) {
                List list = this._deepLinkedPorts;
                return list;
            }
            Iterator nearPorts = this.linkedPortList().iterator();
            this._deepLinkedPorts = new LinkedList();
            while (nearPorts.hasNext()) {
                ComponentPort port = (ComponentPort)nearPorts.next();
                if (port._isInsideLinkable(this.getContainer())) {
                    if (port.isOpaque()) {
                        this._deepLinkedPorts.add(port);
                        continue;
                    }
                    this._deepLinkedPorts.addAll(port.deepConnectedPortList());
                    continue;
                }
                if (port.isOpaque()) {
                    this._deepLinkedPorts.add(port);
                    continue;
                }
                this._deepLinkedPorts.addAll(port.deepInsidePortList());
            }
            this._deepLinkedPortsVersion = this._workspace.getVersion();
            List list = Collections.unmodifiableList(this._deepLinkedPorts);
            return list;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration deepLinkedPorts() {
        return Collections.enumeration(this.deepLinkedPortList());
    }

    @Override
    public NamedObj getContainer() {
        return this._container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int moveDown() throws IllegalActionException {
        CompositeEntity container = (CompositeEntity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._containedRelations.moveDown(this);
            for (NamedObj derived : this.getDerivedList()) {
                container = (CompositeEntity)derived.getContainer();
                container._containedRelations.moveDown(derived);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int moveToFirst() throws IllegalActionException {
        CompositeEntity container = (CompositeEntity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._containedRelations.moveToFirst(this);
            for (NamedObj derived : this.getDerivedList()) {
                container = (CompositeEntity)derived.getContainer();
                container._containedRelations.moveToFirst(derived);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int moveToIndex(int index) throws IllegalActionException {
        CompositeEntity container = (CompositeEntity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._containedRelations.moveToIndex(this, index);
            for (NamedObj derived : this.getDerivedList()) {
                container = (CompositeEntity)derived.getContainer();
                container._containedRelations.moveToIndex(derived, index);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int moveToLast() throws IllegalActionException {
        CompositeEntity container = (CompositeEntity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._containedRelations.moveToLast(this);
            for (NamedObj derived : this.getDerivedList()) {
                container = (CompositeEntity)derived.getContainer();
                container._containedRelations.moveToLast(derived);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int moveUp() throws IllegalActionException {
        CompositeEntity container = (CompositeEntity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._containedRelations.moveUp(this);
            for (NamedObj derived : this.getDerivedList()) {
                container = (CompositeEntity)derived.getContainer();
                container._containedRelations.moveUp(derived);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        if (container != null && this._workspace != container.workspace()) {
            throw new IllegalActionException((Nameable)this, container, "Cannot set container because workspaces are different.");
        }
        try {
            this._workspace.getWriteAccess();
            this._checkContainer(container);
            CompositeEntity previousContainer = (CompositeEntity)this.getContainer();
            if (previousContainer == container) {
                return;
            }
            if (container != null) {
                container._addRelation(this);
                if (previousContainer == null) {
                    this._workspace.remove(this);
                }
            }
            this._container = container;
            if (previousContainer != null) {
                previousContainer._removeRelation(this);
            }
            if (container == null) {
                this.unlinkAll();
            } else if (this._changeRequests != null) {
                for (ChangeRequest request : this._changeRequests) {
                    container.requestChange(request);
                }
                this._changeRequests = null;
            }
            this.validateSettables();
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    @Override
    public void setName(String name) throws IllegalActionException, NameDuplicationException {
        ComponentRelation another;
        CompositeEntity container;
        if (name == null) {
            name = "";
        }
        if ((container = (CompositeEntity)this.getContainer()) != null && (another = container.getRelation(name)) != null && another != this) {
            throw new NameDuplicationException((Nameable)container, "Name duplication: " + name);
        }
        super.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlinkAll() {
        try {
            super.unlinkAll();
            this._workspace.getWriteAccess();
            LinkedList ports = new LinkedList();
            Enumeration links = this._linkList.getContainers();
            while (links.hasMoreElements()) {
                Object link = links.nextElement();
                if (!(link instanceof ComponentPort)) continue;
                ports.add(link);
            }
            Iterator portsIterator = ports.iterator();
            while (portsIterator.hasNext()) {
                ((ComponentPort)portsIterator.next()).unlinkInside(this);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    protected void _checkContainer(CompositeEntity container) throws IllegalActionException {
    }

    @Override
    protected void _checkPort(Port port) throws IllegalActionException {
        if (!(port instanceof ComponentPort)) {
            throw new IllegalActionException((Nameable)this, port, "ComponentRelation can only link to a ComponentPort.");
        }
    }

    @Override
    protected void _checkRelation(Relation relation, boolean symmetric) throws IllegalActionException {
        if (!(relation instanceof ComponentRelation)) {
            throw new IllegalActionException((Nameable)this, relation, "ComponentRelation can only link to a ComponentRelation.");
        }
        super._checkRelation(relation, symmetric);
    }

    @Override
    protected NamedObj _propagateExistence(NamedObj container) throws IllegalActionException {
        try {
            ComponentRelation newObject = (ComponentRelation)super._propagateExistence(container);
            newObject.setContainer((CompositeEntity)container);
            return newObject;
        }
        catch (NameDuplicationException e) {
            throw new InternalErrorException(e);
        }
    }
}

