/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.util;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Changeable;
import ptolemy.kernel.util.DebugEvent;
import ptolemy.kernel.util.DebugListener;
import ptolemy.kernel.util.Debuggable;
import ptolemy.kernel.util.Derivable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Instantiable;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.MoMLExportable;
import ptolemy.kernel.util.ModelErrorHandler;
import ptolemy.kernel.util.Moveable;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedList;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.SingletonConfigurableAttribute;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.StringUtilities;

public class NamedObj
implements Changeable,
Cloneable,
Debuggable,
DebugListener,
Derivable,
MoMLExportable,
ModelErrorHandler,
Moveable,
Serializable {
    public static final int COMPLETE = -1;
    public static final int CLASSNAME = 1;
    public static final int FULLNAME = 2;
    public static final int LINKS = 4;
    public static final int CONTENTS = 8;
    public static final int DEEP = 16;
    public static final int ATTRIBUTES = 32;
    protected List _changeListeners;
    protected Object _changeLock = new SerializableObject();
    protected List _changeRequests;
    protected boolean _debugging = false;
    protected LinkedList _debugListeners = null;
    protected String _elementName = "entity";
    protected Boolean _isPersistent = null;
    protected Workspace _workspace;
    protected boolean _verbose = false;
    NamedList _attributes;
    private String _className;
    private static Workspace _DEFAULT_WORKSPACE = new Workspace();
    private transient boolean _deferChangeRequests = false;
    private int _derivedLevel = Integer.MAX_VALUE;
    private String _displayName;
    private String _fullNameCache;
    private long _fullNameVersion = -1L;
    private ModelErrorHandler _modelErrorHandler = null;
    private String _name;
    private List _override = null;
    private String _source;

    public NamedObj() {
        this((Workspace)null);
    }

    public NamedObj(String name) throws IllegalActionException {
        this(_DEFAULT_WORKSPACE, name);
    }

    public NamedObj(Workspace workspace) {
        if (workspace == null) {
            workspace = _DEFAULT_WORKSPACE;
        }
        this._workspace = workspace;
        try {
            workspace.add(this);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(null, (Throwable)ex, "Internal error in NamedObj constructor!");
        }
        try {
            this.setName("");
        }
        catch (KernelException ex) {
            throw new InternalErrorException(null, (Throwable)ex, "Internal error in NamedObj constructor!");
        }
    }

    public NamedObj(Workspace workspace, String name) throws IllegalActionException {
        this(workspace, name, true);
    }

    protected NamedObj(Workspace workspace, String name, boolean incrementWorkspaceVersion) throws IllegalActionException {
        if (workspace == null) {
            workspace = _DEFAULT_WORKSPACE;
        }
        this._workspace = workspace;
        if (incrementWorkspaceVersion) {
            try {
                workspace.add(this);
                this.setName(name);
            }
            catch (NameDuplicationException ex) {
                throw new InternalErrorException(null, (Throwable)ex, "Internal error in NamedObj constructor!");
            }
        } else {
            this._name = name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ChangeListener listener) {
        NamedObj container = this.getContainer();
        if (container != null) {
            container.addChangeListener(listener);
        } else {
            Object object = this._changeLock;
            synchronized (object) {
                if (this._changeListeners == null) {
                    this._changeListeners = new LinkedList();
                } else {
                    this.removeChangeListener(listener);
                }
                this._changeListeners.add(0, new WeakReference<ChangeListener>(listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDebugListener(DebugListener listener) {
        Cloneable cloneable = this;
        synchronized (cloneable) {
            if (this._debugListeners == null) {
                this._debugListeners = new LinkedList();
            }
        }
        cloneable = this._debugListeners;
        synchronized (cloneable) {
            if (this._debugListeners.contains(listener)) {
                return;
            }
            this._debugListeners.add(listener);
            this._debugging = true;
        }
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List attributeList() {
        try {
            this._workspace.getReadAccess();
            if (this._attributes == null) {
                this._attributes = new NamedList();
            }
            List list = this._attributes.elementList();
            return list;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List attributeList(Class filter) {
        try {
            this._workspace.getReadAccess();
            if (this._attributes == null) {
                this._attributes = new NamedList();
            }
            LinkedList result = new LinkedList();
            for (Object attribute : this._attributes.elementList()) {
                if (!filter.isInstance(attribute)) continue;
                result.add(attribute);
            }
            LinkedList linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public void attributeTypeChanged(Attribute attribute) throws IllegalActionException {
    }

    public Object clone() throws CloneNotSupportedException {
        return this.clone(this._workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        try {
            this._workspace.getReadAccess();
            NamedObj newObject = (NamedObj)super.clone();
            newObject._deferChangeRequests = true;
            newObject._attributes = null;
            newObject._workspace = workspace == null ? _DEFAULT_WORKSPACE : workspace;
            newObject._fullNameVersion = -1L;
            if (this._attributes != null) {
                for (Attribute parameter : this._attributes.elementList()) {
                    Attribute newParameter = (Attribute)parameter.clone(workspace);
                    try {
                        newParameter.setContainer(newObject);
                    }
                    catch (KernelException exception) {
                        throw new CloneNotSupportedException("Failed to clone attribute " + parameter.getFullName() + ": " + exception);
                    }
                }
            }
            if (this._debugging) {
                if (workspace == null) {
                    this._debug("Cloned", this.getFullName(), "into default workspace.");
                } else {
                    this._debug("Cloned", this.getFullName(), "into workspace:", workspace.getFullName());
                }
            }
            newObject._elementName = this._elementName;
            newObject._source = this._source;
            if (this._override != null) {
                newObject._override = new LinkedList(this._override);
            }
            newObject.setClassName(this.getClassName());
            this._cloneFixAttributeFields(newObject);
            NamedObj namedObj = newObject;
            return namedObj;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Iterator containedObjectsIterator() {
        return new ContainedObjectsIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deepContains(NamedObj inside) {
        try {
            this._workspace.getReadAccess();
            if (inside != null) {
                if (this._workspace != inside._workspace) {
                    boolean bl = false;
                    return bl;
                }
                for (NamedObj container = inside.getContainer(); container != null; container = container.getContainer()) {
                    if (container != this) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public int depthInHierarchy() {
        int result = 0;
        for (NamedObj container = this.getContainer(); container != null; container = container.getContainer()) {
            ++result;
        }
        return result;
    }

    @Override
    public String description() {
        return this.description(-1);
    }

    public String description(int detail) {
        return this._description(detail, 0, 0);
    }

    @Override
    public void event(DebugEvent event) {
        if (this._debugging) {
            this._debug(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeChangeRequests() {
        NamedObj container = this.getContainer();
        if (container != null) {
            container.executeChangeRequests();
            return;
        }
        LinkedList copy = null;
        Object object = this._changeLock;
        synchronized (object) {
            if (this._changeRequests != null && this._changeRequests.size() > 0) {
                copy = new LinkedList(this._changeRequests);
                this._changeRequests.clear();
            }
        }
        if (copy != null) {
            Iterator requests = copy.iterator();
            boolean previousDeferStatus = this.isDeferringChangeRequests();
            try {
                previousDeferStatus = this.setDeferringChangeRequests(true);
                while (requests.hasNext()) {
                    ChangeRequest change = (ChangeRequest)requests.next();
                    change.setListeners(this._changeListeners);
                    if (this._debugging) {
                        this._debug("-- Executing change request with description: " + change.getDescription());
                    }
                    change.execute();
                }
            }
            finally {
                this.setDeferringChangeRequests(previousDeferStatus);
            }
            this.executeChangeRequests();
        }
    }

    @Override
    public final String exportMoML() {
        try {
            StringWriter buffer = new StringWriter();
            this.exportMoML(buffer, 0);
            return buffer.toString();
        }
        catch (IOException ex) {
            throw new InternalErrorException(this, (Throwable)ex, null);
        }
    }

    @Override
    public final String exportMoML(String name) {
        try {
            StringWriter buffer = new StringWriter();
            this.exportMoML(buffer, 0, name);
            return buffer.toString();
        }
        catch (IOException ex) {
            throw new InternalErrorException(this, (Throwable)ex, null);
        }
    }

    @Override
    public final void exportMoML(Writer output) throws IOException {
        this.exportMoML(output, 0);
    }

    @Override
    public final void exportMoML(Writer output, int depth) throws IOException {
        this.exportMoML(output, depth, this.getName());
    }

    @Override
    public void exportMoML(Writer output, int depth, String name) throws IOException {
        if (this._isMoMLSuppressed(depth)) {
            return;
        }
        String className = this.getClassName();
        if (depth == 0 && this.getContainer() == null) {
            output.write("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE " + this._elementName + " PUBLIC " + "\"-//UC Berkeley//DTD MoML 1//EN\"\n" + "    \"http://ptolemy.eecs.berkeley.edu" + "/xml/dtd/MoML_1.dtd\">\n");
        }
        output.write(NamedObj._getIndentPrefix(depth) + "<" + this._elementName + " name=\"" + name + "\" class=\"" + className + "\"");
        if (this.getSource() != null) {
            output.write(" source=\"" + this.getSource() + "\">\n");
        } else {
            output.write(">\n");
        }
        if (this._displayName != null) {
            output.write("<display name=\"");
            output.write(StringUtilities.escapeForXML(this._displayName));
            output.write("\"/>");
        }
        this._exportMoMLContents(output, depth + 1);
        output.write(NamedObj._getIndentPrefix(depth) + "</" + this._elementName + ">\n");
    }

    public final String exportMoMLPlain() {
        try {
            StringWriter buffer = new StringWriter();
            this.exportMoML(buffer, 1, this.getName());
            return buffer.toString();
        }
        catch (IOException ex) {
            throw new InternalErrorException(this, (Throwable)ex, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute getAttribute(String name) {
        try {
            this._workspace.getReadAccess();
            if (this._attributes == null) {
                Attribute attribute = null;
                return attribute;
            }
            if (name == null) {
                throw new InternalErrorException(this, null, "This should not be happening: getAttribute() was called with a null name");
            }
            int period = name.indexOf(".");
            if (period < 0) {
                Attribute attribute = (Attribute)this._attributes.get(name);
                return attribute;
            }
            Attribute match = (Attribute)this._attributes.get(name.substring(0, period));
            if (match == null) {
                Attribute attribute = null;
                return attribute;
            }
            Attribute attribute = match.getAttribute(name.substring(period + 1));
            return attribute;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Attribute getAttribute(String name, Class attributeClass) throws IllegalActionException {
        Attribute attribute = this.getAttribute(name);
        if (attribute != null && !attributeClass.isInstance(attribute)) {
            throw new IllegalActionException((Nameable)attribute, "Expected attribute of class " + attributeClass.getName() + " but got attribute of class " + attribute.getClass().getName());
        }
        return attribute;
    }

    public Enumeration getAttributes() {
        return Collections.enumeration(this.attributeList());
    }

    public List getChangeListeners() {
        return this._changeListeners;
    }

    @Override
    public String getClassName() {
        if (this._className == null) {
            this._className = this.getClass().getName();
        }
        return this._className;
    }

    @Override
    public NamedObj getContainer() {
        return null;
    }

    @Override
    public int getDerivedLevel() {
        return this._derivedLevel;
    }

    @Override
    public List getDerivedList() {
        try {
            return this._getDerivedList(null, false, false, this, 0, null, null);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(ex);
        }
    }

    @Override
    public String getDisplayName() {
        if (this._displayName != null) {
            return this._displayName;
        }
        return this.getName();
    }

    @Override
    public String getElementName() {
        return this._elementName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFullName() {
        try {
            this._workspace.getReadAccess();
            if (this._fullNameVersion == this._workspace.getVersion()) {
                String string = this._fullNameCache;
                return string;
            }
            String fullName = this.getName();
            HashSet<NamedObj> visited = new HashSet<NamedObj>();
            visited.add(this);
            for (NamedObj container = this.getContainer(); container != null; container = container.getContainer()) {
                if (visited.contains(container)) {
                    throw new InvalidStateException("Container contains itself!");
                }
                fullName = container.getName() + "." + fullName;
                visited.add(container);
            }
            this._fullNameCache = "." + fullName;
            this._fullNameVersion = this._workspace.getVersion();
            String string = this._fullNameCache;
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public ModelErrorHandler getModelErrorHandler() {
        return this._modelErrorHandler;
    }

    @Override
    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName(NamedObj parent) throws InvalidStateException {
        if (parent == null) {
            return this.getFullName();
        }
        try {
            NamedObj container;
            this._workspace.getReadAccess();
            StringBuffer name = new StringBuffer(this.getName());
            HashSet<NamedObj> visited = new HashSet<NamedObj>();
            visited.add(this);
            for (container = this.getContainer(); container != null && container != parent; container = container.getContainer()) {
                if (visited.contains(container)) {
                    throw new InvalidStateException("Container contains itself!");
                }
                name.insert(0, ".");
                name.insert(0, container.getName());
                visited.add(container);
            }
            if (container == null) {
                String string = this.getFullName();
                return string;
            }
            String string = name.toString();
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    @Override
    public List getPrototypeList() throws IllegalActionException {
        LinkedList<NamedObj> result = new LinkedList<NamedObj>();
        String relativeName = this.getName();
        for (NamedObj container = this.getContainer(); container != null; container = container.getContainer()) {
            NamedObj prototype;
            Instantiable parent;
            if (container instanceof Instantiable && (parent = ((Instantiable)((Object)container)).getParent()) != null && (prototype = this._getContainedObject((NamedObj)((Object)parent), relativeName)) != null) {
                result.add(prototype);
            }
            relativeName = container.getName() + "." + relativeName;
        }
        return result;
    }

    @Override
    public String getSource() {
        return this._source;
    }

    @Override
    public boolean handleModelError(NamedObj context, IllegalActionException exception) throws IllegalActionException {
        if (this._modelErrorHandler != null && this._modelErrorHandler.handleModelError(context, exception)) {
            return true;
        }
        NamedObj container = this.getContainer();
        if (container != null) {
            return container.handleModelError(context, exception);
        }
        return false;
    }

    @Override
    public boolean isDeferringChangeRequests() {
        NamedObj container = this.getContainer();
        if (container != null) {
            return container.isDeferringChangeRequests();
        }
        return this._deferChangeRequests;
    }

    public boolean isOverridden() {
        if (this._override == null) {
            return false;
        }
        if (this._override.size() != 1) {
            return false;
        }
        int override = (Integer)this._override.get(0);
        return override == 0;
    }

    @Override
    public boolean isPersistent() {
        return this._isPersistent == null || this._isPersistent != false;
    }

    @Override
    public void message(String message) {
        if (this._debugging) {
            this._debug(message);
        }
    }

    @Override
    public int moveDown() throws IllegalActionException {
        throw new IllegalActionException((Nameable)this, "Has no container.");
    }

    @Override
    public int moveToFirst() throws IllegalActionException {
        throw new IllegalActionException((Nameable)this, "Has no container.");
    }

    @Override
    public int moveToIndex(int index) throws IllegalActionException {
        throw new IllegalActionException((Nameable)this, "Has no container.");
    }

    @Override
    public int moveToLast() throws IllegalActionException {
        throw new IllegalActionException((Nameable)this, "Has no container.");
    }

    @Override
    public int moveUp() throws IllegalActionException {
        throw new IllegalActionException((Nameable)this, "Has no container.");
    }

    @Override
    public List propagateExistence() throws IllegalActionException {
        return this._getDerivedList(null, false, true, this, 0, null, null);
    }

    @Override
    public List propagateValue() throws IllegalActionException {
        this._override = new LinkedList();
        this._override.add(0);
        return this._getDerivedList(null, true, false, this, 0, this._override, null);
    }

    public void propagateValues() throws IllegalActionException {
        if (this._override != null) {
            this._getDerivedList(null, true, false, this, 0, this._override, null);
        }
        Iterator containedObjects = this.containedObjectsIterator();
        while (containedObjects.hasNext()) {
            NamedObj containedObject = (NamedObj)containedObjects.next();
            containedObject.propagateValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeChangeListener(ChangeListener listener) {
        NamedObj container = this.getContainer();
        if (container != null) {
            container.removeChangeListener(listener);
        } else {
            Object object = this._changeLock;
            synchronized (object) {
                if (this._changeListeners != null) {
                    ListIterator listeners = this._changeListeners.listIterator();
                    while (listeners.hasNext()) {
                        WeakReference reference = (WeakReference)listeners.next();
                        if (reference.get() == listener) {
                            listeners.remove();
                            continue;
                        }
                        if (reference.get() != null) continue;
                        listeners.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDebugListener(DebugListener listener) {
        if (this._debugListeners == null) {
            return;
        }
        LinkedList linkedList = this._debugListeners;
        synchronized (linkedList) {
            this._debugListeners.remove(listener);
            if (this._debugListeners.size() == 0) {
                this._debugging = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestChange(ChangeRequest change) {
        NamedObj container = this.getContainer();
        if (container != null) {
            container.requestChange(change);
        } else {
            Object object = this._changeLock;
            synchronized (object) {
                if (this._changeRequests == null) {
                    this._changeRequests = new LinkedList();
                }
                this._changeRequests.add(change);
                if (!this._deferChangeRequests) {
                    this.executeChangeRequests();
                }
            }
        }
    }

    public void setClassName(String name) {
        this._className = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDeferringChangeRequests(boolean isDeferring) {
        NamedObj container = this.getContainer();
        if (container != null) {
            return container.setDeferringChangeRequests(isDeferring);
        }
        Object object = this._changeLock;
        synchronized (object) {
            boolean result = this._deferChangeRequests;
            this._deferChangeRequests = isDeferring;
            if (!isDeferring) {
                this.executeChangeRequests();
            }
            return result;
        }
    }

    public final void setDerivedLevel(int level) {
        if (level < this._derivedLevel) {
            this._derivedLevel = level;
        }
        this._override = null;
    }

    public void setDisplayName(String name) {
        this._displayName = name;
    }

    public void setModelErrorHandler(ModelErrorHandler handler) {
        this._modelErrorHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) throws IllegalActionException, NameDuplicationException {
        String oldName = "";
        if (this._debugging) {
            oldName = this.getFullName();
        }
        if (name == null) {
            name = "";
        }
        if (name.equals(this._name)) {
            return;
        }
        int period = name.indexOf(".");
        if (period >= 0) {
            throw new IllegalActionException((Nameable)this, "Cannot set a name with a period: " + name);
        }
        try {
            this._workspace.getWriteAccess();
            this._name = name;
        }
        finally {
            this._workspace.doneWriting();
        }
        if (this._debugging) {
            this._debug("Changed name from " + oldName + " to " + this.getFullName());
        }
    }

    @Override
    public void setPersistent(boolean persistent) {
        this._isPersistent = persistent ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setSource(String source) {
        this._source = source;
    }

    public List sortContainedObjects(Collection filter) {
        LinkedList<NamedObj> result = new LinkedList<NamedObj>();
        Iterator containedObjects = this.containedObjectsIterator();
        while (containedObjects.hasNext()) {
            NamedObj object = (NamedObj)containedObjects.next();
            if (!filter.contains(object)) continue;
            result.add(object);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getName() + " {" + this.getFullName() + "}";
    }

    public NamedObj toplevel() {
        NamedObj result = this;
        while (result.getContainer() != null) {
            result = result.getContainer();
        }
        return result;
    }

    public String uniqueName(String prefix) {
        if (prefix == null) {
            prefix = "null";
        }
        String candidate = prefix = NamedObj._stripNumericSuffix(prefix);
        int uniqueNameIndex = 2;
        while (this.getAttribute(candidate) != null) {
            candidate = prefix + uniqueNameIndex++;
        }
        return candidate;
    }

    public void validateSettables() throws IllegalActionException {
        this._validateSettables(new HashSet());
    }

    public final Workspace workspace() {
        return this._workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addAttribute(Attribute p) throws NameDuplicationException, IllegalActionException {
        try {
            this._workspace.getWriteAccess();
            try {
                if (this._attributes == null) {
                    this._attributes = new NamedList();
                }
                this._attributes.append(p);
            }
            catch (IllegalActionException ex) {
                throw new InternalErrorException(null, (Throwable)ex, "Internal error in NamedObj _addAttribute() method!");
            }
            if (this._debugging) {
                this._debug("Added attribute", p.getName(), "to", this.getFullName());
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    protected void _adjustOverride(int depth) {
        if (this._override != null) {
            while (this._override.size() <= depth) {
                this._override.add(0);
            }
            int breadth = (Integer)this._override.get(depth);
            this._override.set(depth, breadth + 1);
        }
        Iterator objects = this.containedObjectsIterator();
        while (objects.hasNext()) {
            NamedObj object = (NamedObj)objects.next();
            object._adjustOverride(depth + 1);
        }
    }

    protected void _attachText(String name, String text) {
        try {
            SingletonConfigurableAttribute icon = new SingletonConfigurableAttribute(this, name);
            icon.setPersistent(false);
            icon.configure(null, null, text);
        }
        catch (Exception ex) {
            throw new InternalErrorException(this, (Throwable)ex, "Error creating singleton attribute named " + name + " for " + this.getFullName());
        }
    }

    protected void _cloneFixAttributeFields(NamedObj newObject) throws CloneNotSupportedException {
        Class<?> myClass = this.getClass();
        Field[] fields = myClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Object object;
                if (Modifier.isFinal(fields[i].getModifiers()) || !((object = fields[i].get(this)) instanceof Attribute)) continue;
                String name = ((NamedObj)object).getName(this);
                fields[i].set(newObject, newObject.getAttribute(name));
                continue;
            }
            catch (IllegalAccessException ex) {
                CloneNotSupportedException cloneException = new CloneNotSupportedException("The field associated with " + fields[i].getName() + " could not be automatically cloned because " + ex.getMessage() + ".  This can be caused if " + "the field is not defined in a public class.");
                cloneException.initCause(ex);
                throw cloneException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _debug(DebugEvent event) {
        if (this._debugging) {
            ArrayList list;
            LinkedList linkedList = this._debugListeners;
            synchronized (linkedList) {
                list = new ArrayList(this._debugListeners);
            }
            Iterator listeners = list.iterator();
            while (listeners.hasNext()) {
                ((DebugListener)listeners.next()).event(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _debug(String message) {
        if (this._debugging) {
            ArrayList list;
            LinkedList linkedList = this._debugListeners;
            synchronized (linkedList) {
                list = new ArrayList(this._debugListeners);
            }
            Iterator listeners = list.iterator();
            while (listeners.hasNext()) {
                ((DebugListener)listeners.next()).message(message);
            }
        }
    }

    protected final void _debug(String part1, String part2) {
        if (this._debugging) {
            this._debug(part1 + " " + part2);
        }
    }

    protected final void _debug(String part1, String part2, String part3) {
        if (this._debugging) {
            this._debug(part1 + " " + part2 + " " + part3);
        }
    }

    protected final void _debug(String part1, String part2, String part3, String part4) {
        if (this._debugging) {
            this._debug(part1 + " " + part2 + " " + part3 + " " + part4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _description(int detail, int indent, int bracket) {
        try {
            this._workspace.getReadAccess();
            StringBuffer result = new StringBuffer(NamedObj._getIndentPrefix(indent));
            if (bracket == 1 || bracket == 2) {
                result.append("{");
            }
            if ((detail & 1) != 0) {
                result.append(this.getClass().getName());
                if ((detail & 2) != 0) {
                    result.append(" ");
                }
            }
            if ((detail & 2) != 0) {
                result.append("{" + this.getFullName() + "}");
            }
            if ((detail & 0x20) != 0) {
                if ((detail & 3) != 0) {
                    result.append(" ");
                }
                result.append("attributes {\n");
                if ((detail & 0x10) == 0) {
                    detail &= 0xFFFFFFDF;
                }
                if (this._attributes != null) {
                    for (Attribute parameter : this._attributes.elementList()) {
                        result.append(parameter._description(detail, indent + 1, 2) + "\n");
                    }
                }
                result.append(NamedObj._getIndentPrefix(indent) + "}");
            }
            if (bracket == 2) {
                result.append("}");
            }
            String string = result.toString();
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        if (this._attributes != null) {
            for (Attribute attribute : this._attributes.elementList()) {
                attribute.exportMoML(output, depth);
            }
        }
    }

    protected NamedObj _getContainedObject(NamedObj container, String relativeName) throws IllegalActionException {
        return null;
    }

    protected static String _getIndentPrefix(int level) {
        return StringUtilities.getIndentPrefix(level);
    }

    protected boolean _isMoMLSuppressed(int depth) {
        if (this._isPersistent != null) {
            return this._isPersistent == false;
        }
        if (this._derivedLevel > depth) {
            return false;
        }
        if (this._override != null) {
            if (this._override.size() > depth + 1) {
                return false;
            }
            if (this._override.size() == 1 && (Integer)this._override.get(0) == 0) {
                return false;
            }
        }
        Iterator objects = this.containedObjectsIterator();
        while (objects.hasNext()) {
            NamedObj object = (NamedObj)objects.next();
            if (object._isMoMLSuppressed(depth + 1)) continue;
            return false;
        }
        return true;
    }

    protected void _markContentsDerived(int depth) {
        ++depth;
        Iterator objects = this.containedObjectsIterator();
        while (objects.hasNext()) {
            NamedObj containedObject = (NamedObj)objects.next();
            if (depth < containedObject._derivedLevel) {
                containedObject._derivedLevel = depth;
            }
            containedObject._markContentsDerived(depth);
            if (containedObject._isPersistent == null || !containedObject._isPersistent.booleanValue()) continue;
            containedObject._isPersistent = null;
        }
    }

    protected NamedObj _propagateExistence(NamedObj container) throws IllegalActionException {
        try {
            if (container == null) {
                throw new IllegalActionException((Nameable)this, "Attempting to propagate into a null container");
            }
            return (NamedObj)this.clone(container.workspace());
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalActionException((Nameable)this, e, "Failed to propagate instance.");
        }
    }

    protected void _propagateValue(NamedObj destination) throws IllegalActionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeAttribute(Attribute param) {
        try {
            this._workspace.getWriteAccess();
            this._attributes.remove(param);
            if (this._debugging) {
                this._debug("Removed attribute", param.getName(), "from", this.getFullName());
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    protected static final String[] _splitName(String name) {
        String[] result = new String[2];
        int period = name.indexOf(".");
        if (period < 0) {
            result[0] = name;
        } else {
            result[0] = name.substring(0, period);
            result[1] = name.substring(period + 1);
        }
        return result;
    }

    protected static String _stripNumericSuffix(String string) {
        char current;
        int length = string.length();
        char[] chars = string.toCharArray();
        for (int i = length - 1; i >= 0 && Character.isDigit(current = chars[i]); --i) {
            --length;
        }
        if (length < string.length()) {
            char[] result = new char[length];
            System.arraycopy(chars, 0, result, 0, length);
            return new String(result);
        }
        return string;
    }

    protected void _validateSettables(Collection attributesValidated) throws IllegalActionException {
        for (Settable attribute : this.attributeList(Settable.class)) {
            block4: {
                if (attributesValidated.contains(attribute)) continue;
                try {
                    Collection validated = attribute.validate();
                    if (validated != null) {
                        attributesValidated.addAll(validated);
                    }
                    attributesValidated.add(attribute);
                }
                catch (IllegalActionException ex) {
                    if (this.handleModelError(this, ex)) break block4;
                    throw ex;
                }
            }
            ((NamedObj)((Object)attribute))._validateSettables(attributesValidated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List _getDerivedList(Collection visited, boolean propagate, boolean force, NamedObj context, int depth, List override, String relativeName) throws IllegalActionException {
        try {
            List othersList;
            Object newRelativeName;
            this.workspace().getReadAccess();
            LinkedList<NamedObj> result = new LinkedList<NamedObj>();
            if (visited == null) {
                visited = new HashSet<NamedObj>();
            } else if (visited.contains(context)) {
                LinkedList<NamedObj> linkedList = result;
                return linkedList;
            }
            visited.add(context);
            NamedObj container = context.getContainer();
            if (container != null) {
                newRelativeName = relativeName == null ? context.getName() : context.getName() + "." + relativeName;
                LinkedList<Integer> newOverride = null;
                if (propagate && (newOverride = new LinkedList<Integer>(override)).size() <= depth + 1) {
                    newOverride.add(0);
                }
                result.addAll(this._getDerivedList(visited, propagate, force, container, depth + 1, newOverride, (String)newRelativeName));
            }
            if (!(context instanceof Instantiable)) {
                newRelativeName = result;
                return newRelativeName;
            }
            int myBreadth = 0;
            if (propagate) {
                myBreadth = (Integer)override.get(depth);
            }
            if ((othersList = ((Instantiable)((Object)context)).getChildren()) != null) {
                for (WeakReference reference : othersList) {
                    NamedObj other = (NamedObj)reference.get();
                    if (other == null) continue;
                    NamedObj candidate = other;
                    if (relativeName != null) {
                        candidate = this._getContainedObject(other, relativeName);
                    }
                    if (candidate == null) {
                        if (!force) continue;
                        NamedObj remoteContainer = other;
                        int lastPeriod = relativeName.lastIndexOf(".");
                        if (lastPeriod > 0) {
                            String containerName = relativeName.substring(0, lastPeriod);
                            remoteContainer = this.getContainer()._getContainedObject(other, containerName);
                        }
                        candidate = this._propagateExistence(remoteContainer);
                        if (depth < candidate._derivedLevel) {
                            candidate._derivedLevel = depth;
                        }
                        candidate._markContentsDerived(depth);
                        candidate._adjustOverride(depth);
                    }
                    if (visited.contains(candidate)) continue;
                    LinkedList<Integer> newOverride = null;
                    if (propagate) {
                        newOverride = new LinkedList<Integer>(override);
                        newOverride.set(depth, myBreadth + 1);
                        if (this._isShadowed(candidate._override, newOverride)) continue;
                        this._propagateValue(candidate);
                        candidate._override = newOverride;
                    }
                    result.add(candidate);
                    result.addAll(candidate._getDerivedList(visited, propagate, force, candidate, 0, newOverride, null));
                }
            }
            LinkedList<NamedObj> linkedList = result;
            return linkedList;
        }
        finally {
            this.workspace().doneReading();
        }
    }

    private boolean _isShadowed(List candidate, List changer) {
        if (candidate == null) {
            return false;
        }
        if (changer == null) {
            return true;
        }
        if (candidate.size() < changer.size()) {
            return true;
        }
        if (candidate.size() == changer.size()) {
            int changerBreadth;
            int index;
            for (index = candidate.size() - 1; index >= 0 && candidate.get(index).equals(changer.get(index)); --index) {
            }
            if (index < 0) {
                return false;
            }
            int candidateBreadth = (Integer)candidate.get(index);
            if (candidateBreadth < (changerBreadth = ((Integer)changer.get(index)).intValue())) {
                return true;
            }
        }
        return false;
    }

    private static class SerializableObject
    implements Serializable {
        private SerializableObject() {
        }
    }

    protected class ContainedObjectsIterator
    implements Iterator {
        private Iterator _attributeListIterator = null;

        public ContainedObjectsIterator() {
            this._attributeListIterator = NamedObj.this.attributeList().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._attributeListIterator.hasNext();
        }

        public Object next() {
            return this._attributeListIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported because attributeList().iterator() returns a NamedList that is unmodifiable");
        }
    }
}

