/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import java.util.StringTokenizer;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Quantization;
import ptolemy.math.Rounding;

public class FixPointQuantization
extends Quantization {
    protected Precision _precision = null;

    public FixPointQuantization(String string) throws IllegalArgumentException {
        super(Overflow.SATURATE, Rounding.NEAREST);
        StringTokenizer st;
        int strLen = string.length();
        if (strLen >= 2 && string.charAt(0) == '(' && string.charAt(strLen - 1) == ')') {
            string = string.substring(1, strLen - 1);
        }
        if (!(st = new StringTokenizer(string, ",")).hasMoreTokens()) {
            throw new IllegalArgumentException("A precision string consisting of two integers separated  by a '/', or '.' token is required");
        }
        this._precision = new Precision(st.nextToken());
        if (st.hasMoreTokens()) {
            this._overflow = Overflow.getName(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            this._rounding = Rounding.getName(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            throw new IllegalArgumentException("FixPointQuantization requires at most a precision overflow and rounding,");
        }
    }

    public FixPointQuantization(Precision precision, Overflow overflow, Rounding rounding) {
        super(overflow, rounding);
        this._precision = precision;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof FixPointQuantization) {
            FixPointQuantization other = (FixPointQuantization)object;
            if (this._precision.equals(other._precision)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Precision getMantissaPrecision() {
        return this._precision;
    }

    @Override
    public Precision getPrecision() {
        return this._precision;
    }

    @Override
    public int hashCode() {
        return super.hashCode() >>> this._precision.hashCode();
    }

    public FixPointQuantization setOverflow(Overflow overflow) {
        return new FixPointQuantization(this._precision, overflow, this.getRounding());
    }

    public FixPointQuantization setPrecision(Precision precision) {
        return new FixPointQuantization(precision, this.getOverflow(), this.getRounding());
    }

    public FixPointQuantization setRounding(Rounding rounding) {
        return new FixPointQuantization(this._precision, this.getOverflow(), rounding);
    }

    @Override
    public String toString() {
        return "(" + this._precision.getIntegerBitLength() + "." + this._precision.getFractionBitLength() + "," + this.getOverflow().toString() + "," + this.getRounding().toString() + ")";
    }
}

