/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.ExtendedMath;

public class Fraction {
    public static final Fraction ZERO = new Fraction(0, 1);
    private int _numerator;
    private int _denominator;

    public Fraction() {
        this._numerator = 0;
        this._denominator = 1;
        this._simplify();
    }

    public Fraction(int i) {
        this._numerator = i;
        this._denominator = 1;
        this._simplify();
    }

    public Fraction(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("Illegal Fraction: cannot have denominator of zero.");
        }
        this._numerator = numerator;
        this._denominator = denominator;
        this._simplify();
    }

    public Fraction(Fraction f) {
        this._numerator = f._numerator;
        this._denominator = f._denominator;
    }

    public Fraction add(Fraction b) {
        Fraction f = new Fraction(this._numerator * b._denominator + this._denominator * b._numerator, this._denominator * b._denominator);
        return f;
    }

    public Fraction divide(Fraction b) {
        if (b.equals(ZERO)) {
            throw new ArithmeticException("Division by zero!");
        }
        Fraction f = new Fraction(this._numerator * b._denominator, this._denominator * b._numerator);
        return f;
    }

    public boolean equals(Object b) {
        if (b instanceof Fraction) {
            return this._numerator == ((Fraction)b)._numerator && this._denominator == ((Fraction)b)._denominator;
        }
        return false;
    }

    public int getDenominator() {
        return this._denominator;
    }

    public int getNumerator() {
        return this._numerator;
    }

    public boolean greaterThan(Fraction testInput) {
        int inputScaled;
        int gcd = ExtendedMath.gcd(testInput.getDenominator(), this.getDenominator());
        int thisScaled = this.multiply(new Fraction(gcd, 1)).getNumerator();
        return thisScaled > (inputScaled = testInput.multiply(new Fraction(gcd, 1)).getNumerator());
    }

    public int hashCode() {
        return Integer.valueOf(this._denominator).hashCode() & Integer.valueOf(this._numerator).hashCode();
    }

    public Fraction inverse() {
        if (this.equals(ZERO)) {
            throw new ArithmeticException("Inverse of zero is undefined!");
        }
        Fraction f = new Fraction(this._denominator, this._numerator);
        return f;
    }

    public static int lcm(int u, int v) {
        int gcd = ExtendedMath.gcd(u, v);
        int result = u * v / gcd;
        return result;
    }

    public Fraction multiply(Fraction b) {
        Fraction f = new Fraction(this._numerator * b._numerator, this._denominator * b._denominator);
        return f;
    }

    public Fraction negate() {
        Fraction f = new Fraction(-this._numerator, this._denominator);
        return f;
    }

    public Fraction subtract(Fraction b) {
        Fraction f = new Fraction(this._numerator * b._denominator - this._denominator * b._numerator, this._denominator * b._denominator);
        return f;
    }

    public double toDouble() {
        double numerator = this._numerator;
        double denominator = this._denominator;
        return numerator / denominator;
    }

    public float toFloat() {
        float numerator = this._numerator;
        float denominator = this._denominator;
        return numerator / denominator;
    }

    public String toString() {
        this._simplify();
        return this._numerator + "/" + this._denominator;
    }

    protected void _simplify() {
        int factor = ExtendedMath.gcd(this._numerator, this._denominator);
        this._numerator /= factor;
        this._denominator /= factor;
        if (this._denominator < 0) {
            this._denominator = -this._denominator;
            this._numerator = -this._numerator;
        }
    }
}

