/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.LongBinaryOperation;
import ptolemy.math.LongUnaryOperation;

public class LongMatrixMath {
    private LongMatrixMath() {
    }

    public static final long[][] add(long[][] matrix, long z) {
        long[][] returnValue = new long[LongMatrixMath._rows(matrix)][LongMatrixMath._columns(matrix)];
        for (int i = 0; i < LongMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < LongMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j] + z;
            }
        }
        return returnValue;
    }

    public static final long[][] add(long[][] matrix1, long[][] matrix2) {
        LongMatrixMath._checkSameDimension("add", matrix1, matrix2);
        long[][] returnValue = new long[LongMatrixMath._rows(matrix1)][LongMatrixMath._columns(matrix1)];
        for (int i = 0; i < LongMatrixMath._rows(matrix1); ++i) {
            for (int j = 0; j < LongMatrixMath._columns(matrix1); ++j) {
                returnValue[i][j] = matrix1[i][j] + matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final long[][] allocCopy(long[][] matrix) {
        return LongMatrixMath.crop(matrix, 0, 0, LongMatrixMath._rows(matrix), LongMatrixMath._columns(matrix));
    }

    public static final long[][] applyBinaryOperation(LongBinaryOperation op, long z, long[][] matrix) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(z, matrix[i][j]);
            }
        }
        return returnValue;
    }

    public static final long[][] applyBinaryOperation(LongBinaryOperation op, long[][] matrix, long z) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix[i][j], z);
            }
        }
        return returnValue;
    }

    public static final long[][] applyBinaryOperation(LongBinaryOperation op, long[][] matrix1, long[][] matrix2) {
        int rows = LongMatrixMath._rows(matrix1);
        int columns = LongMatrixMath._columns(matrix1);
        LongMatrixMath._checkSameDimension("applyBinaryOperation", matrix1, matrix2);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix1[i][j], matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final long[][] applyUnaryOperation(LongUnaryOperation op, long[][] matrix) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix[i][j]);
            }
        }
        return returnValue;
    }

    public static final long[][] bitwiseAnd(long[][] matrix, long z) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j] & z;
            }
        }
        return returnValue;
    }

    public static final long[][] bitwiseAnd(long[][] matrix1, long[][] matrix2) {
        int rows = LongMatrixMath._rows(matrix1);
        int columns = LongMatrixMath._columns(matrix1);
        LongMatrixMath._checkSameDimension("bitwiseAnd", matrix1, matrix2);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] & matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final long[][] bitwiseComplement(long[][] matrix) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        return returnValue;
    }

    public static final long[][] bitwiseOr(long[][] matrix, long z) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j] | z;
            }
        }
        return returnValue;
    }

    public static final long[][] bitwiseOr(long[][] matrix1, long[][] matrix2) {
        int rows = LongMatrixMath._rows(matrix1);
        int columns = LongMatrixMath._columns(matrix1);
        LongMatrixMath._checkSameDimension("bitwiseOr", matrix1, matrix2);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] | matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final long[][] bitwiseXor(long[][] matrix, long z) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j] ^ z;
            }
        }
        return returnValue;
    }

    public static final long[][] bitwiseXor(long[][] matrix1, long[][] matrix2) {
        int rows = LongMatrixMath._rows(matrix1);
        int columns = LongMatrixMath._columns(matrix1);
        LongMatrixMath._checkSameDimension("bitwiseXor", matrix1, matrix2);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] ^ matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final long[][] crop(long[][] matrix, int rowStart, int colStart, int rowSpan, int colSpan) {
        long[][] returnValue = new long[rowSpan][colSpan];
        for (int i = 0; i < rowSpan; ++i) {
            System.arraycopy(matrix[rowStart + i], colStart, returnValue[i], 0, colSpan);
        }
        return returnValue;
    }

    public static final long[][] diag(long[] array) {
        int n = array.length;
        long[][] returnValue = new long[n][n];
        for (int i = 0; i < n; ++i) {
            returnValue[i][i] = array[i];
        }
        return returnValue;
    }

    public static final long[][] divide(long[][] matrix, long z) {
        long[][] returnValue = new long[LongMatrixMath._rows(matrix)][LongMatrixMath._columns(matrix)];
        for (int i = 0; i < LongMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < LongMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j] / z;
            }
        }
        return returnValue;
    }

    public static final long[][] divideElements(long[][] matrix1, long[][] matrix2) {
        int rows = LongMatrixMath._rows(matrix1);
        int columns = LongMatrixMath._columns(matrix1);
        LongMatrixMath._checkSameDimension("divideElements", matrix1, matrix2);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] / matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final long[] fromMatrixToArray(long[][] matrix) {
        return LongMatrixMath.fromMatrixToArray(matrix, LongMatrixMath._rows(matrix), LongMatrixMath._columns(matrix));
    }

    public static final long[] fromMatrixToArray(long[][] matrix, int maxRow, int maxCol) {
        long[] returnValue = new long[maxRow * maxCol];
        for (int i = 0; i < maxRow; ++i) {
            System.arraycopy(matrix[i], 0, returnValue, i * maxCol, maxCol);
        }
        return returnValue;
    }

    public static final long[][] identity(int dim) {
        long[][] returnValue = new long[dim][dim];
        for (int i = 0; i < dim; ++i) {
            returnValue[i][i] = 1L;
        }
        return returnValue;
    }

    public static final long[][] identityMatrixLong(int dim) {
        return LongMatrixMath.identity(dim);
    }

    public static final void matrixCopy(long[][] srcMatrix, long[][] destMatrix) {
        LongMatrixMath.matrixCopy(srcMatrix, 0, 0, destMatrix, 0, 0, LongMatrixMath._rows(srcMatrix), LongMatrixMath._columns(srcMatrix));
    }

    public static final void matrixCopy(long[][] srcMatrix, int srcRowStart, int srcColStart, long[][] destMatrix, int destRowStart, int destColStart, int rowSpan, int colSpan) {
        for (int i = 0; i < rowSpan; ++i) {
            System.arraycopy(srcMatrix[srcRowStart + i], srcColStart, destMatrix[destRowStart + i], destColStart, colSpan);
        }
    }

    public static final long[][] modulo(long[][] matrix, long z) {
        long[][] returnValue = new long[LongMatrixMath._rows(matrix)][LongMatrixMath._columns(matrix)];
        for (int i = 0; i < LongMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < LongMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j] % z;
            }
        }
        return returnValue;
    }

    public static final long[][] modulo(long[][] matrix1, long[][] matrix2) {
        int rows = LongMatrixMath._rows(matrix1);
        int columns = LongMatrixMath._columns(matrix1);
        LongMatrixMath._checkSameDimension("modulo", matrix1, matrix2);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] % matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final long[][] multiply(long[][] matrix, long scaleFactor) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j] * scaleFactor;
            }
        }
        return returnValue;
    }

    public static final long[] multiply(long[][] matrix, long[] array) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        if (rows != array.length) {
            throw new IllegalArgumentException("preMultiply : array does not have the same number of elements (" + array.length + ") as the number of rows " + "of the matrix (" + rows + ")");
        }
        long[] returnValue = new long[columns];
        for (int i = 0; i < columns; ++i) {
            long sum = 0L;
            for (int j = 0; j < rows; ++j) {
                sum += matrix[j][i] * array[j];
            }
            returnValue[i] = sum;
        }
        return returnValue;
    }

    public static final long[] multiply(long[] array, long[][] matrix) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        if (columns != array.length) {
            throw new IllegalArgumentException("postMultiply() : array does not have the same number of elements (" + array.length + ") as the number of " + "columns of the matrix (" + columns + ")");
        }
        long[] returnValue = new long[rows];
        for (int i = 0; i < rows; ++i) {
            long sum = 0L;
            for (int j = 0; j < columns; ++j) {
                sum += matrix[i][j] * array[j];
            }
            returnValue[i] = sum;
        }
        return returnValue;
    }

    public static final long[][] multiply(long[][] matrix1, long[][] matrix2) {
        long[][] returnValue = new long[LongMatrixMath._rows(matrix1)][matrix2[0].length];
        for (int i = 0; i < LongMatrixMath._rows(matrix1); ++i) {
            for (int j = 0; j < matrix2[0].length; ++j) {
                long sum = 0L;
                for (int k = 0; k < matrix2.length; ++k) {
                    sum += matrix1[i][k] * matrix2[k][j];
                }
                returnValue[i][j] = sum;
            }
        }
        return returnValue;
    }

    public static final long[][] multiplyElements(long[][] matrix1, long[][] matrix2) {
        int rows = LongMatrixMath._rows(matrix1);
        int columns = LongMatrixMath._columns(matrix1);
        LongMatrixMath._checkSameDimension("multiplyElements", matrix1, matrix2);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] * matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final long[][] negative(long[][] matrix) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = -matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final long[][] shiftArithmetic(long[][] matrix, int shiftAmount) {
        long[][] returnValue;
        block5: {
            int columns;
            int rows;
            block4: {
                rows = LongMatrixMath._rows(matrix);
                columns = LongMatrixMath._columns(matrix);
                returnValue = new long[rows][columns];
                if (shiftAmount < 0) break block4;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < columns; ++j) {
                        returnValue[i][j] = matrix[i][j] << shiftAmount;
                    }
                }
                break block5;
            }
            if (shiftAmount >= 0) break block5;
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    returnValue[i][j] = matrix[i][j] >>> -shiftAmount;
                }
            }
        }
        return returnValue;
    }

    public static final long[][] shiftLogical(long[][] matrix, int shiftAmount) {
        long[][] returnValue;
        block5: {
            int columns;
            int rows;
            block4: {
                rows = LongMatrixMath._rows(matrix);
                columns = LongMatrixMath._columns(matrix);
                returnValue = new long[rows][columns];
                if (shiftAmount < 0) break block4;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < columns; ++j) {
                        returnValue[i][j] = matrix[i][j] << shiftAmount;
                    }
                }
                break block5;
            }
            if (shiftAmount >= 0) break block5;
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    returnValue[i][j] = matrix[i][j] >> -shiftAmount;
                }
            }
        }
        return returnValue;
    }

    public static final long[][] subtract(long[][] matrix1, long[][] matrix2) {
        LongMatrixMath._checkSameDimension("subtract", matrix1, matrix2);
        int rows = LongMatrixMath._rows(matrix1);
        int columns = LongMatrixMath._columns(matrix1);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] - matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final long sum(long[][] matrix) {
        long sum = 0L;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                sum += matrix[i][j];
            }
        }
        return sum;
    }

    public static final Complex[][] toComplexMatrix(long[][] matrix) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = new Complex(matrix[i][j], 0.0);
            }
        }
        return returnValue;
    }

    public static final double[][] toDoubleMatrix(long[][] matrix) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final float[][] toFloatMatrix(long[][] matrix) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final int[][] toIntegerMatrix(long[][] matrix) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = (int)matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final long[][] toMatrixFromArray(long[] array, int rows, int cols) {
        long[][] returnValue = new long[rows][cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(array, i * cols, returnValue[i], 0, cols);
        }
        return returnValue;
    }

    public static final String toString(long[][] matrix) {
        return LongMatrixMath.toString(matrix, ", ", "{", "}", "{", ", ", "}");
    }

    public static final String toString(long[][] matrix, String elementDelimiter, String matrixBegin, String matrixEnd, String vectorBegin, String vectorDelimiter, String vectorEnd) {
        StringBuffer sb = new StringBuffer();
        sb.append(matrixBegin);
        for (int i = 0; i < LongMatrixMath._rows(matrix); ++i) {
            sb.append(vectorBegin);
            for (int j = 0; j < LongMatrixMath._columns(matrix); ++j) {
                sb.append(Long.toString(matrix[i][j]));
                if (j >= LongMatrixMath._columns(matrix) - 1) continue;
                sb.append(elementDelimiter);
            }
            sb.append(vectorEnd);
            if (i >= LongMatrixMath._rows(matrix) - 1) continue;
            sb.append(vectorDelimiter);
        }
        sb.append(matrixEnd);
        return new String(sb);
    }

    public static final long trace(long[][] matrix) {
        int dim = LongMatrixMath._checkSquare("trace", matrix);
        long sum = 0L;
        for (int i = 0; i < dim; ++i) {
            sum += matrix[i][i];
        }
        return sum;
    }

    public static final long[][] transpose(long[][] matrix) {
        int rows = LongMatrixMath._rows(matrix);
        int columns = LongMatrixMath._columns(matrix);
        long[][] returnValue = new long[columns][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[j][i] = matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final boolean within(long[][] matrix1, long[][] matrix2, long distance) {
        int rows = LongMatrixMath._rows(matrix1);
        int columns = LongMatrixMath._columns(matrix1);
        LongMatrixMath._checkSameDimension("within", matrix1, matrix2);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (matrix1[i][j] <= matrix2[i][j] + distance && matrix1[i][j] >= matrix2[i][j] - distance) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean within(long[][] matrix1, long[][] matrix2, long[][] errorMatrix) {
        int rows = LongMatrixMath._rows(matrix1);
        int columns = LongMatrixMath._columns(matrix1);
        LongMatrixMath._checkSameDimension("within", matrix1, matrix2);
        LongMatrixMath._checkSameDimension("within", matrix1, errorMatrix);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (matrix1[i][j] <= matrix2[i][j] + errorMatrix[i][j] && matrix1[i][j] >= matrix2[i][j] - errorMatrix[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    protected static final void _checkSameDimension(String caller, long[][] matrix1, long[][] matrix2) {
        int rows = LongMatrixMath._rows(matrix1);
        int columns = LongMatrixMath._columns(matrix1);
        if (rows != LongMatrixMath._rows(matrix2) || columns != LongMatrixMath._columns(matrix2)) {
            throw new IllegalArgumentException("ptolemy.math.LongMatrixMath." + caller + "() : one matrix " + LongMatrixMath._dimensionString(matrix1) + " is not the same size as another matrix " + LongMatrixMath._dimensionString(matrix2) + ".");
        }
    }

    protected static final int _checkSquare(String caller, long[][] matrix) {
        if (LongMatrixMath._rows(matrix) != LongMatrixMath._columns(matrix)) {
            throw new IllegalArgumentException("ptolemy.math.LongMatrixMath." + caller + "() : matrix argument " + LongMatrixMath._dimensionString(matrix) + " is not a square matrix.");
        }
        return LongMatrixMath._rows(matrix);
    }

    protected static final int _columns(long[][] matrix) {
        return matrix[0].length;
    }

    protected static final String _dimensionString(long[][] matrix) {
        return "[" + LongMatrixMath._rows(matrix) + " x " + LongMatrixMath._columns(matrix) + "]";
    }

    protected static final int _rows(long[][] matrix) {
        return matrix.length;
    }
}

