/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import java.io.Serializable;
import java.math.BigInteger;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Rounding;

public abstract class Quantization
implements Cloneable,
Serializable {
    protected Overflow _overflow = Overflow.GENERAL;
    protected Rounding _rounding = Rounding.GENERAL;

    public Quantization(Overflow overflow, Rounding rounding) {
        this._overflow = overflow;
        this._rounding = rounding;
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof Quantization) {
            Quantization other = (Quantization)object;
            if (this._overflow.equals(other._overflow) && this._rounding.equals(other._rounding)) {
                return true;
            }
        }
        return false;
    }

    public double getEpsilonValue() {
        double maxVal = this.getMaximumValue();
        double minVal = this.getMinimumValue();
        double modVal = this.getNumberOfLevels();
        return (maxVal - minVal) / (modVal - 1.0);
    }

    public boolean getExactOverflow() {
        return false;
    }

    public boolean getExactRounding() {
        return false;
    }

    public int getExponentBitLength() {
        return 0;
    }

    public int getFractionBitLength() {
        return this.getMantissaPrecision().getFractionBitLength();
    }

    public int getIntegerBitLength() {
        return this.getMantissaPrecision().getIntegerBitLength();
    }

    public int getMantissaBitLength() {
        return this.getIntegerBitLength() + this.getFractionBitLength();
    }

    public abstract Precision getMantissaPrecision();

    public BigInteger getMaximumUnscaledValue() {
        int numBits = this.getNumberOfBits();
        return BigInteger.ZERO.setBit(numBits - 1).subtract(BigInteger.ONE);
    }

    public double getMaximumValue() {
        double maxVal = this.getMaximumUnscaledValue().doubleValue();
        return maxVal * Math.pow(0.5, this.getFractionBitLength());
    }

    public BigInteger getMinimumUnscaledValue() {
        int numBits = this.getNumberOfBits();
        return BigInteger.ZERO.setBit(numBits - 1).negate();
    }

    public double getMinimumValue() {
        double minVal = this.getMinimumUnscaledValue().doubleValue();
        return minVal * Math.pow(0.5, this.getFractionBitLength());
    }

    public BigInteger getModuloUnscaledValue() {
        int numBits = this.getNumberOfBits();
        return BigInteger.ZERO.setBit(numBits);
    }

    public int getNumberOfBits() {
        return this.getMantissaBitLength() + this.getExponentBitLength();
    }

    public double getNumberOfLevels() {
        return Math.pow(2.0, this.getMantissaBitLength());
    }

    public Overflow getOverflow() {
        return this._overflow;
    }

    public abstract Precision getPrecision();

    public Rounding getRounding() {
        return this._rounding;
    }

    public double getTinyValue() {
        return this.getEpsilonValue();
    }

    public int hashCode() {
        return this._overflow.hashCode() & this._rounding.hashCode();
    }

    public abstract String toString();
}

