/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.media.javasound;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SoundPlayback {
    private int _productionRate;
    private String _fileName;
    private String _playbackMode;
    private int _sampleSizeInBits;
    private int _putSamplesSize;
    private float _sampleRate;
    private int _channels;
    private int _bufferSize;
    private SourceDataLine _sourceLine;
    private byte[] _data;
    private int _frameSizeInBytes;
    private ArrayList _toFileBuffer;
    private AudioFormat _playToFileFormat;
    private int _bytesPerSample;
    private boolean _isAudioPlaybackActive = false;

    public SoundPlayback(float sampleRate, int sampleSizeInBits, int channels, int bufferSize, int putSamplesSize) {
        this._playbackMode = "speaker";
        this._sampleSizeInBits = sampleSizeInBits;
        this._sampleRate = sampleRate;
        this._channels = channels;
        this._bufferSize = bufferSize;
        this._putSamplesSize = putSamplesSize;
    }

    public SoundPlayback(String fileName, float sampleRate, int sampleSizeInBits, int channels, int bufferSize, int putSamplesSize) {
        this._playbackMode = "file";
        this._fileName = fileName;
        this._sampleSizeInBits = sampleSizeInBits;
        this._sampleRate = sampleRate;
        this._channels = channels;
        this._productionRate = putSamplesSize;
    }

    public void putSamples(double[][] putSamplesArray) throws IOException, IllegalStateException {
        if (this._isAudioPlaybackActive) {
            if (this._playbackMode.equals("speaker")) {
                this._data = this._doubleArrayToByteArray(putSamplesArray, this._bytesPerSample, this._channels);
                this._sourceLine.write(this._data, 0, this._putSamplesSize * this._frameSizeInBytes);
            } else if (this._playbackMode.equals("file")) {
                this._data = this._doubleArrayToByteArray(putSamplesArray, this._bytesPerSample, this._channels);
                for (int i = 0; i < this._data.length; ++i) {
                    this._toFileBuffer.add(this._data[i]);
                }
            }
        } else {
            throw new IllegalStateException("SoundPlayback: putSamples() was called while audio playback was inactive (startPlayback() was never called or stopPlayback has already been called).");
        }
    }

    public void putSamplesInt(int[][] putSamplesArray) throws IOException, IllegalStateException {
        if (this._isAudioPlaybackActive) {
            if (this._playbackMode.equals("speaker")) {
                this._data = this._intArrayToByteArray(putSamplesArray, this._bytesPerSample, this._channels);
                this._sourceLine.write(this._data, 0, this._putSamplesSize * this._frameSizeInBytes);
            } else if (this._playbackMode.equals("file")) {
                this._data = this._intArrayToByteArray(putSamplesArray, this._bytesPerSample, this._channels);
                for (int i = 0; i < this._data.length; ++i) {
                    this._toFileBuffer.add(this._data[i]);
                }
            }
        } else {
            throw new IllegalStateException("SoundPlayback: putSamples() was called while audio playback was inactive (startPlayback() was never called or stopPlayback has already been called).");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startPlayback() throws IOException, IllegalStateException {
        if (this._isAudioPlaybackActive) throw new IllegalStateException("SoundPlayback: startPlayback() was called while audio playback was already active (startPlayback() was called more than once between invocations of stopPlayback()).");
        if (this._playbackMode.equals("speaker")) {
            this._startPlaybackRealTime();
        } else {
            if (!this._playbackMode.equals("file")) throw new IOException("SoundPlayback: startPlayback(): unknown playback mode: " + this._playbackMode);
            this._startPlaybackToFile();
        }
        this._bytesPerSample = this._sampleSizeInBits / 8;
        this._isAudioPlaybackActive = true;
    }

    public void stopPlayback() throws IOException {
        if (this._isAudioPlaybackActive) {
            if (this._playbackMode.equals("speaker")) {
                if (this._sourceLine != null) {
                    this._sourceLine.drain();
                    this._sourceLine.stop();
                    this._sourceLine.close();
                }
                this._sourceLine = null;
            } else if (this._playbackMode.equals("file")) {
                this._stopPlaybackToFile();
            }
        }
        this._isAudioPlaybackActive = false;
    }

    private void _startPlaybackRealTime() throws IOException {
        boolean signed = true;
        boolean bigEndian = true;
        AudioFormat format = new AudioFormat(this._sampleRate, this._sampleSizeInBits, this._channels, signed, bigEndian);
        this._frameSizeInBytes = format.getFrameSize();
        DataLine.Info sourceInfo = new DataLine.Info(SourceDataLine.class, format, -1);
        try {
            this._sourceLine = (SourceDataLine)AudioSystem.getLine(sourceInfo);
            this._sourceLine.open(format, this._bufferSize * this._frameSizeInBytes);
        }
        catch (LineUnavailableException ex) {
            throw new IOException("Unable to open the line for real-time audio playback: " + ex);
        }
        this._data = new byte[this._productionRate * this._frameSizeInBytes * this._channels];
        this._sourceLine.start();
    }

    private void _startPlaybackToFile() {
        this._toFileBuffer = new ArrayList();
        boolean signed = true;
        boolean bigEndian = true;
        this._playToFileFormat = new AudioFormat(this._sampleRate, this._sampleSizeInBits, this._channels, signed, bigEndian);
        this._frameSizeInBytes = this._playToFileFormat.getFrameSize();
    }

    private void _stopPlaybackToFile() throws IOException {
        block22: {
            int size = this._toFileBuffer.size();
            byte[] audioBytes = new byte[size];
            for (int i = 0; i < size; ++i) {
                Byte j = (Byte)this._toFileBuffer.get(i);
                audioBytes[i] = j;
            }
            ByteArrayInputStream byteInputArrayStream = null;
            AudioInputStream audioInputStream = null;
            try {
                byteInputArrayStream = new ByteArrayInputStream(audioBytes);
                audioInputStream = new AudioInputStream(byteInputArrayStream, this._playToFileFormat, audioBytes.length / this._frameSizeInBytes);
                File outFile = new File(this._fileName);
                StringTokenizer st = new StringTokenizer(this._fileName, ".");
                if (st.countTokens() != 2) {
                    throw new IOException("Error: Incorrect file name format. Format: filename.extension");
                }
                st.nextToken();
                String fileExtension = st.nextToken();
                if (fileExtension.equalsIgnoreCase("au")) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.AU, outFile);
                    break block22;
                }
                if (fileExtension.equalsIgnoreCase("aiff")) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.AIFF, outFile);
                    break block22;
                }
                if (fileExtension.equalsIgnoreCase("wave")) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, outFile);
                    break block22;
                }
                if (fileExtension.equalsIgnoreCase("wav")) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, outFile);
                    break block22;
                }
                if (fileExtension.equalsIgnoreCase("aifc")) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.AIFC, outFile);
                    break block22;
                }
                throw new IOException("Error saving file: Unknown file format: " + fileExtension);
            }
            catch (IOException e) {
                throw new IOException("SoundPlayback: error saving file: " + e);
            }
            finally {
                if (byteInputArrayStream != null) {
                    try {
                        byteInputArrayStream.close();
                    }
                    catch (Throwable throwable) {
                        System.out.println("Ignoring failure to close stream on " + audioBytes.length + " bytes of data.");
                        throwable.printStackTrace();
                    }
                }
                if (audioInputStream != null) {
                    try {
                        audioInputStream.close();
                    }
                    catch (Throwable throwable) {
                        System.out.println("Ignoring failure to close stream on " + audioBytes.length + " bytes of data.");
                        throwable.printStackTrace();
                    }
                }
            }
        }
    }

    private byte[] _doubleArrayToByteArray(double[][] doubleArray, int bytesPerSample, int channels) {
        int lengthInSamples = doubleArray[0].length;
        double maxSample = bytesPerSample == 2 ? 32768.0 : (bytesPerSample == 1 ? 128.0 : (bytesPerSample == 3 ? 8388608.0 : (bytesPerSample == 4 ? 1.47483648E17 : 0.0)));
        double maxDoubleValuedSample = (maxSample - 2.0) / maxSample;
        byte[] byteArray = new byte[lengthInSamples * bytesPerSample * channels];
        byte[] b = new byte[bytesPerSample];
        for (int currSamp = 0; currSamp < lengthInSamples; ++currSamp) {
            for (int currChannel = 0; currChannel < channels; ++currChannel) {
                int l = doubleArray[currChannel][currSamp] >= maxDoubleValuedSample ? (int)maxSample - 2 : (doubleArray[currChannel][currSamp] <= -maxDoubleValuedSample ? (int)(-maxSample) + 2 : (int)(doubleArray[currChannel][currSamp] * maxSample));
                int i = 0;
                while (i < bytesPerSample) {
                    b[bytesPerSample - i - 1] = (byte)l;
                    ++i;
                    l >>= 8;
                }
                for (i = 0; i < bytesPerSample; ++i) {
                    byteArray[currSamp * bytesPerSample * channels + bytesPerSample * currChannel + i] = b[i];
                }
            }
        }
        return byteArray;
    }

    private byte[] _intArrayToByteArray(int[][] intArray, int bytesPerSample, int channels) {
        int lengthInSamples = intArray[0].length;
        byte[] byteArray = new byte[lengthInSamples * bytesPerSample * channels];
        byte[] b = new byte[bytesPerSample];
        for (int currSamp = 0; currSamp < lengthInSamples; ++currSamp) {
            for (int currChannel = 0; currChannel < channels; ++currChannel) {
                int l = intArray[currChannel][currSamp];
                int maxSample = bytesPerSample == 2 ? 32768 : (bytesPerSample == 1 ? 128 : (bytesPerSample == 3 ? 0x800000 : (bytesPerSample == 4 ? 1474836480 : 0)));
                if (l > maxSample - 1) {
                    l = maxSample - 1;
                } else if (l < -maxSample + 1) {
                    l = -maxSample + 1;
                }
                int i = 0;
                while (i < bytesPerSample) {
                    b[bytesPerSample - i - 1] = (byte)l;
                    ++i;
                    l >>= 8;
                }
                for (i = 0; i < bytesPerSample; ++i) {
                    byteArray[currSamp * bytesPerSample * channels + bytesPerSample * currChannel + i] = b[i];
                }
            }
        }
        return byteArray;
    }
}

