/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml;

import java.io.StringWriter;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.data.expr.ModelScope;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.expr.UndefinedConstantOrIdentifierException;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.ErrorHandler;
import ptolemy.moml.MissingClassException;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.moml.MoMLParser;

public class MoMLVariableChecker {
    private Variable _previousNode;
    private StringWriter _variableBuffer;

    public String checkCopy(String momlToBeChecked, NamedObj container) throws IllegalActionException {
        this._variableBuffer = new StringWriter();
        Workspace workspace = new Workspace("copyWorkspace");
        MoMLParser parser = new MoMLParser(workspace);
        CompositeEntity parsedContainer = null;
        boolean doParse = true;
        while (doParse) {
            ErrorHandler handler = MoMLParser.getErrorHandler();
            MoMLParser.setErrorHandler(null);
            try {
                parsedContainer = (TypedCompositeActor)parser.parse("<entity name=\"auto\" class=\"ptolemy.actor.TypedCompositeActor\">" + this._variableBuffer.toString() + momlToBeChecked + "</entity>");
                doParse = false;
            }
            catch (MissingClassException ex1) {
                try {
                    doParse = this._findMissingClass(ex1, container, (TypedCompositeActor)parsedContainer);
                }
                catch (Exception ex1a) {
                    String string = this._variableBuffer.toString();
                    return string;
                }
            }
            catch (IllegalActionException ex2) {
                try {
                    doParse = this._findUndefinedConstantsOrIdentifiers(ex2, container, (TypedCompositeActor)parsedContainer);
                }
                catch (Exception ex2a) {
                    String string = this._variableBuffer.toString();
                    return string;
                }
            }
            catch (Exception ex3) {
                throw new IllegalActionException((Nameable)container, ex3, "Failed to parse contents of copy buffer.");
            }
            finally {
                MoMLParser.setErrorHandler(handler);
            }
        }
        if (parsedContainer != null) {
            for (Entity entity : parsedContainer.allAtomicEntityList()) {
                for (Attribute attribute : entity.attributeList()) {
                    if (!(attribute instanceof Variable)) continue;
                    Variable variable = (Variable)attribute;
                    boolean doGetToken = true;
                    while (doGetToken) {
                        doGetToken = false;
                        try {
                            variable.getToken();
                        }
                        catch (IllegalActionException ex) {
                            doGetToken = this._findUndefinedConstantsOrIdentifiers(ex, container, (TypedCompositeActor)parsedContainer);
                        }
                    }
                }
            }
        }
        return this._variableBuffer.toString();
    }

    private boolean _findMissingClass(MissingClassException exception, NamedObj container, TypedCompositeActor parsedContainer) throws IllegalActionException {
        boolean doRerun = false;
        if (container instanceof CompositeEntity) {
            for (NamedObj containedObject : ((CompositeEntity)container).classDefinitionList()) {
                String missingClassName = exception.missingClassName();
                if (!missingClassName.equals(containedObject.getName()) && (!missingClassName.startsWith(".") || !missingClassName.substring(1).equals(containedObject.getName()))) continue;
                try {
                    String moml = containedObject.exportMoML().replaceFirst("<class", "<class createIfNecessary=\"true\"");
                    MoMLChangeRequest change = new MoMLChangeRequest(parsedContainer, parsedContainer, moml);
                    if (parsedContainer != null) {
                        parsedContainer.requestChange(change);
                    }
                    this._variableBuffer.append(moml);
                    doRerun = true;
                }
                catch (Throwable ex2) {}
            }
        }
        return doRerun;
    }

    private boolean _findUndefinedConstantsOrIdentifiers(IllegalActionException exception, NamedObj container, TypedCompositeActor parsedContainer) throws IllegalActionException {
        Variable masterVariable;
        ParserScope parserScope;
        boolean doRerun = false;
        UndefinedConstantOrIdentifierException idException = null;
        if (exception instanceof UndefinedConstantOrIdentifierException) {
            idException = (UndefinedConstantOrIdentifierException)exception;
        } else if (exception.getCause() instanceof UndefinedConstantOrIdentifierException) {
            idException = (UndefinedConstantOrIdentifierException)exception.getCause();
        }
        if (idException == null) {
            return false;
        }
        String variableName = exception.getNameable1().getFullName().substring(((NamedObj)exception.getNameable1()).toplevel().getName().length() + 2);
        Attribute masterAttribute = container.getAttribute(variableName);
        if (masterAttribute instanceof Variable && (parserScope = (masterVariable = (Variable)masterAttribute).getParserScope()) instanceof ModelScope && masterVariable != null) {
            Variable node = masterVariable.getVariable(idException.nodeName());
            if (node == this._previousNode) {
                return false;
            }
            this._previousNode = node;
            try {
                String moml = node.exportMoML().replaceFirst("<property", "<property createIfNecessary=\"true\"");
                MoMLChangeRequest change = new MoMLChangeRequest(parsedContainer, parsedContainer, moml);
                if (parsedContainer != null) {
                    parsedContainer.requestChange(change);
                }
                this._variableBuffer.append(moml);
                doRerun = true;
            }
            catch (Throwable ex2) {
                // empty catch block
            }
        }
        return doRerun;
    }
}

