/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml.filter;

import java.util.HashMap;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLFilter;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.filter.BackwardCompatibility;
import ptolemy.moml.filter.HideAnnotationNames;

public class RemoveGraphicalClasses
implements MoMLFilter {
    private static HashMap _graphicalClasses = new HashMap();
    private boolean _removeGR = false;

    public static void clear() {
        _graphicalClasses = new HashMap();
    }

    @Override
    public String filterAttributeValue(NamedObj container, String element, String attributeName, String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (_graphicalClasses.containsKey(attributeValue)) {
            MoMLParser.setModified(true);
            return (String)_graphicalClasses.get(attributeValue);
        }
        if (this._removeGR && attributeValue.startsWith("ptolemy.domains.gr")) {
            MoMLParser.setModified(true);
            return null;
        }
        return attributeValue;
    }

    @Override
    public void filterEndElement(NamedObj container, String elementName) throws Exception {
    }

    public static void main(String[] args) throws Exception {
        try {
            MoMLParser parser = new MoMLParser();
            MoMLParser.setMoMLFilters(null);
            MoMLParser.setMoMLFilters(BackwardCompatibility.allFilters());
            MoMLParser.addMoMLFilter(new RemoveGraphicalClasses());
            MoMLParser.addMoMLFilter(new HideAnnotationNames());
            NamedObj topLevel = parser.parseFile(args[0]);
            System.out.println(topLevel.exportMoML());
        }
        catch (Throwable throwable) {
            System.err.println("Failed to filter \"" + args[0] + "\"");
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public void remove(String className) {
        _graphicalClasses.remove(className);
    }

    public void put(String className, String replacement) {
        _graphicalClasses.put(className, replacement);
    }

    public void setRemoveGR(boolean removeGR) {
        this._removeGR = removeGR;
    }

    @Override
    public String toString() {
        StringBuffer results = new StringBuffer(this.getClass().getName() + ": Remove or replace classes that are graphical.\n" + "This filter is used by the nightly build, and\n" + "can be used to run applets so that files like\n" + "diva.jar do not need to be downloaded.\n" + "The following actors are affected:\n");
        for (String oldClassName : _graphicalClasses.keySet()) {
            String newClassName = (String)_graphicalClasses.get(oldClassName);
            if (newClassName == null) {
                results.append(oldClassName + " will be removed\n");
                continue;
            }
            results.append(oldClassName + " will be replaced by " + newClassName + "\n");
        }
        return results.toString();
    }

    static {
        _graphicalClasses.put("ptolemy.vergil.toolbox.AnnotationEditorFactory", "ptolemy.kernel.util.Attribute");
        _graphicalClasses.put("ptolemy.vergil.toolbox.VisibleParameterEditorFactory", "ptolemy.kernel.util.Attribute");
        _graphicalClasses.put("ptolemy.vergil.fsm.modal.HierarchicalStateControllerFactory", "ptolemy.kernel.util.Attribute");
        _graphicalClasses.put("ptolemy.vergil.fsm.modal.ModalTableauFactory", "ptolemy.kernel.util.Attribute");
        _graphicalClasses.put("ptolemy.vergil.icon.EditorIcon", null);
        _graphicalClasses.put("ptolemy.vergil.fsm.StateIcon", null);
        _graphicalClasses.put("ptolemy.vergil.kernel.attributes.EllipseAttribute", null);
        _graphicalClasses.put("ptolemy.vergil.kernel.attributes.FilledShapeAttribute", null);
        _graphicalClasses.put("ptolemy.vergil.kernel.attributes.IDAttribute", null);
        _graphicalClasses.put("ptolemy.vergil.kernel.attributes.ImageAttribute", null);
        _graphicalClasses.put("ptolemy.vergil.kernel.attributes.LineAttribute", null);
        _graphicalClasses.put("ptolemy.vergil.kernel.attributes.ShapeAttribute", null);
        _graphicalClasses.put("ptolemy.vergil.kernel.attributes.ResizablePolygonAttribute", null);
        _graphicalClasses.put("ptolemy.vergil.kernel.attributes.RectangleAttribute", null);
        _graphicalClasses.put("ptolemy.vergil.kernel.attributes.TextAttribute", null);
        _graphicalClasses.put("ptolemy.vergil.basic.NodeControllerFactory", null);
        _graphicalClasses.put("ptolemy.vergil.icon.AttributeValueIcon", null);
        _graphicalClasses.put("ptolemy.vergil.icon.BoxedValueIcon", null);
        _graphicalClasses.put("ptolemy.vergil.icon.CopyCatIcon", null);
        _graphicalClasses.put("ptolemy.vergil.icon.EditorIcon", null);
        _graphicalClasses.put("ptolemy.vergil.icon.XMLIcon", null);
        _graphicalClasses.put("ptolemy.vergil.icon.UpdatedValueIcon", null);
        _graphicalClasses.put("ptolemy.vergil.icon.ValueIcon", "ptolemy.kernel.util.Attribute");
        _graphicalClasses.put("ptolemy.vergil.toolbox.AnnotationEditorFactory", null);
        _graphicalClasses.put("ptolemy.vergil.toolbox.VisibleParameterEditorFactory", "ptolemy.kernel.util.Attribute");
        _graphicalClasses.put("ptolemy.actor.gui.style.CheckBoxStyle", null);
        _graphicalClasses.put("ptolemy.actor.gui.PtolemyPreferences", "ptolemy.data.expr.ScopeExtendingAttribute");
        _graphicalClasses.put("ptolemy.vergil.basic.DocViewerFactory", "ptolemy.kernel.util.Attribute");
        _graphicalClasses.put("ptolemy.vergil.basic.DocAttribute", "ptolemy.kernel.util.Attribute");
        _graphicalClasses.put("ptolemy.domains.wireless.lib.GraphicalLocator", "ptolemy.domains.wireless.lib.Locator");
        _graphicalClasses.put("ptolemy.domains.wireless.lib.TerrainProperty", null);
        _graphicalClasses.put("ptolemy.domains.wireless.demo.EvaderAndPursuer.Sensor", null);
        _graphicalClasses.put("ptolemy.domains.curriculum.DependencyHighlighter", null);
        _graphicalClasses.put("ptolemy.domains.curriculum.HighlightEntities", "ptolemy.kernel.util.Attribute");
        _graphicalClasses.put("ptolemy.vergil.icon.NameIcon", null);
        _graphicalClasses.put("ptolemy.actor.gui.DependencyHighlighter", null);
    }
}

