/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import com.microstar.xml.XmlException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JOptionPane;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotFrame;
import ptolemy.plot.plotml.PlotBoxMLParser;
import ptolemy.plot.plotml.PlotMLParser;

public class PlotMLFrame
extends PlotFrame {
    public PlotMLFrame() {
        this("Ptolemy Plot Frame");
    }

    public PlotMLFrame(String title) {
        this(title, (PlotBox)null);
    }

    public PlotMLFrame(String title, PlotBox plotArg) {
        super(title, plotArg);
    }

    @Override
    protected void _about() {
        JOptionPane.showMessageDialog(this, "Ptolemy plot frame\nBy: Edward A. Lee\nand Christopher Hylands\nVersion 5.7, Build: $Id: PlotMLFrame.java,v 1.33 2006/09/21 15:39:59 cxh Exp $For more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n", "About Ptolemy Plot", 1);
    }

    @Override
    protected void _read(URL base, InputStream in) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(in);
        bin.mark(9);
        byte[] peek = new byte[8];
        int bytesRead = bin.read(peek);
        if (bytesRead != peek.length) {
            throw new IOException("Read only " + bytesRead + "bytes, expecting " + peek.length);
        }
        bin.reset();
        if (new String(peek).startsWith("<?xm")) {
            PlotBoxMLParser parser = this.plot instanceof Plot ? new PlotMLParser((Plot)this.plot) : new PlotBoxMLParser(this.plot);
            try {
                parser.parse(base, bin);
            }
            catch (Exception ex) {
                String msg;
                if (ex instanceof XmlException) {
                    XmlException xmlex = (XmlException)ex;
                    msg = "PlotMLFrame: failed to parse PlotML data:\nline: " + xmlex.getLine() + ", column: " + xmlex.getColumn() + "\nIn entity: " + xmlex.getSystemId() + "\n";
                } else {
                    msg = "PlotMLFrame: failed to parse PlotML data:\n";
                }
                System.err.println(msg + ex.toString());
                ex.printStackTrace();
            }
        } else {
            super._read(base, bin);
        }
    }
}

