/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ptolemy.util.ExecuteCommands;
import ptolemy.util.StringUtilities;

public class StreamExec
implements ExecuteCommands {
    private List _commands;
    private final boolean _debug = false;
    private String[] _envp;
    private Process _process;
    private int _subprocessReturnCode;
    private File _workingDirectory;

    @Override
    public void appendToPath(String directoryName) {
        String keyPath = "PATH";
        String path = this.getenv(keyPath);
        if (path == null && (path = this.getenv("Path")) != null) {
            keyPath = "Path";
        }
        if (path == null || path.indexOf(File.pathSeparatorChar + directoryName + File.pathSeparatorChar) == -1) {
            this._envp = StreamExec.updateEnvironment(keyPath, File.pathSeparatorChar + directoryName + File.pathSeparatorChar);
        }
    }

    @Override
    public void cancel() {
        if (this._process != null) {
            this._process.destroy();
        }
    }

    @Override
    public void clear() {
        this.updateStatusBar("");
        this._updateProgressBar(0);
    }

    @Override
    public String getenv(String key) {
        if (this._envp == null) {
            Map<String, String> environmentMap = System.getenv();
            return environmentMap.get(key);
        }
        for (int i = 0; i < this._envp.length; ++i) {
            if (!key.regionMatches(false, 0, this._envp[i], 0, key.length())) continue;
            return this._envp[i].substring(key.length() + 1, this._envp[i].length());
        }
        return null;
    }

    @Override
    public int getLastSubprocessReturnCode() {
        return this._subprocessReturnCode;
    }

    @Override
    public void setCommands(List commands) {
        this._commands = commands;
    }

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        this._workingDirectory = workingDirectory;
    }

    @Override
    public void start() {
        String returnValue = this._executeCommands();
        this.updateStatusBar(returnValue);
        this.stdout(returnValue);
    }

    @Override
    public void stderr(String text) {
        System.err.println(text);
        System.err.flush();
    }

    @Override
    public void stdout(String text) {
        System.out.println(text);
        System.out.flush();
    }

    public static String[] updateEnvironment(String key, String value) {
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        env.put(key, value + (String)env.get(key));
        String[] envp = new String[env.size()];
        int i = 0;
        for (Map.Entry entry : env.entrySet()) {
            envp[i++] = entry.getKey() + "=" + entry.getValue();
        }
        return envp;
    }

    @Override
    public void updateStatusBar(String text) {
    }

    protected void _setProgressBarMaximum(int size) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String _executeCommands() {
        try {
            Runtime runtime = Runtime.getRuntime();
            try {
                if (this._process != null) {
                    this._process.destroy();
                }
                this._setProgressBarMaximum(this._commands.size());
                int commandCount = 0;
                Iterator commands = this._commands.iterator();
                while (commands.hasNext()) {
                    this._updateProgressBar(++commandCount);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    String[] commandTokens = StringUtilities.tokenizeForExec((String)commands.next());
                    if (this._workingDirectory != null) {
                        this.stdout("In \"" + this._workingDirectory + "\", about to execute:");
                    } else {
                        this.stdout("About to execute:");
                    }
                    StringBuffer commandBuffer = new StringBuffer();
                    StringBuffer statusCommand = new StringBuffer();
                    for (int i = 0; i < commandTokens.length; ++i) {
                        if (commandBuffer.length() > 1) {
                            commandBuffer.append(" ");
                        }
                        commandBuffer.append(commandTokens[i]);
                        if (statusCommand.length() >= 50) continue;
                        if (statusCommand.length() > 0) {
                            statusCommand.append(" ");
                        }
                        statusCommand.append(commandTokens[i]);
                    }
                    this.stdout("    " + StringUtilities.split(commandBuffer.toString()));
                    if (statusCommand.length() >= 50) {
                        statusCommand.append(" . . .");
                    }
                    this.updateStatusBar("Executing: " + statusCommand.toString());
                    this._process = runtime.exec(commandTokens, this._envp, this._workingDirectory);
                    _StreamReaderThread errorGobbler = new _StreamReaderThread(this._process.getErrorStream(), this);
                    _StreamReaderThread outputGobbler = new _StreamReaderThread(this._process.getInputStream(), this);
                    errorGobbler.start();
                    outputGobbler.start();
                    try {
                        this._subprocessReturnCode = this._process.waitFor();
                        StreamExec streamExec = this;
                        synchronized (streamExec) {
                            this._process = null;
                        }
                        if (this._subprocessReturnCode == 0) continue;
                        return "All Done";
                    }
                    catch (InterruptedException interrupted) {
                        this.stderr("InterruptedException: " + interrupted);
                        throw interrupted;
                        return "All Done";
                    }
                }
            }
            catch (IOException io) {
                this.stderr("IOException: " + io);
            }
            return "All Done";
        }
        catch (InterruptedException e) {
            this._process.destroy();
            this._updateProgressBar(0);
            return "Interrupted";
        }
    }

    private void _updateProgressBar(int i) {
    }

    private static class _StreamReaderThread
    extends Thread {
        private InputStream _inputStream;
        private StreamExec _streamExec;

        _StreamReaderThread(InputStream inputStream, StreamExec streamExec) {
            this._inputStream = inputStream;
            this._streamExec = streamExec;
        }

        @Override
        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this._inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    this._streamExec.stdout(line);
                }
            }
            catch (IOException ioe) {
                this._streamExec.stderr("IOException: " + ioe);
            }
        }
    }
}

