/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.util;

import ptolemy.util.StreamExec;
import ptolemy.util.StringUtilities;

public class StringBufferExec
extends StreamExec {
    public StringBuffer buffer;
    private boolean _appendToStderrAndStdout = false;
    private static String _eol = StringUtilities.getProperty("line.separator");

    public StringBufferExec() {
        this.buffer = new StringBuffer();
    }

    public StringBufferExec(boolean appendToStderrAndStdout) {
        this._appendToStderrAndStdout = appendToStderrAndStdout;
        this.buffer = new StringBuffer();
    }

    @Override
    public void stderr(String text) {
        if (this._appendToStderrAndStdout) {
            super.stderr(text);
        }
        this._appendToBuffer(text);
    }

    @Override
    public void stdout(String text) {
        if (this._appendToStderrAndStdout) {
            super.stdout(text);
        }
        this._appendToBuffer(text);
    }

    private void _appendToBuffer(String text) {
        this.buffer.append(text);
        if (!text.endsWith(_eol)) {
            this.buffer.append(_eol);
        }
    }
}

