/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.particles;

import JSci.physics.particles.AntiLepton;
import JSci.physics.particles.ElectronNeutrino;
import JSci.physics.particles.Positron;
import JSci.physics.particles.WMinus;
import JSci.physics.particles.WPlus;
import JSci.physics.particles.ZZero;
import JSci.physics.quantum.QuantumParticle;

public final class AntiElectronNeutrino
extends AntiLepton {
    public double restMass() {
        return 0.0;
    }

    public int charge() {
        return 0;
    }

    public int eLeptonQN() {
        return -1;
    }

    public int muLeptonQN() {
        return 0;
    }

    public int tauLeptonQN() {
        return 0;
    }

    public QuantumParticle anti() {
        return new ElectronNeutrino();
    }

    public boolean isAnti(QuantumParticle quantumParticle) {
        return quantumParticle != null && quantumParticle instanceof ElectronNeutrino;
    }

    public String toString() {
        return new String("Antielectron neutrino");
    }

    public Positron emit(WMinus wMinus) {
        Positron positron = new Positron();
        positron.momentum = this.momentum.subtract(wMinus.momentum);
        return positron;
    }

    public Positron absorb(WPlus wPlus) {
        Positron positron = new Positron();
        positron.momentum = this.momentum.add(wPlus.momentum);
        return positron;
    }

    public AntiElectronNeutrino emit(ZZero zZero) {
        this.momentum = this.momentum.subtract(zZero.momentum);
        return this;
    }

    public AntiElectronNeutrino absorb(ZZero zZero) {
        this.momentum = this.momentum.add(zZero.momentum);
        return this;
    }
}

