/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d;

import java.io.IOException;
import java.io.PrintWriter;
import opale.m2d.GObject2D;
import opale.m2d.GPoint2D;
import opale.m2d.InfoObject;
import opale.m2d.InfoVector;
import opale.m2d.OIJ;
import opale.m2d.Pen2D;
import opale.m2d.Vector2D;
import opale.tools.Debug;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;
import opale.tools.StreamReader;

public class GVector2D
extends Vector2D
implements GObject2D,
Cloneable {
    private InfoVector info;
    private GPoint2D origin;

    public GVector2D() {
        Debug.print("ici dan GVector2D");
        this.info = new InfoVector();
        this.origin = new GPoint2D();
    }

    public GVector2D(OIJ oIJ) {
        super(oIJ);
        this.info = new InfoVector();
        this.origin = new GPoint2D(oIJ);
    }

    public GVector2D(OIJ oIJ, double d, double d2) {
        super(oIJ, d, d2);
        this.info = new InfoVector();
        this.origin = new GPoint2D(oIJ);
    }

    public GVector2D(Vector2D vector2D, String string) {
        super(vector2D);
        this.origin = new GPoint2D(vector2D.getOIJ());
        this.info = new InfoVector();
        this.info.setName(string);
    }

    public GVector2D(GVector2D gVector2D) {
        super(gVector2D);
        this.origin = (GPoint2D)gVector2D.getOrigin().clone();
        this.info = new InfoVector((InfoVector)gVector2D.getInfo());
    }

    public void draw(Pen2D pen2D) {
        if (this.info.isVisible()) {
            double d = this.getOrigin().x;
            double d2 = this.getOrigin().y;
            pen2D.setColor(this.info.getColor());
            if (this.info.symbolArrow == 0) {
                pen2D.drawLine(d, d2, d + this.x, d2 + this.y);
                pen2D.drawArrow(d, d2, d + this.x, d2 + this.y, this.info.size);
            }
        }
    }

    public InfoObject getInfo() {
        return this.info;
    }

    public Object clone() {
        GVector2D gVector2D = (GVector2D)super.clone();
        gVector2D.info = (InfoVector)this.info.clone();
        gVector2D.origin = (GPoint2D)this.origin.clone();
        return gVector2D;
    }

    public GPoint2D getOrigin() {
        return (GPoint2D)this.origin.clone();
    }

    public void setOrigin(double d, double d2) {
        this.origin.setLocation(d, d2);
    }

    public void setOIJ(OIJ oIJ) {
        super.setOIJ(oIJ);
        this.origin.setOIJ(oIJ);
    }

    public void changeOIJ(OIJ oIJ) {
        this.origin.changeOIJ(oIJ);
        super.changeOIJ(oIJ);
    }

    public int readKeyWord(String string, StreamReader streamReader, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("INFO")) {
            this.info.read(streamReader, opaleSet);
            return 0;
        }
        if (string.equals("ORIGIN")) {
            this.origin.x = streamReader.nextDouble();
            this.origin.y = streamReader.nextDouble();
            return 0;
        }
        return super.readKeyWord(string, streamReader, opaleSet);
    }

    public void writeMore(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        this.info.write(printWriter, opaleSet);
        printWriter.println("ORIGIN " + this.origin.x + " " + this.origin.y);
        super.writeMore(printWriter, opaleSet);
    }

    public double x(double d) {
        return this.origin.x;
    }

    public double y(double d) {
        return this.origin.y;
    }
}

