/*
 * Decompiled with CFR 0.152.
 */
package opale.ode;

import java.io.IOException;
import java.io.PrintWriter;
import opale.mathtools.DVect;
import opale.ode.Equation;
import opale.ode.NoStepsizeControl;
import opale.ode.ObjectODE;
import opale.ode.Problem;
import opale.ode.StepsizeControl;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;
import opale.tools.Stdio;
import opale.tools.StreamReader;

public abstract class TimeScheme
extends ObjectODE {
    private double tinit = 0.0;
    private double tmax = 1.0;
    private double tc;
    private double dtmax = 1.0E9;
    private double dtmin = 0.0;
    private double dt;
    private int Nstep = 11;
    private Problem pb = null;
    private StepsizeControl stepcontrol;
    private DVect present;
    private DVect past;
    private DVect dpresent;
    private DVect dpast;

    public void forward(Equation equation) {
    }

    public abstract void advance();

    public double errorEstimate() {
        double d = 0.0;
        int n = 0;
        while (n < this.present().size()) {
            double d2 = Math.abs(this.dt() / 2.0 * (this.present().get(n) - this.past().get(n)));
            if (d < d2) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public final DVect present() {
        return this.present;
    }

    public final DVect past() {
        return this.past;
    }

    public final DVect der_past() {
        return this.dpast;
    }

    public final DVect der_present() {
        return this.dpresent;
    }

    public final void set(double d, double d2) {
        this.tinit = Math.min(d, d2);
        this.tmax = Math.max(d, d2);
    }

    public final void setNstep(int n) {
        this.Nstep = Math.max(3, Math.abs(n));
    }

    public final int getNstep() {
        return this.Nstep;
    }

    public final void setPb(Problem problem) {
        this.pb = problem;
    }

    public final Problem getPb() {
        return this.pb;
    }

    public final Equation getEquation() {
        return this.pb.getEqn();
    }

    public final void setStepsizeControl(StepsizeControl stepsizeControl) {
        this.stepcontrol = stepsizeControl;
    }

    public final double tmin() {
        return this.tinit;
    }

    public final double tmax() {
        return this.tmax;
    }

    public final double dtmax() {
        return this.dtmax;
    }

    public final double dtmin() {
        return this.dtmin;
    }

    public final void dtmax(double d) {
        this.dtmax = d;
    }

    public final void dtmin(double d) {
        this.dtmin = d;
    }

    public final double dt() {
        return this.dt;
    }

    public final void dt(double d) {
        this.dt = d;
    }

    public final double time() {
        return this.tc;
    }

    public void init() {
        if (this.pb == null) {
            System.err.println("No problem for this scheme !.\nStop.");
            System.exit(-1);
        }
        if (this.stepcontrol == null) {
            this.stepcontrol = new NoStepsizeControl(this);
        } else {
            this.stepcontrol.setTS(this);
        }
        this.present = new DVect(this.pb.dim());
        this.past = new DVect(this.pb.dim());
        this.present.set(this.pb.getInit());
        this.past.set(this.pb.getInit());
        this.dt = (this.tmax - this.tinit) / (double)(this.Nstep - 1);
        if (this.dt < this.dtmin) {
            this.dt = this.dtmin;
        } else if (this.dt > this.dtmax) {
            this.dt = this.dtmax;
        }
        this.tc = this.tinit;
        this.dpresent = new DVect(this.pb.dim());
        this.dpast = new DVect(this.pb.dim());
        this.dpresent.set(this.pb.getEqn().derivs(this.time(), this.present()));
        this.dpast.set(this.dpresent);
    }

    public boolean update() {
        this.dpresent.set(this.pb.getEqn().derivs(this.time(), this.present()));
        if (this.stepcontrol.update()) {
            this.tc += this.dt;
            this.past.set(this.present);
            this.dpast.set(this.dpresent);
            return true;
        }
        Stdio.println("Step time refused. New step time : dt = " + this.dt);
        this.present.set(this.past);
        this.dpresent.set(this.dpast);
        return false;
    }

    public int readKeyWord(String string, StreamReader streamReader, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("N")) {
            this.Nstep = (int)streamReader.nextDouble();
            return 0;
        }
        if (string.equals("tmin")) {
            this.tinit = streamReader.nextDouble();
            return 0;
        }
        if (string.equals("tmax")) {
            this.tmax = streamReader.nextDouble();
            return 0;
        }
        if (string.equals("stepcontrol")) {
            String string2 = streamReader.next();
            if (!opaleSet.contains(string2) || opaleSet.getObject(string2) == null) {
                throw new InvalidFormatException("Incorrect data file : indentifier " + string2 + " doesn't exist !!");
            }
            if (!(opaleSet.getObject(string2) instanceof StepsizeControl)) {
                throw new InvalidFormatException("Incorrect data file : indentifier " + string2 + " is not a step control method !!");
            }
            this.stepcontrol = (StepsizeControl)opaleSet.getObject(string2);
            return 0;
        }
        return -1;
    }

    public void write(PrintWriter printWriter, OpaleSet opaleSet) {
        printWriter.println("{");
        printWriter.println("tmin " + this.tinit);
        printWriter.println("tmax " + this.tmax);
        printWriter.println("N " + this.Nstep);
        if (this.stepcontrol != null && this.stepcontrol.getId() != null) {
            printWriter.println("stepcontrol " + this.stepcontrol.getId());
        }
        printWriter.println("}");
    }
}

