/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.compat;

import java.awt.Point;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import ptolemy.plot.CmdLineArgException;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotApplication;
import ptolemy.plot.compat.PxgraphParser;
import ptolemy.util.StringUtilities;

public class PxgraphApplication
extends PlotApplication {
    private PxgraphParser _parser;

    public PxgraphApplication() throws Exception {
        this((String[])null);
    }

    public PxgraphApplication(String[] args) throws Exception {
        this(new Plot(), args);
    }

    public PxgraphApplication(Plot plot, String[] args) throws Exception {
        super(plot, args);
    }

    public static void main(final String[] args) {
        try {
            Runnable doActions = new Runnable(){

                public void run() {
                    try {
                        new PxgraphApplication(new Plot(), args);
                    }
                    catch (Exception ex) {
                        System.err.println(ex.toString());
                        ex.printStackTrace();
                    }
                }
            };
            SwingUtilities.invokeAndWait(doActions);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (_test) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "               pxgraph\n        A Java Plotting Tool\n\nBy: Edward A. Lee and\n    Christopher Brooks\nVersion 5.7, Build: $Id: PxgraphApplication.java,v 1.51 2007/12/06 21:57:02 cxh Exp $\n\nFor help, type 'pxgraph -help', or see \nthe class documentation in the plot.compat package.\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n", "About pxgraph", 1);
    }

    protected int _parseArgs(String[] args) throws CmdLineArgException, FileNotFoundException, IOException {
        int i = 0;
        String title = "Ptolemy plot, pxgraph version";
        int width = 400;
        int height = 300;
        while (args != null && i < args.length) {
            String arg;
            if ((arg = args[i++]).equals("-help")) {
                System.out.println(this._usage());
                StringUtilities.exit((int)0);
                continue;
            }
            if (arg.equals("-test")) {
                _test = true;
                continue;
            }
            if (arg.equals("-t")) {
                title = args[i++];
                continue;
            }
            if (arg.equals("-v") || arg.equals("-version")) {
                System.out.println("Version 5.7, Build $Id: PxgraphApplication.java,v 1.51 2007/12/06 21:57:02 cxh Exp $");
                StringUtilities.exit((int)0);
                continue;
            }
            if (!arg.startsWith("=")) continue;
            int xscreen = 1;
            int yscreen = 1;
            boolean screenlocationgiven = false;
            StringTokenizer stoken = new StringTokenizer(arg.substring(1, arg.length()), "=x-+");
            if (stoken.hasMoreTokens()) {
                width = Integer.valueOf(stoken.nextToken());
            }
            if (stoken.hasMoreTokens()) {
                height = Integer.valueOf(stoken.nextToken());
            }
            if (stoken.hasMoreTokens()) {
                xscreen = Integer.valueOf(stoken.nextToken());
                screenlocationgiven = true;
            }
            if (stoken.hasMoreTokens()) {
                yscreen = Integer.valueOf(stoken.nextToken());
                screenlocationgiven = true;
            }
            if (!screenlocationgiven) continue;
            this.setLocation(new Point(xscreen + 1, yscreen + 1));
        }
        this.setSize(width, height);
        this.setTitle(title);
        int argumentsRead = i++;
        if (this._parser == null) {
            this._parser = new PxgraphParser((Plot)this.plot);
        }
        this._parser.parseArgs(args);
        return argumentsRead;
    }

    protected void _read(URL base, InputStream in) throws IOException {
        this._parser.read(in);
    }

    protected String _usage() {
        int i;
        String[][] commandOptions = new String[][]{{"-bd", "<color>", "Border", "White", "(Unsupported)"}, {"-bg", "<color>", "BackGround", "White", ""}, {"-brb", "<base>", "BarBase", "0", "(Unsupported)"}, {"-brw", "<width>", "BarWidth", "1", ""}, {"-bw", "<size>", "BorderSize", "1", "(Unsupported)"}, {"-fg", "<color>", "Foreground", "Black", ""}, {"-gw", "<pixels>", "GridStyle", "1", "(Unsupported)"}, {"-lf", "<fontname>", "LabelFont", "helvetica-12", ""}, {"-lw", "<width>", "LineWidth", "0", "(Unsupported)"}, {"-lx", "<xl,xh>", "XLowLimit, XHighLimit", "0", ""}, {"-ly", "<yl,yh>", "YLowLimit, YHighLimit", "0", ""}, {"-o", "<output filename>", "", "/tmp/t.ps", ""}, {"-t", "<title>", "TitleText", "An X Graph", ""}, {"-tf", "<fontname>", "TitleFont", "helvetica-b-14", ""}, {"-x", "<unitName>", "XUnitText", "X", ""}, {"-y", "<unitName>", "YUnitText", "Y", ""}, {"-zg", "<color>", "ZeroColor", "Black", "(Unsupported)"}, {"-zw", "<width>", "ZeroWidth", "0", "(Unsupported)"}};
        String[][] commandFlags = new String[][]{{"-", "", "(read from standard in)"}, {"-bar", "BarGraph", ""}, {"-bb", "BoundBox", "(Ignored)"}, {"-bigendian", "", ""}, {"-littleendian", "", ""}, {"-binary", "Binary", ""}, {"-impulses", "Impulses", ""}, {"-help", "", ""}, {"-lnx", "XLog", ""}, {"-lny", "YLog", ""}, {"-m", "Markers", ""}, {"-M", "StyleMarkers", ""}, {"-nl", "NoLines", ""}, {"-p", "PixelMarkers", ""}, {"-P", "LargePixel", ""}, {"-rv", "ReverseVideo", ""}, {"-test", "Test", ""}, {"-tk", "Ticks", ""}, {"-v", "Version", ""}, {"-version", "Version", ""}};
        StringBuffer result = new StringBuffer("Usage: ptplot [ options ] [=WxH+X+Y] [file ...]\n\n options that take values as second args:\n");
        for (i = 0; i < commandOptions.length; ++i) {
            result.append(" " + commandOptions[i][0] + " " + commandOptions[i][1] + " " + commandOptions[i][4] + "\n");
        }
        result.append("\nBoolean flags:\n");
        for (i = 0; i < commandFlags.length; ++i) {
            result.append(" " + commandFlags[i][0] + " " + commandFlags[i][2] + "\n");
        }
        result.append("\nThe following pxgraph features are not supported:\n * Directives in pxgraph input files\n * Xresources\n");
        return result.toString();
    }
}

