/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleVector;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.util.VectorToolkit;

public class DiscreteFunction
extends MultiscaleFunction
implements Cloneable {
    protected AbstractDoubleVector data;

    public DiscreteFunction(double[] dArray) {
        this.setData(dArray);
    }

    public void setData(double[] dArray) {
        this.data = new DoubleVector(dArray);
    }

    public String toString() {
        return this.data.toString();
    }

    public final void normalize() {
        this.data = this.data.normalize();
    }

    public final double[] evaluate() {
        return VectorToolkit.toArray((AbstractDoubleVector)this.data);
    }

    public final boolean equals(Object object) {
        if (object != null && object instanceof DiscreteFunction) {
            DiscreteFunction discreteFunction = (DiscreteFunction)object;
            return this.data.equals((Object)discreteFunction.data);
        }
        return false;
    }

    public double[] evaluate(int n) {
        return this.evaluate();
    }

    public double mass(double d, double d2, int n) {
        return this.data.mass() / (double)(this.data.dimension() - 1) * Math.abs(d2 - d);
    }

    public final double norm() {
        return this.data.norm();
    }

    public double norm(int n) {
        return this.data.norm();
    }

    public Object clone() {
        DiscreteFunction discreteFunction = (DiscreteFunction)super.clone();
        discreteFunction.setData(VectorToolkit.toArray((AbstractDoubleVector)this.data));
        return discreteFunction;
    }

    public int dimension(int n) {
        return this.data.dimension();
    }

    public final int dimension() {
        return this.data.dimension();
    }

    public int getFilterType() {
        return this.data.dimension();
    }
}

