/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;

public final class CoordinateMath
extends AbstractMath {
    private CoordinateMath() {
    }

    public static double[] cartesianToPolar(double d, double d2) {
        double[] dArray = new double[2];
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        dArray[0] = d3 == 0.0 && d4 == 0.0 ? 0.0 : (d3 < d4 ? d4 * Math.sqrt(1.0 + d / d2 * (d / d2)) : d3 * Math.sqrt(1.0 + d2 / d * (d2 / d)));
        dArray[1] = Math.atan2(d2, d);
        return dArray;
    }

    public static double[] polarToCartesian(double d, double d2) {
        double[] dArray = new double[]{d * Math.cos(d2), d * Math.sin(d2)};
        return dArray;
    }

    public static double[] cartesianToSpherical(double d, double d2, double d3) {
        double[] dArray;
        dArray = new double[]{Math.sqrt(d * d + d2 * d2 + d3 * d3), Math.acos(d3 / dArray[0]), Math.atan2(d2, d)};
        return dArray;
    }

    public static double[] sphericalToCartesian(double d, double d2, double d3) {
        double[] dArray = new double[]{d * Math.sin(d2) * Math.cos(d3), d * Math.sin(d2) * Math.sin(d3), d * Math.cos(d2)};
        return dArray;
    }

    public static double[] cartesianToCylindrical(double d, double d2, double d3) {
        double[] dArray = new double[3];
        double[] dArray2 = CoordinateMath.cartesianToPolar(d, d2);
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        dArray[2] = d3;
        return dArray;
    }

    public static double[] cylindricalToCartesian(double d, double d2, double d3) {
        double[] dArray = new double[3];
        double[] dArray2 = CoordinateMath.polarToCartesian(d, d2);
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        dArray[2] = d3;
        return dArray;
    }

    public static double[] cylindricalToSpherical(double d, double d2, double d3) {
        double[] dArray = new double[3];
        double[] dArray2 = CoordinateMath.cartesianToPolar(d3, d);
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        dArray[2] = d2;
        return dArray;
    }

    public static double[] sphericalToCylindrical(double d, double d2, double d3) {
        double[] dArray = new double[3];
        double[] dArray2 = CoordinateMath.polarToCartesian(d, d2);
        dArray[0] = dArray2[1];
        dArray[1] = d3;
        dArray[2] = dArray2[0];
        return dArray;
    }
}

