/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.SpecialMath;

public final class ExtraMath
extends AbstractMath {
    private ExtraMath() {
    }

    public static double round(double d, int n) {
        if (d == 0.0) {
            return d;
        }
        if (n == 0) {
            return 0.0;
        }
        double d2 = ExtraMath.log10(Math.abs(d)) - (double)n;
        if (d2 < 0.0) {
            double d3 = Math.pow(10.0, Math.floor(-d2));
            return (double)Math.round(d * d3) / d3;
        }
        double d4 = Math.pow(10.0, Math.ceil(d2));
        return (double)Math.round(d / d4) * d4;
    }

    public static double random(double d, double d2) {
        return (d2 - d) * Math.random() + d;
    }

    public static int sign(double d) {
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double hypot(double d, double d2) {
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        if (d3 == 0.0 && d4 == 0.0) {
            return 0.0;
        }
        if (d3 < d4) {
            return d4 * Math.sqrt(1.0 + d / d2 * (d / d2));
        }
        return d3 * Math.sqrt(1.0 + d2 / d * (d2 / d));
    }

    public static int pow(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(n2 + " must be a positive integer.");
        }
        if (n2 == 0) {
            return 1;
        }
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 1 << n2;
        }
        for (int i = 1; i < n2; ++i) {
            n *= n;
        }
        return n;
    }

    public static int pow2(int n) {
        return 1 << n;
    }

    public static double factorial(double d) {
        return SpecialMath.gamma(d + 1.0);
    }

    public static double logFactorial(double d) {
        return SpecialMath.logGamma(d + 1.0);
    }

    public static int binomial(int n, int n2) {
        if (n2 == n || n2 == 0) {
            return 1;
        }
        if (n == 0) {
            return 1;
        }
        return ExtraMath.binomial(n - 1, n2 - 1) + ExtraMath.binomial(n - 1, n2);
    }

    public static double binomial(double d, double d2) {
        return Math.exp(SpecialMath.logGamma(d + 1.0) - SpecialMath.logGamma(d2 + 1.0) - SpecialMath.logGamma(d - d2 + 1.0));
    }

    public static double log10(double d) {
        return Math.log(d) / 2.302585092994046;
    }

    public static double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    public static double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    public static double tanh(double d) {
        return ExtraMath.sinh(d) / ExtraMath.cosh(d);
    }

    public static double coth(double d) {
        return 1.0 / ExtraMath.tanh(d);
    }

    public static double csch(double d) {
        return 1.0 / ExtraMath.sinh(d);
    }

    public static double sech(double d) {
        return 1.0 / ExtraMath.cosh(d);
    }

    public static double asinh(double d) {
        return Double.isInfinite(d) ? d : (d == 0.0 ? d : Math.log(d + Math.sqrt(d * d + 1.0)));
    }

    public static double acosh(double d) {
        return Math.log(d + Math.sqrt(d * d - 1.0));
    }

    public static double atanh(double d) {
        return d != 0.0 ? (Math.log(1.0 + d) - Math.log(1.0 - d)) / 2.0 : d;
    }

    public static double acoth(double d) {
        if (Double.isInfinite(d)) {
            return d < 0.0 ? -0.0 : 0.0;
        }
        return d == -1.0 ? Double.NEGATIVE_INFINITY : (Math.log(d + 1.0) - Math.log(d - 1.0)) / 2.0;
    }

    public static double acsch(double d) {
        if (Double.isInfinite(d)) {
            return d < 0.0 ? -0.0 : 0.0;
        }
        return d == 0.0 ? 1.0 / d : Math.log((1.0 + (double)ExtraMath.sign(d) * Math.sqrt(d * d + 1.0)) / d);
    }

    public static double asech(double d) {
        return d == 0.0 ? 1.0 / d : Math.log((1.0 + Math.sqrt(1.0 - d * d)) / d);
    }
}

