/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.LinearMath;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleVector;

public final class KarhunenLoeve {
    double[][] data;

    public KarhunenLoeve(double[][] dArray) {
        this.setData(dArray);
    }

    public double[][] getProductMatrix() {
        return KarhunenLoeve.getProductMatrix(this.data);
    }

    private static double[][] vectorToSquare(double[] dArray) {
        double[][] dArray2 = new double[dArray.length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray2[j][i] = dArray[i] * dArray[j];
            }
        }
        return dArray2;
    }

    private static void add(double[][] dArray, double d, double[][] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                double[] dArray3 = dArray[i];
                int n = j;
                dArray3[n] = dArray3[n] + dArray2[i][j] * d;
            }
        }
    }

    public static double[][] getProductMatrix(double[][] dArray) {
        double[][] dArray2 = new double[dArray[0].length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            KarhunenLoeve.add(dArray2, 1.0 / (double)dArray.length, KarhunenLoeve.vectorToSquare(dArray[i]));
        }
        return dArray2;
    }

    public static double[][] getProductMatrix(double[] dArray) {
        return KarhunenLoeve.vectorToSquare(dArray);
    }

    public double[][] getData() {
        return this.data;
    }

    public void setData(double[][] dArray) {
        this.data = dArray;
    }

    public AbstractDoubleVector[] getEigenvectors() throws MaximumIterationsExceededException {
        double[][] dArray = KarhunenLoeve.getProductMatrix(this.data);
        DoubleSquareMatrix doubleSquareMatrix = new DoubleSquareMatrix(dArray);
        AbstractDoubleVector[] abstractDoubleVectorArray = new DoubleVector[this.data[0].length];
        double[] dArray2 = LinearMath.eigenSolveSymmetric(doubleSquareMatrix, abstractDoubleVectorArray);
        KarhunenLoeve.tri(dArray2, abstractDoubleVectorArray);
        return abstractDoubleVectorArray;
    }

    public double[][] getEigenvectorArrays() throws MaximumIterationsExceededException {
        AbstractDoubleVector[] abstractDoubleVectorArray = this.getEigenvectors();
        double[][] dArray = new double[abstractDoubleVectorArray.length][abstractDoubleVectorArray[0].dimension()];
        for (int i = 0; i < abstractDoubleVectorArray.length; ++i) {
            for (int j = 0; j < abstractDoubleVectorArray[i].dimension(); ++j) {
                dArray[i][j] = abstractDoubleVectorArray[i].getComponent(j);
            }
        }
        return dArray;
    }

    private static void tri(double[] dArray, AbstractDoubleVector[] abstractDoubleVectorArray) {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < dArray.length - 1; ++i) {
                if (!(dArray[i] < dArray[i + 1])) continue;
                double d = dArray[i + 1];
                dArray[i + 1] = dArray[i];
                dArray[i] = d;
                bl = true;
                AbstractDoubleVector abstractDoubleVector = abstractDoubleVectorArray[i + 1];
                abstractDoubleVectorArray[i + 1] = abstractDoubleVectorArray[i];
                abstractDoubleVectorArray[i] = abstractDoubleVector;
            }
        }
    }
}

