/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.analysis;

import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public abstract class ComplexFunction
implements ComplexMapping,
Ring.Member {
    private static final ComplexFunction ZERO = ComplexFunction.constant(Complex.ZERO);

    public final int dimension() {
        return 1;
    }

    public Object getSet() {
        throw new RuntimeException("Not implemented: please file bug report");
    }

    public ComplexFunction compose(ComplexFunction complexFunction) {
        return new Composition(this, complexFunction);
    }

    public AbelianGroup.Member negate() {
        return new Negation(this);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof ComplexFunction) {
            return this.add((ComplexFunction)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexFunction add(ComplexFunction complexFunction) {
        return new Sum(this, complexFunction);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof ComplexFunction) {
            return this.subtract((ComplexFunction)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexFunction subtract(ComplexFunction complexFunction) {
        return new Difference(this, complexFunction);
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof ComplexFunction) {
            return this.multiply((ComplexFunction)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexFunction multiply(ComplexFunction complexFunction) {
        return new Product(this, complexFunction);
    }

    public Ring.Member inverse() {
        return new Reciprocal(this);
    }

    public Ring.Member divide(Ring.Member member) {
        if (member instanceof ComplexFunction) {
            return this.divide((ComplexFunction)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexFunction divide(ComplexFunction complexFunction) {
        return new Quotient(this, complexFunction);
    }

    public abstract ComplexFunction differentiate();

    public static ComplexFunction constant(Complex complex) {
        return new Constant(complex);
    }

    public abstract /* synthetic */ Complex map(double var1, double var3);

    public abstract /* synthetic */ Complex map(Complex var1);

    private static class Constant
    extends ComplexFunction {
        private final Complex A;

        public Constant(Complex complex) {
            this.A = complex;
        }

        public Complex map(double d, double d2) {
            return this.A;
        }

        public Complex map(Complex complex) {
            return this.A;
        }

        public ComplexFunction differentiate() {
            return ZERO;
        }
    }

    private static class Quotient
    extends ComplexFunction {
        private final ComplexFunction f1;
        private final ComplexFunction f2;

        public Quotient(ComplexFunction complexFunction, ComplexFunction complexFunction2) {
            this.f1 = complexFunction;
            this.f2 = complexFunction2;
        }

        public Complex map(double d, double d2) {
            return this.f1.map(d, d2).divide(this.f2.map(d, d2));
        }

        public Complex map(Complex complex) {
            return this.f1.map(complex).divide(this.f2.map(complex));
        }

        public ComplexFunction differentiate() {
            return new Quotient(new Difference(new Product(this.f1.differentiate(), this.f2), new Product(this.f1, this.f2.differentiate())), new Product(this.f2, this.f2));
        }
    }

    private static class Reciprocal
    extends ComplexFunction {
        private final ComplexFunction f;

        public Reciprocal(ComplexFunction complexFunction) {
            this.f = complexFunction;
        }

        public Complex map(double d, double d2) {
            return Complex.ONE.divide(this.f.map(d, d2));
        }

        public Complex map(Complex complex) {
            return Complex.ONE.divide(this.f.map(complex));
        }

        public ComplexFunction differentiate() {
            return new Quotient(new Negation(this.f.differentiate()), new Product(this.f, this.f));
        }
    }

    private static class Product
    extends ComplexFunction {
        private final ComplexFunction f1;
        private final ComplexFunction f2;

        public Product(ComplexFunction complexFunction, ComplexFunction complexFunction2) {
            this.f1 = complexFunction;
            this.f2 = complexFunction2;
        }

        public Complex map(double d, double d2) {
            return this.f1.map(d, d2).multiply(this.f2.map(d, d2));
        }

        public Complex map(Complex complex) {
            return this.f1.map(complex).multiply(this.f2.map(complex));
        }

        public ComplexFunction differentiate() {
            return new Sum(new Product(this.f1.differentiate(), this.f2), new Product(this.f1, this.f2.differentiate()));
        }
    }

    private static class Difference
    extends ComplexFunction {
        private final ComplexFunction f1;
        private final ComplexFunction f2;

        public Difference(ComplexFunction complexFunction, ComplexFunction complexFunction2) {
            this.f1 = complexFunction;
            this.f2 = complexFunction2;
        }

        public Complex map(double d, double d2) {
            return this.f1.map(d, d2).subtract(this.f2.map(d, d2));
        }

        public Complex map(Complex complex) {
            return this.f1.map(complex).subtract(this.f2.map(complex));
        }

        public ComplexFunction differentiate() {
            return new Difference(this.f1.differentiate(), this.f2.differentiate());
        }
    }

    private static class Sum
    extends ComplexFunction {
        private final ComplexFunction f1;
        private final ComplexFunction f2;

        public Sum(ComplexFunction complexFunction, ComplexFunction complexFunction2) {
            this.f1 = complexFunction;
            this.f2 = complexFunction2;
        }

        public Complex map(double d, double d2) {
            return this.f1.map(d, d2).add(this.f2.map(d, d2));
        }

        public Complex map(Complex complex) {
            return this.f1.map(complex).add(this.f2.map(complex));
        }

        public ComplexFunction differentiate() {
            return new Sum(this.f1.differentiate(), this.f2.differentiate());
        }
    }

    private static class Negation
    extends ComplexFunction {
        private final ComplexFunction f;

        public Negation(ComplexFunction complexFunction) {
            this.f = complexFunction;
        }

        public Complex map(double d, double d2) {
            return (Complex)this.f.map(d, d2).negate();
        }

        public Complex map(Complex complex) {
            return (Complex)this.f.map(complex).negate();
        }

        public ComplexFunction differentiate() {
            return new Negation(this.f.differentiate());
        }
    }

    private static class Composition
    extends ComplexFunction {
        private final ComplexFunction f1;
        private final ComplexFunction f2;

        public Composition(ComplexFunction complexFunction, ComplexFunction complexFunction2) {
            this.f1 = complexFunction;
            this.f2 = complexFunction2;
        }

        public Complex map(double d, double d2) {
            return this.f1.map(this.f2.map(d, d2));
        }

        public Complex map(Complex complex) {
            return this.f1.map(this.f2.map(complex));
        }

        public ComplexFunction differentiate() {
            return new Product(new Composition(this.f1.differentiate(), this.f2), this.f2.differentiate());
        }
    }
}

