/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.analysis;

import JSci.maths.analysis.Cosine;
import JSci.maths.analysis.RealFunction;

public class Sine
extends RealFunction {
    private final double A;
    private final double w;
    private final double k;

    public Sine() {
        this(1.0, 1.0, 0.0);
    }

    public Sine(double d, double d2, double d3) {
        this.A = d;
        this.w = d2;
        this.k = d3;
    }

    public double map(double d) {
        return this.A * Math.sin(this.w * d + this.k);
    }

    public RealFunction differentiate() {
        return new Cosine(this.A * this.w, this.w, this.k);
    }
}

