/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.analysis;

import JSci.maths.analysis.Cosine;
import JSci.maths.analysis.RealFunction;

public class Tangent
extends RealFunction {
    private final double A;
    private final double w;
    private final double k;

    public Tangent() {
        this(1.0, 1.0, 0.0);
    }

    public Tangent(double d, double d2, double d3) {
        this.A = d;
        this.w = d2;
        this.k = d3;
    }

    public double map(double d) {
        return this.A * Math.tan(this.w * d + this.k);
    }

    public RealFunction differentiate() {
        Cosine cosine = new Cosine(1.0, this.w, this.k);
        return RealFunction.constant(this.A * this.w).divide(cosine.multiply(cosine));
    }
}

