/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.categories;

import JSci.maths.ExtraMath;
import JSci.maths.MathInteger;
import JSci.maths.MathSet;
import JSci.maths.categories.Category;
import JSci.maths.categories.UndefinedCompositionException;

public class FinSet
implements Category {
    public Category.Morphism identity(Object object) {
        return new IdentityFunction((MathSet)object);
    }

    public Object cardinality(Object object) {
        return new MathInteger(((MathSet)object).cardinality());
    }

    public Category.HomSet hom(Object object, Object object2) {
        return new FunctionSet((MathSet)object, (MathSet)object2);
    }

    private class IdentityFunction
    extends Function {
        public IdentityFunction(MathSet mathSet) {
            super(mathSet, mathSet, null, null);
        }

        public Object map(Object object) {
            return object;
        }

        public Category.Morphism compose(Category.Morphism morphism) {
            if (morphism instanceof Function) {
                return morphism;
            }
            throw new IllegalArgumentException("Morphism is not a Function.");
        }
    }

    public class Function
    implements Category.Morphism {
        private final MathSet from;
        private final MathSet to;
        private final Object[] in;
        private final Object[] out;

        public Function(MathSet mathSet, MathSet mathSet2, Object[] objectArray, Object[] objectArray2) {
            this.from = mathSet;
            this.to = mathSet2;
            this.in = objectArray;
            this.out = objectArray2;
        }

        public Object domain() {
            return this.from;
        }

        public Object codomain() {
            return this.to;
        }

        public Object map(Object object) {
            for (int i = 0; i < this.in.length; ++i) {
                if (!object.equals(this.in[i])) continue;
                return this.out[i];
            }
            return null;
        }

        public Category.Morphism compose(Category.Morphism morphism) {
            if (morphism instanceof Function) {
                Function function = (Function)morphism;
                if (this.to.equals(function.from)) {
                    Object[] objectArray = new Object[this.in.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = function.map(this.out[i]);
                    }
                    return new Function(this.from, function.to, this.in, objectArray);
                }
                throw new UndefinedCompositionException();
            }
            throw new IllegalArgumentException("Morphism is not a Function.");
        }
    }

    public class FunctionSet
    implements MathSet,
    Category.HomSet {
        private final MathSet from;
        private final MathSet to;
        private final int size;

        public FunctionSet(MathSet mathSet, MathSet mathSet2) {
            this.from = mathSet;
            this.to = mathSet2;
            this.size = ExtraMath.pow(mathSet2.cardinality(), mathSet.cardinality());
        }

        public Function getElement(Object[] objectArray, Object[] objectArray2) {
            return new Function(this.from, this.to, objectArray, objectArray2);
        }

        public int cardinality() {
            return this.size;
        }

        public MathSet union(MathSet mathSet) {
            return mathSet.union(this);
        }

        public MathSet intersect(MathSet mathSet) {
            return mathSet.intersect(this);
        }
    }
}

