/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.symbolic;

import JSci.maths.fields.Field;
import JSci.maths.fields.RealField;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.symbolic.Constant;
import JSci.maths.symbolic.ExpressionParser;
import JSci.maths.symbolic.Negative;
import JSci.maths.symbolic.ParseException;
import JSci.maths.symbolic.Power;
import JSci.maths.symbolic.Product;
import JSci.maths.symbolic.Sum;
import JSci.maths.symbolic.Variable;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Expression
implements Field.Member {
    public Expression differentiate(Hashtable hashtable) {
        Expression expression = this;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            for (int i = 0; i < (Integer)hashtable.get(variable); ++i) {
                expression = expression.differentiate(variable);
            }
        }
        return expression;
    }

    public abstract Expression differentiate(Variable var1);

    public abstract Expression evaluate();

    protected abstract int getPriority();

    public Field.Member inverse() {
        return new Power(this, -1);
    }

    public Field.Member divide(Field.Member member) {
        Expression expression = member instanceof Expression ? (Expression)member.inverse() : new Constant(member.inverse());
        return new Product(this, expression);
    }

    public Ring.Member multiply(Ring.Member member) {
        Expression expression = member instanceof Expression ? (Expression)member : new Constant(member);
        return new Product(this, expression);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        Expression expression = member instanceof Expression ? (Expression)member : new Constant(member);
        return new Sum(this, expression);
    }

    public AbelianGroup.Member negate() {
        return new Negative(this);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        Expression expression = member instanceof Expression ? (Expression)member.negate() : new Constant(member.negate());
        return new Sum(this, expression);
    }

    public Ring.Member rise(int n) {
        return new Power(this, n);
    }

    public static Expression negative(AbelianGroup.Member member) {
        if (member instanceof Expression) {
            return (Expression)member.negate();
        }
        return new Constant(member.negate());
    }

    public static Expression sum(AbelianGroup.Member member, AbelianGroup.Member member2) {
        Expression expression = member instanceof Expression ? (Expression)member : new Constant(member);
        Expression expression2 = member2 instanceof Expression ? (Expression)member2 : new Constant(member2);
        return (Expression)expression.add(expression2);
    }

    public static Expression sum(AbelianGroup.Member[] memberArray) {
        Expression[] expressionArray = new Expression[memberArray.length];
        for (int i = 0; i < memberArray.length; ++i) {
            expressionArray[i] = memberArray[i] instanceof Expression ? (Expression)memberArray[i] : new Constant(memberArray[i]);
        }
        return new Sum(expressionArray);
    }

    public static Expression difference(AbelianGroup.Member member, AbelianGroup.Member member2) {
        Expression expression = member instanceof Expression ? (Expression)member : new Constant(member);
        Expression expression2 = member2 instanceof Expression ? (Expression)member2 : new Constant(member2);
        return (Expression)expression.subtract(expression2);
    }

    public static Expression product(Ring.Member member, Ring.Member member2) {
        Expression expression = member instanceof Expression ? (Expression)member : new Constant(member);
        Expression expression2 = member2 instanceof Expression ? (Expression)member2 : new Constant(member2);
        return (Expression)expression.multiply(expression2);
    }

    public static Expression product(Ring.Member[] memberArray) {
        Expression[] expressionArray = new Expression[memberArray.length];
        for (int i = 0; i < memberArray.length; ++i) {
            expressionArray[i] = memberArray[i] instanceof Expression ? (Expression)memberArray[i] : new Constant(memberArray[i]);
        }
        return new Product(expressionArray);
    }

    public static Expression inverse(Field.Member member) {
        if (member instanceof Expression) {
            return (Expression)member.inverse();
        }
        return new Constant(member.inverse());
    }

    public static Expression divide(Field.Member member, Field.Member member2) {
        Expression expression = member instanceof Expression ? (Expression)member : new Constant(member);
        Expression expression2 = member2 instanceof Expression ? (Expression)member2 : new Constant(member2);
        return (Expression)expression.divide(expression2);
    }

    public static Expression power(Field.Member member, int n) {
        Expression expression = member instanceof Expression ? (Expression)member : new Constant(member);
        return new Power(expression, n);
    }

    public static void main(String[] stringArray) throws ParseException {
        for (int i = 0; i < stringArray.length; ++i) {
            Hashtable<String, Variable> hashtable = new Hashtable<String, Variable>();
            hashtable.put("y", new Variable("y", RealField.getInstance()));
            Expression expression = ExpressionParser.parse(stringArray[i], hashtable);
            System.out.println("F = " + expression);
            System.out.println("F = " + expression.evaluate());
            System.out.println("dF/dx = " + expression.differentiate((Variable)hashtable.get("x")).evaluate());
            System.out.println("dF/dy = " + expression.differentiate((Variable)hashtable.get("y")).evaluate());
            System.out.println(" ");
        }
    }

    public abstract /* synthetic */ Object getSet();
}

