/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.maths.ExtraMath;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleVector;
import JSci.maths.vectors.MathVector;

public abstract class AbstractIntegerVector
extends MathVector {
    protected AbstractIntegerVector(int n) {
        super(n);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof AbstractIntegerVector) {
            AbstractIntegerVector abstractIntegerVector = (AbstractIntegerVector)object;
            return this.dimension() == abstractIntegerVector.dimension() && this.subtract(abstractIntegerVector).norm() == 0.0;
        }
        return false;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(8 * this.N);
        for (n = 0; n < this.N - 1; ++n) {
            stringBuffer.append(this.getComponent(n));
            stringBuffer.append(',');
        }
        stringBuffer.append(this.getComponent(n));
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public AbstractDoubleVector toDoubleVector() {
        double[] dArray = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            dArray[i] = this.getComponent(i);
        }
        return new DoubleVector(dArray);
    }

    public abstract int getComponent(int var1);

    public abstract void setComponent(int var1, int var2);

    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    public double norm(int n) {
        double d = Math.pow(Math.abs(this.getComponent(0)), n);
        for (int i = 1; i < this.N; ++i) {
            d += Math.pow(Math.abs(this.getComponent(i)), n);
        }
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        double d = this.getComponent(0);
        for (int i = 1; i < this.N; ++i) {
            d = ExtraMath.hypot(d, this.getComponent(i));
        }
        return d;
    }

    public double infNorm() {
        int n = Math.abs(this.getComponent(0));
        for (int i = 1; i < this.N; ++i) {
            int n2 = Math.abs(this.getComponent(i));
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public abstract AbstractIntegerVector add(AbstractIntegerVector var1);

    public abstract AbstractIntegerVector subtract(AbstractIntegerVector var1);

    public abstract AbstractIntegerVector scalarMultiply(int var1);

    public abstract int scalarProduct(AbstractIntegerVector var1);
}

