/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl2;

import java.io.BufferedReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import javax.media.opengl.GL2ES1;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PParameters;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl2.PGraphicsOpenGL2;
import processing.opengl2.PTexture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PShape3D
extends PShape
implements PConstants {
    protected PApplet papplet;
    protected GL2ES1 gl;
    protected PGraphicsOpenGL2 pgl;
    protected static final int VERTICES = 0;
    protected static final int NORMALS = 1;
    protected static final int COLORS = 2;
    protected static final int TEXCOORDS = 3;
    protected int glUsage;
    protected int numTexBuffers;
    protected int glVertexBufferID;
    protected int glColorBufferID;
    protected int glNormalBufferID;
    protected int[] glTexCoordBufferID;
    protected FloatBuffer vertexBuffer;
    protected FloatBuffer colorBuffer;
    protected FloatBuffer normalBuffer;
    protected FloatBuffer texCoordBuffer;
    public float[] vertices;
    public float[] colors;
    public float[] normals;
    public float[] texcoords;
    protected float[] convTexcoords;
    protected float[][] allTexcoords;
    protected PShape3D[] vertexChild;
    protected boolean[] texCoordSet;
    protected boolean autoBounds = true;
    boolean readFromOBJ = false;
    ArrayList<PVector> objVertices;
    ArrayList<PVector> objNormal;
    ArrayList<PVector> objTexCoords;
    ArrayList<OBJFace> objFaces;
    ArrayList<OBJMaterial> objMaterials;
    protected int glMode;
    protected boolean pointSprites;
    protected PImage[] textures;
    protected float maxSpriteSize = PGraphicsOpenGL2.maxPointSize;
    protected float[] spriteDistAtt = new float[]{1.0f, 0.0f, 0.0f};
    protected PTexture[] renderTextures;
    protected PShape3D root;
    protected int updateElement;
    protected int updateTexunit;
    protected int firstUpdateIdx;
    protected int lastUpdateIdx;
    protected int firstVertex;
    protected int lastVertex;
    public float xmin;
    public float xmax;
    public float ymin;
    public float ymax;
    public float zmin;
    public float zmax;

    public PShape3D() {
        this.papplet = null;
        this.pgl = null;
        this.glVertexBufferID = 0;
        this.glColorBufferID = 0;
        this.glNormalBufferID = 0;
        this.glTexCoordBufferID = null;
    }

    public PShape3D(PApplet parent) {
        this();
        this.papplet = parent;
        this.pgl = (PGraphicsOpenGL2)parent.g;
        this.family = 0;
        this.name = "root";
        this.root = this;
    }

    public PShape3D(PApplet parent, int numVert) {
        this(parent, numVert, new Parameters());
    }

    public PShape3D(PApplet parent, String filename, Parameters params) {
        this.papplet = parent;
        this.pgl = (PGraphicsOpenGL2)parent.g;
        this.family = 0;
        this.name = "root";
        this.root = this;
        this.glVertexBufferID = 0;
        this.glColorBufferID = 0;
        this.glNormalBufferID = 0;
        this.glTexCoordBufferID = null;
        this.initShapeOBJ(filename, params);
    }

    public PShape3D(PApplet parent, int size, Parameters params) {
        this.papplet = parent;
        this.pgl = (PGraphicsOpenGL2)parent.g;
        this.family = 0;
        this.name = "root";
        this.root = this;
        this.glVertexBufferID = 0;
        this.glColorBufferID = 0;
        this.glNormalBufferID = 0;
        this.glTexCoordBufferID = null;
        this.initShape(size, params);
    }

    public void delete() {
        if (this.root != this) {
            return;
        }
        this.deleteVertexBuffer();
        this.deleteColorBuffer();
        this.deleteTexCoordBuffer();
        this.deleteNormalBuffer();
    }

    public void loadVertices() {
        this.loadVertices(this.firstVertex, this.lastVertex);
    }

    public void loadVertices(int first, int last) {
        if (last < first || first < this.firstVertex || this.lastVertex < last) {
            PGraphics.showWarning((String)"PShape3D: wrong vertex index");
            this.updateElement = -1;
            return;
        }
        if (this.updateElement != -1) {
            PGraphics.showWarning((String)"PShape3D: can load only one type of data at the time");
            return;
        }
        this.updateElement = 0;
        this.firstUpdateIdx = first;
        this.lastUpdateIdx = last;
        this.gl.glBindBuffer(34962, this.glVertexBufferID);
        this.vertexBuffer = this.gl.glMapBuffer(34962, 35001).asFloatBuffer();
    }

    public void updateVertices() {
        if (this.updateElement == 0) {
            int offset = this.firstUpdateIdx * 3;
            int size = (this.lastUpdateIdx - this.firstUpdateIdx + 1) * 3;
            if (this.root.autoBounds) {
                this.updateBounds(this.firstUpdateIdx, this.lastUpdateIdx);
            }
            this.vertexBuffer.position(0);
            this.vertexBuffer.put(this.vertices, offset, size);
            this.vertexBuffer.flip();
            this.gl.glUnmapBuffer(34962);
            this.gl.glBindBuffer(34962, 0);
            this.updateElement = -1;
        } else {
            PGraphics.showWarning((String)"PShape3D: need to call loadVertices() first");
        }
    }

    public void loadColors() {
        this.loadColors(this.firstVertex, this.lastVertex);
    }

    public void loadColors(int first, int last) {
        if (last < first || first < this.firstVertex || this.lastVertex < last) {
            PGraphics.showWarning((String)"PShape3D: wrong vertex index");
            this.updateElement = -1;
            return;
        }
        if (this.updateElement != -1) {
            PGraphics.showWarning((String)"PShape3D: can load only one type of data at the time");
            return;
        }
        this.updateElement = 2;
        this.firstUpdateIdx = first;
        this.lastUpdateIdx = last;
        this.gl.glBindBuffer(34962, this.glColorBufferID);
        this.colorBuffer = this.gl.glMapBuffer(34962, 35001).asFloatBuffer();
    }

    public void updateColors() {
        if (this.updateElement == 2) {
            int offset = this.firstUpdateIdx * 4;
            int size = (this.lastUpdateIdx - this.firstUpdateIdx + 1) * 4;
            this.colorBuffer.position(0);
            this.colorBuffer.put(this.colors, offset, size);
            this.colorBuffer.flip();
            this.gl.glUnmapBuffer(34962);
            this.gl.glBindBuffer(34962, 0);
            this.updateElement = -1;
        } else {
            PGraphics.showWarning((String)"PShape3D: need to call loadColors() first");
        }
    }

    public void loadNormals() {
        this.loadNormals(this.firstVertex, this.lastVertex);
    }

    public void loadNormals(int first, int last) {
        if (last < first || first < this.firstVertex || this.lastVertex < last) {
            PGraphics.showWarning((String)"PShape3D: wrong vertex index");
            this.updateElement = -1;
            return;
        }
        if (this.updateElement != -1) {
            PGraphics.showWarning((String)"PShape3D: can load only one type of data at the time");
            return;
        }
        this.updateElement = 1;
        this.firstUpdateIdx = first;
        this.lastUpdateIdx = last;
        this.gl.glBindBuffer(34962, this.glNormalBufferID);
        this.normalBuffer = this.gl.glMapBuffer(34962, 35001).asFloatBuffer();
    }

    public void updateNormals() {
        if (this.updateElement == 1) {
            int offset = this.firstUpdateIdx * 3;
            int size = (this.lastUpdateIdx - this.firstUpdateIdx + 1) * 3;
            this.normalBuffer.position(0);
            this.normalBuffer.put(this.normals, offset, size);
            this.normalBuffer.flip();
            this.gl.glUnmapBuffer(34962);
            this.gl.glBindBuffer(34962, 0);
            this.updateElement = -1;
        } else {
            PGraphics.showWarning((String)"PShape3D: need to call loadNormals() first");
        }
    }

    public void loadTexcoords() {
        this.loadTexcoords(0);
    }

    public void loadTexcoords(int unit) {
        this.loadTexcoords(unit, this.firstVertex, this.lastVertex);
    }

    protected void loadTexcoords(int unit, int first, int last) {
        if (last < first || first < this.firstVertex || this.lastVertex < last) {
            PGraphics.showWarning((String)"PShape3D: wrong vertex index");
            this.updateElement = -1;
            return;
        }
        if (this.updateElement != -1) {
            PGraphics.showWarning((String)"PShape3D: can load only one type of data at the time");
            return;
        }
        if (PGraphicsOpenGL2.maxTextureUnits <= unit) {
            PGraphics.showWarning((String)"PShape3D: wrong texture unit");
            return;
        }
        this.updateElement = 3;
        this.firstUpdateIdx = first;
        this.lastUpdateIdx = last;
        this.updateTexunit = unit;
        if (this.numTexBuffers <= unit) {
            this.addTexBuffers(unit - this.numTexBuffers + 1);
        }
        this.gl.glBindBuffer(34962, this.glTexCoordBufferID[unit]);
        this.texCoordBuffer = this.gl.glMapBuffer(34962, 35001).asFloatBuffer();
        this.texcoords = this.allTexcoords[unit];
    }

    public void updateTexcoords() {
        if (this.updateElement == 3) {
            int offset = this.firstUpdateIdx * 2;
            int size = (this.lastUpdateIdx - this.firstUpdateIdx + 1) * 2;
            this.convertTexcoords();
            this.texCoordBuffer.position(0);
            this.texCoordBuffer.put(this.convTexcoords, offset, size);
            this.texCoordBuffer.flip();
            this.gl.glUnmapBuffer(34962);
            this.gl.glBindBuffer(34962, 0);
            this.texCoordSet[this.updateTexunit] = true;
            this.updateElement = -1;
        } else {
            PGraphics.showWarning((String)"PShape3D: need to call loadTexcoords() first");
        }
    }

    public float[] get(int idx) {
        float[] v = null;
        if (this.updateElement == 0) {
            v = new float[3];
            PApplet.arrayCopy((Object)this.vertices, (int)(3 * idx), (Object)v, (int)0, (int)3);
        } else if (this.updateElement == 2) {
            v = new float[4];
            PApplet.arrayCopy((Object)this.colors, (int)(4 * idx), (Object)v, (int)0, (int)4);
        } else if (this.updateElement == 1) {
            v = new float[3];
            PApplet.arrayCopy((Object)this.normals, (int)(3 * idx), (Object)v, (int)0, (int)3);
        } else if (this.updateElement == 3) {
            v = new float[2];
            PApplet.arrayCopy((Object)this.texcoords, (int)(2 * idx), (Object)v, (int)0, (int)2);
        }
        return v;
    }

    public void set(int idx, float[] v) {
        if (this.updateElement == 0) {
            PApplet.arrayCopy((Object)v, (int)0, (Object)this.vertices, (int)(3 * idx), (int)3);
        } else if (this.updateElement == 2) {
            PApplet.arrayCopy((Object)v, (int)0, (Object)this.colors, (int)(4 * idx), (int)4);
        } else if (this.updateElement == 1) {
            PApplet.arrayCopy((Object)v, (int)0, (Object)this.normals, (int)(3 * idx), (int)3);
        } else if (this.updateElement == 3) {
            PApplet.arrayCopy((Object)v, (int)0, (Object)this.texcoords, (int)(2 * idx), (int)2);
        }
    }

    public void set(int idx, int c) {
        this.set(idx, PShape3D.rgba(c));
    }

    public void set(int idx, float x, float y) {
        if (this.updateElement == 0) {
            this.set(idx, new float[]{x, y, 0.0f});
        } else if (this.updateElement == 3) {
            this.set(idx, new float[]{x, y});
        }
    }

    public void set(int idx, float x, float y, float z) {
        if (this.updateElement == 0) {
            this.set(idx, new float[]{x, y, z});
        } else if (this.updateElement == 1) {
            this.set(idx, new float[]{x, y, z});
        } else if (this.updateElement == 2) {
            this.set(idx, new float[]{x, y, z, 1.0f});
        }
    }

    public void set(int idx, float x, float y, float z, float w) {
        if (this.updateElement == 2) {
            this.set(idx, new float[]{x, y, z, w});
        }
    }

    public static int color(float[] rgba) {
        int r = (int)(rgba[0] * 255.0f);
        int g = (int)(rgba[1] * 255.0f);
        int b = (int)(rgba[2] * 255.0f);
        int a = (int)(rgba[3] * 255.0f);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static float[] rgba(int c) {
        int a = c >> 24 & 0xFF;
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c >> 0 & 0xFF;
        float[] res = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f};
        return res;
    }

    public void autoBounds(boolean value) {
        this.root.autoBounds = value;
    }

    public void updateBounds() {
        this.updateBounds(this.firstVertex, this.lastVertex);
    }

    protected void updateBounds(int first, int last) {
        if (first <= this.firstVertex && this.lastVertex <= last) {
            this.resetBounds();
        }
        if (this.family == 0) {
            if (this.root == this && this.childCount == 0) {
                int i = this.firstVertex;
                while (i <= this.lastVertex) {
                    this.updateBounds(this.vertices[3 * i + 0], this.vertices[3 * i + 1], this.vertices[3 * i + 2]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.childCount) {
                    PShape3D child = (PShape3D)this.children[i];
                    child.updateBounds(first, last);
                    this.xmin = PApplet.min((float)this.xmin, (float)child.xmin);
                    this.xmax = PApplet.max((float)this.xmax, (float)child.xmax);
                    this.ymin = PApplet.min((float)this.ymin, (float)child.ymin);
                    this.ymax = PApplet.max((float)this.ymax, (float)child.ymax);
                    this.zmin = PApplet.min((float)this.zmin, (float)child.zmin);
                    this.zmax = PApplet.max((float)this.zmax, (float)child.zmax);
                    this.width = this.xmax - this.xmin;
                    this.height = this.ymax - this.ymin;
                    this.depth = this.zmax - this.zmin;
                    ++i;
                }
            }
        } else {
            int n0 = PApplet.max((int)first, (int)this.firstVertex);
            int n1 = PApplet.min((int)last, (int)this.lastVertex);
            int i = n0;
            while (i <= n1) {
                this.updateBounds(this.vertices[3 * i + 0], this.vertices[3 * i + 1], this.vertices[3 * i + 2]);
                ++i;
            }
        }
    }

    protected void resetBounds() {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                ((PShape3D)this.children[i]).resetBounds();
                ++i;
            }
        }
        this.depth = 0.0f;
        this.height = 0.0f;
        this.width = 0.0f;
        this.zmin = 10000.0f;
        this.ymin = 10000.0f;
        this.xmin = 10000.0f;
        this.zmax = -10000.0f;
        this.ymax = -10000.0f;
        this.xmax = -10000.0f;
    }

    protected void updateBounds(float x, float y, float z) {
        this.xmin = PApplet.min((float)this.xmin, (float)x);
        this.xmax = PApplet.max((float)this.xmax, (float)x);
        this.ymin = PApplet.min((float)this.ymin, (float)y);
        this.ymax = PApplet.max((float)this.ymax, (float)y);
        this.zmin = PApplet.min((float)this.zmin, (float)z);
        this.zmax = PApplet.max((float)this.zmax, (float)z);
        this.width = this.xmax - this.xmin;
        this.height = this.ymax - this.ymin;
        this.depth = this.zmax - this.zmin;
    }

    protected void convertTexcoords() {
        PTexture tex0 = null;
        float uscale = 1.0f;
        float vscale = 1.0f;
        float cx = 0.0f;
        float sx = 1.0f;
        float cy = 0.0f;
        float sy = 1.0f;
        int i = this.firstUpdateIdx;
        while (i <= this.lastUpdateIdx) {
            if (this.vertexChild[i] != null && this.vertexChild[i].textures[this.updateTexunit] != null) {
                PImage img = this.vertexChild[i].textures[this.updateTexunit];
                PTexture tex = this.pgl.getTexture(img);
                if (tex != tex0) {
                    uscale = 1.0f;
                    vscale = 1.0f;
                    cx = 0.0f;
                    sx = 1.0f;
                    cy = 0.0f;
                    sy = 1.0f;
                    if (tex != null) {
                        if (tex.isFlippedX()) {
                            cx = 1.0f;
                            sx = -1.0f;
                        }
                        if (tex.isFlippedY()) {
                            cy = 1.0f;
                            sy = -1.0f;
                        }
                        uscale *= tex.getMaxTexCoordU();
                        vscale *= tex.getMaxTexCoordV();
                    }
                    tex0 = tex;
                }
                float u = this.texcoords[2 * i + 0];
                float v = this.texcoords[2 * i + 1];
                u = (cx + sx * u) * uscale;
                v = (cy + sy * v) * vscale;
                this.convTexcoords[2 * i + 0] = u;
                this.convTexcoords[2 * i + 1] = v;
            }
            ++i;
        }
    }

    public static PShape createChild(int n0, int n1) {
        return PShape3D.createChild(null, n0, n1, 2, 0.0f, null);
    }

    public static PShape createChild(String name, int n0, int n1) {
        return PShape3D.createChild(name, n0, n1, 2, 0.0f, null);
    }

    public static PShape createChild(String name, int n0, int n1, int mode) {
        return PShape3D.createChild(name, n0, n1, mode, 0.0f, null);
    }

    public static PShape createChild(String name, int n0, int n1, int mode, float weight) {
        return PShape3D.createChild(name, n0, n1, mode, weight, null);
    }

    public static PShape createChild(String name, int n0, int n1, int mode, float weight, PImage[] tex) {
        PShape3D child = new PShape3D();
        child.family = 3;
        child.name = name;
        child.firstVertex = n0;
        child.lastVertex = n1;
        child.setDrawModeImpl(mode);
        child.strokeWeight = weight;
        child.textures = new PImage[2];
        child.renderTextures = new PTexture[2];
        Arrays.fill(child.textures, null);
        if (tex != null) {
            int n = PApplet.min((int)tex.length, (int)child.textures.length);
            PApplet.arrayCopy((Object)tex, (int)0, (Object)child.textures, (int)0, (int)n);
        }
        return child;
    }

    public void addChild(String name, int n0, int n1) {
        PShape child = PShape3D.createChild(name, n0, n1, this.getDrawModeImpl());
        this.addChild(child);
    }

    public void addChild(String name, int n0, int n1, int mode) {
        PShape child = PShape3D.createChild(name, n0, n1, mode);
        this.addChild(child);
    }

    public void addChild(String name, int n0, int n1, int mode, float weight) {
        PShape child = PShape3D.createChild(name, n0, n1, mode, weight);
        this.addChild(child);
    }

    public void addChild(String name, int n0, int n1, int mode, float weight, PImage[] tex) {
        PShape child = PShape3D.createChild(name, n0, n1, mode, weight, tex);
        this.addChild(child);
    }

    public void addChild(PShape who) {
        this.addChildImpl(who, true);
    }

    protected void addChildImpl(PShape who, boolean newShape) {
        if (this.family == 0) {
            super.addChild(who);
            if (newShape) {
                PShape3D who3d = (PShape3D)who;
                who3d.papplet = this.papplet;
                who3d.pgl = this.pgl;
                who3d.gl = this.gl;
                who3d.root = this.root;
                who3d.numTexBuffers = this.root.numTexBuffers;
                who3d.glVertexBufferID = this.root.glVertexBufferID;
                who3d.glColorBufferID = this.root.glColorBufferID;
                who3d.glNormalBufferID = this.root.glNormalBufferID;
                who3d.glTexCoordBufferID = this.root.glTexCoordBufferID;
                who3d.vertexBuffer = this.root.vertexBuffer;
                who3d.colorBuffer = this.root.colorBuffer;
                who3d.normalBuffer = this.root.normalBuffer;
                who3d.texCoordBuffer = this.root.texCoordBuffer;
                who3d.vertices = this.root.vertices;
                who3d.colors = this.root.colors;
                who3d.normals = this.root.normals;
                who3d.texcoords = this.root.texcoords;
                who3d.convTexcoords = this.root.convTexcoords;
                who3d.allTexcoords = this.root.allTexcoords;
                who3d.vertexChild = this.root.vertexChild;
                who3d.texCoordSet = this.root.texCoordSet;
                who3d.style = this.root.style;
                int n = who3d.firstVertex;
                while (n <= who3d.lastVertex) {
                    who3d.vertexChild[n] = who3d;
                    ++n;
                }
                int i = 0;
                while (i < who3d.textures.length) {
                    if (who3d.textures[i] != null && who3d.texCoordSet[i]) {
                        who3d.loadTexcoords(i);
                        who3d.updateTexcoords();
                    }
                    ++i;
                }
            }
        } else {
            PGraphics.showWarning((String)"PShape3D: Child shapes can only be added to a group shape.");
        }
    }

    public void addName(String nom, PShape shape) {
        if (this.nameTable == null) {
            this.nameTable = new HashMap();
        }
        this.nameTable.put(nom, shape);
    }

    protected void addDefaultChild() {
        PShape child = PShape3D.createChild("geometry", 0, this.vertexCount - 1, this.getDrawModeImpl(), 0.0f, null);
        this.addChild(child);
    }

    public PShape groupChildren(int cidx0, int cidx1, String gname) {
        if (this.family != 0) {
            return null;
        }
        return this.groupChildren(new int[]{cidx0, cidx1}, gname);
    }

    public PShape groupChildren(int cidx0, int cidx1, int cidx2, String gname) {
        if (this.family != 0) {
            return null;
        }
        return this.groupChildren(new int[]{cidx0, cidx1, cidx2}, gname);
    }

    public PShape groupChildren(int[] cidxs, String gname) {
        if (this.family != 0) {
            return null;
        }
        PShape[] temp = new PShape[cidxs.length];
        int nsel = 0;
        int i = 0;
        while (i < cidxs.length) {
            PShape child = this.getChild(cidxs[i]);
            if (child != null) {
                temp[nsel] = child;
                ++nsel;
            }
            ++i;
        }
        PShape[] schildren = new PShape[nsel];
        PApplet.arrayCopy((Object)temp, (Object)schildren, (int)nsel);
        return this.groupChildren(schildren, gname);
    }

    public PShape groupChildren(String cname0, String cname1, String gname) {
        if (this.family != 0) {
            return null;
        }
        return this.groupChildren(new String[]{cname0, cname1}, gname);
    }

    public PShape groupChildren(String cname0, String cname1, String cname2, String gname) {
        if (this.family != 0) {
            return null;
        }
        return this.groupChildren(new String[]{cname0, cname1, cname2}, gname);
    }

    public PShape groupChildren(String[] cnames, String gname) {
        if (this.family != 0) {
            return null;
        }
        PShape[] temp = new PShape[cnames.length];
        int nsel = 0;
        int i = 0;
        while (i < cnames.length) {
            PShape child = this.getChild(cnames[i]);
            if (child != null) {
                temp[nsel] = child;
                ++nsel;
            }
            ++i;
        }
        PShape[] schildren = new PShape[nsel];
        PApplet.arrayCopy((Object)temp, (Object)schildren, (int)nsel);
        return this.groupChildren(schildren, gname);
    }

    public PShape groupChildren(PShape[] gchildren, String gname) {
        int idx;
        if (this.family != 0) {
            return null;
        }
        PShape3D group = new PShape3D();
        group.family = 0;
        group.name = gname;
        group.papplet = this.papplet;
        group.pgl = this.pgl;
        group.gl = this.gl;
        group.root = this.root;
        PShape child = gchildren[0];
        PShape p = child.getParent();
        if (p != null) {
            idx = p.getChildIndex(child);
            if (idx < 0) {
                idx = 0;
            }
        } else {
            p = this;
            idx = 0;
        }
        p.addChild((PShape)group, idx);
        int i = 0;
        while (i < gchildren.length) {
            child = gchildren[i];
            p = child.getParent();
            if (p != null && -1 < (idx = p.getChildIndex(child))) {
                p.removeChild(idx);
            }
            ++i;
        }
        group.firstVertex = this.root.vertexCount;
        group.lastVertex = 0;
        i = 0;
        while (i < gchildren.length) {
            group.firstVertex = PApplet.min((int)group.firstVertex, (int)((PShape3D)gchildren[i]).firstVertex);
            group.lastVertex = PApplet.max((int)group.lastVertex, (int)((PShape3D)gchildren[i]).lastVertex);
            ++i;
        }
        i = 0;
        while (i < gchildren.length) {
            group.addChildImpl(gchildren[i], false);
            ++i;
        }
        return group;
    }

    public int getFirstVertex() {
        return this.firstVertex;
    }

    public int getFirstVertex(int idx) {
        if (idx >= 0 && idx < this.childCount) {
            return ((PShape3D)this.children[idx]).getFirstVertex();
        }
        return -1;
    }

    public void setFirstVertex(int n0) {
        this.firstVertex = n0;
    }

    public void setFirstVertex(int idx, int n0) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setFirstVertex(n0);
        }
    }

    public int getLastVertex() {
        return this.lastVertex;
    }

    public int getLastVertex(int idx) {
        if (idx >= 0 && idx < this.childCount) {
            return ((PShape3D)this.children[idx]).getLastVertex();
        }
        return -1;
    }

    public void setLastVertex(int n1) {
        this.lastVertex = n1;
    }

    public void setLastVertex(int idx, int n1) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setLastVertex(n1);
        }
    }

    public void setDrawMode(int mode) {
        if (this.family == 0) {
            this.init();
            this.setDrawModeImpl(mode);
            int n = 0;
            while (n < this.childCount) {
                this.setDrawMode(n, mode);
                ++n;
            }
        } else {
            this.setDrawModeImpl(mode);
        }
    }

    public void setDrawMode(int idx, int mode) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setDrawMode(mode);
        }
    }

    protected void setDrawModeImpl(int mode) {
        this.pointSprites = false;
        if (mode == 2) {
            this.glMode = 0;
        } else if (mode == 52) {
            this.glMode = 0;
            this.pointSprites = true;
        } else if (mode == 4) {
            this.glMode = 1;
        } else if (mode == 50) {
            this.glMode = 3;
        } else if (mode == 51) {
            this.glMode = 2;
        } else if (mode == 9) {
            this.glMode = 4;
        } else if (mode == 11) {
            this.glMode = 6;
        } else if (mode == 10) {
            this.glMode = 5;
        } else {
            throw new RuntimeException("PShape3D: Unknown draw mode");
        }
    }

    protected boolean isTexturable() {
        return this.glMode == 4 || this.glMode == 6 || this.glMode == 5 || this.pointSprites;
    }

    public int getDrawMode() {
        if (this.family == 0) {
            this.init();
            return this.getDrawMode(0);
        }
        return this.getDrawModeImpl();
    }

    public int getDrawMode(int idx) {
        if (idx >= 0 && idx < this.childCount) {
            return ((PShape3D)this.children[idx]).getDrawMode();
        }
        return -1;
    }

    protected int getDrawModeImpl() {
        if (this.glMode == 0) {
            if (this.pointSprites) {
                return 52;
            }
            return 2;
        }
        if (this.glMode == 1) {
            return 4;
        }
        if (this.glMode == 3) {
            return 50;
        }
        if (this.glMode == 2) {
            return 51;
        }
        if (this.glMode == 4) {
            return 9;
        }
        if (this.glMode == 6) {
            return 11;
        }
        if (this.glMode == 5) {
            return 10;
        }
        return -1;
    }

    public void setTexture(PImage tex) {
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.setTexture(i, tex);
                ++i;
            }
        } else {
            this.setTextureImpl(tex, 0);
        }
    }

    public void setTexture(PImage tex0, PImage tex1) {
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.setTexture(i, tex0, tex1);
                ++i;
            }
        } else {
            this.setTextureImpl(tex0, 0);
            this.setTextureImpl(tex1, 1);
        }
    }

    public void setTexture(PImage tex0, PImage tex1, PImage tex2) {
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.setTexture(i, tex0, tex1, tex2);
                ++i;
            }
        } else {
            this.setTextureImpl(tex0, 0);
            this.setTextureImpl(tex1, 1);
            this.setTextureImpl(tex2, 2);
        }
    }

    public void setTexture(PImage tex0, PImage tex1, PImage tex2, PImage tex3) {
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.setTexture(i, tex0, tex1, tex2, tex3);
                ++i;
            }
        } else {
            this.setTextureImpl(tex0, 0);
            this.setTextureImpl(tex1, 1);
            this.setTextureImpl(tex2, 2);
            this.setTextureImpl(tex3, 3);
        }
    }

    public void setTexture(PImage[] tex) {
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.setTexture(i, tex);
                ++i;
            }
        } else {
            int i = 0;
            while (i < tex.length) {
                this.setTextureImpl(tex[i], i);
                ++i;
            }
        }
    }

    public void setTexture(int idx, PImage tex) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setTexture(tex);
        }
    }

    public void setTexture(int idx, PImage tex0, PImage tex1) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setTexture(tex0, tex1);
        }
    }

    public void setTexture(int idx, PImage tex0, PImage tex1, PImage tex2) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setTexture(tex0, tex1, tex2);
        }
    }

    public void setTexture(int idx, PImage tex0, PImage tex1, PImage tex2, PImage tex3) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setTexture(tex0, tex1, tex2, tex3);
        }
    }

    public void setTexture(int idx, PImage[] tex) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setTexture(tex);
        }
    }

    protected void setTextureImpl(PImage tex, int unit) {
        if (unit < 0 || PGraphicsOpenGL2.maxTextureUnits <= unit) {
            System.err.println("PShape3D: Wrong texture unit.");
            return;
        }
        if (this.numTexBuffers <= unit) {
            this.root.addTexBuffers(unit - this.numTexBuffers + 1);
        }
        if (tex == null) {
            throw new RuntimeException("PShape3D: trying to set null texture.");
        }
        if (this.texCoordSet[unit] && this.isTexturable()) {
            this.loadTexcoords(unit);
            this.textures[unit] = tex;
            this.updateTexcoords();
        } else {
            this.textures[unit] = tex;
        }
    }

    public PImage[] getTexture() {
        if (this.family == 0) {
            this.init();
            return this.getTexture(0);
        }
        return this.textures;
    }

    public PImage[] getTexture(int idx) {
        if (idx >= 0 && idx < this.childCount) {
            return ((PShape3D)this.children[idx]).getTexture();
        }
        return null;
    }

    public float getStrokeWeight() {
        if (this.family == 0) {
            this.init();
            return this.getStrokeWeight(0);
        }
        return this.strokeWeight;
    }

    public float getStrokeWeight(int idx) {
        if (idx >= 0 && idx < this.childCount) {
            return ((PShape3D)this.children[idx]).getStrokeWeight();
        }
        return 0.0f;
    }

    public void setStrokeWeight(float sw) {
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.setStrokeWeight(i, sw);
                ++i;
            }
        } else {
            this.strokeWeight = sw;
        }
    }

    public void setStrokeWeight(int idx, float sw) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setStrokeWeight(sw);
        }
    }

    public float getMaxSpriteSize() {
        if (this.family == 0) {
            this.init();
            return this.getMaxSpriteSize(0);
        }
        return this.maxSpriteSize;
    }

    public float getMaxSpriteSize(int idx) {
        if (idx >= 0 && idx < this.childCount) {
            return ((PShape3D)this.children[idx]).getMaxSpriteSize();
        }
        return 0.0f;
    }

    public void setMaxSpriteSize(float s) {
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.setMaxSpriteSize(i, s);
                ++i;
            }
        } else {
            this.setMaxSpriteSizeImpl(s);
        }
    }

    public void setMaxSpriteSize(int idx, float s) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setMaxSpriteSize(s);
        }
    }

    protected void setMaxSpriteSizeImpl(float s) {
        this.maxSpriteSize = PApplet.min((float)s, (float)PGraphicsOpenGL2.maxPointSize);
    }

    public void setSpriteSize(float s) {
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.setSpriteSize(i, s);
                ++i;
            }
        } else {
            this.setSpriteSizeImpl(s);
        }
    }

    public void setSpriteSize(float s, float d, int mode) {
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.setSpriteSize(i, s, d, mode);
                ++i;
            }
        } else {
            this.setSpriteSizeImpl(s, d, mode);
        }
    }

    public void setSpriteSize(int idx, float s) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setSpriteSize(s);
        }
    }

    public void setSpriteSize(int idx, float s, float d, int mode) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setSpriteSize(s, d, mode);
        }
    }

    protected void setSpriteSizeImpl(float s, float d, int mode) {
        float s0 = this.maxSpriteSize;
        if (mode == 0) {
            this.spriteDistAtt[1] = (s0 - s) / (d * s);
            this.spriteDistAtt[2] = 0.0f;
        } else if (mode == 1) {
            this.spriteDistAtt[1] = 0.0f;
            this.spriteDistAtt[2] = (s0 - s) / (d * d * s);
        } else {
            PGraphics.showWarning((String)"Invalid point sprite mode");
        }
    }

    protected void setSpriteSizeImpl(float s) {
        this.setMaxSpriteSizeImpl(s);
        this.spriteDistAtt[1] = 0.0f;
        this.spriteDistAtt[2] = 0.0f;
    }

    public void setColor(int c) {
        this.setColor(PShape3D.rgba(c));
    }

    public void setColor(float r, float g, float b, float a) {
        this.setColor(new float[]{r, g, b, a});
    }

    public void setColor(float[] c) {
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.setColor(i, c);
                ++i;
            }
        } else {
            this.setColorImpl(c);
        }
    }

    public void setColor(int idx, int c) {
        this.setColor(idx, PShape3D.rgba(c));
    }

    public void setColor(int idx, float r, float g, float b, float a) {
        this.setColor(idx, new float[]{r, g, b, a});
    }

    public void setColor(int idx, float[] c) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setColor(c);
        }
    }

    protected void setColorImpl(float[] c) {
        PShape3D p = this.root;
        p.loadColors();
        int i = this.firstVertex;
        while (i <= this.lastVertex) {
            p.set(i, c);
            ++i;
        }
        p.updateColors();
    }

    public void setNormal(float nx, float ny, float nz) {
        this.setNormal(new float[]{nx, ny, nz});
    }

    public void setNormal(float[] n) {
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.setNormal(i, n);
                ++i;
            }
        } else {
            this.setNormalImpl(n);
        }
    }

    public void setNormal(int idx, float nx, float ny, float nz) {
        this.setNormal(idx, new float[]{nx, ny, nz});
    }

    public void setNormal(int idx, float[] n) {
        if (idx >= 0 && idx < this.childCount) {
            ((PShape3D)this.children[idx]).setNormal(n);
        }
    }

    protected void setNormalImpl(float[] n) {
        PShape3D p = this.root;
        p.loadNormals();
        int i = this.firstVertex;
        while (i <= this.lastVertex) {
            p.set(i, n);
            ++i;
        }
        p.updateNormals();
    }

    protected void optimizeChildren(ArrayList<PShape3D> childList) {
        PShape3D child1;
        PShape3D child0 = childList.get(0);
        int i = 1;
        while (i < childList.size()) {
            child1 = childList.get(i);
            if (child0.equalTo(child1, false)) {
                child0.lastVertex = child1.lastVertex;
                int n = child0.firstVertex;
                while (n <= child0.lastVertex) {
                    this.vertexChild[n] = child0;
                    ++n;
                }
                child1.lastVertex = -1;
                child1.firstVertex = -1;
            } else {
                child0 = child1;
            }
            ++i;
        }
        i = childList.size() - 1;
        while (i >= 0) {
            if (childList.get((int)i).lastVertex == -1) {
                childList.remove(i);
            }
            --i;
        }
        i = 1;
        while (i < childList.size()) {
            child1 = childList.get(i);
            int j = i - 1;
            while (j >= 0) {
                child0 = childList.get(j);
                if (child1.name.equals(child0.name)) {
                    int pos = child0.name.indexOf(58);
                    if (-1 < pos) {
                        String nstr = child0.name.substring(pos + 1);
                        int n = 1;
                        try {
                            n = Integer.parseInt(nstr);
                        }
                        catch (NumberFormatException e) {
                            child0.name = String.valueOf(child0.name) + ":1";
                        }
                        child1.name = String.valueOf(child1.name) + ":" + (n + 1);
                    } else {
                        child0.name = String.valueOf(child0.name) + ":1";
                        child1.name = String.valueOf(child1.name) + ":2";
                    }
                }
                --j;
            }
            ++i;
        }
    }

    protected boolean equalTo(PShape3D child, boolean ignoreNames) {
        boolean res;
        boolean bl = res = this.family == child.family && this.glMode == child.glMode && this.strokeWeight == child.strokeWeight && (ignoreNames || this.name.equals(child.name));
        if (!res) {
            return false;
        }
        int i = 0;
        while (i < this.textures.length) {
            if (this.textures[i] != child.textures[i]) {
                res = false;
            }
            ++i;
        }
        return res;
    }

    public void resetMatrix() {
        this.checkMatrix(3);
        this.matrix.reset();
    }

    public void translate(float tx, float ty) {
        this.checkMatrix(3);
        this.matrix.translate(tx, ty, 0.0f);
    }

    public void rotate(float angle) {
        this.checkMatrix(3);
        this.matrix.rotate(angle);
    }

    public void scale(float s) {
        this.checkMatrix(3);
        this.matrix.scale(s);
    }

    public void scale(float x, float y) {
        this.checkMatrix(3);
        this.matrix.scale(x, y);
    }

    public void centerAt(float cx, float cy, float cz) {
        float dx = cx - 0.5f * (this.xmin + this.xmax);
        float dy = cy - 0.5f * (this.ymin + this.ymax);
        float dz = cz - 0.5f * (this.zmin + this.zmax);
        this.loadVertices();
        int i = 0;
        while (i < this.vertexCount) {
            int n = 3 * i + 0;
            this.vertices[n] = this.vertices[n] + dx;
            int n2 = 3 * i + 1;
            this.vertices[n2] = this.vertices[n2] + dy;
            int n3 = 3 * i + 2;
            this.vertices[n3] = this.vertices[n3] + dz;
            ++i;
        }
        this.updateVertices();
    }

    public void setVertices(ArrayList<PVector> vertexList) {
        this.setVertices(vertexList, 0);
    }

    public void setVertices(ArrayList<PVector> vertexList, int offset) {
        this.loadVertices();
        int i = this.firstVertex;
        while (i <= this.lastVertex) {
            PVector v = vertexList.get(i - this.firstVertex + offset);
            this.set(i, v.x, v.y, v.z);
            ++i;
        }
        this.updateVertices();
    }

    public void setColors(ArrayList<float[]> colorList) {
        this.setColors(colorList, 0);
    }

    public void setColors(ArrayList<float[]> colorList, int offset) {
        this.loadColors();
        int i = this.firstVertex;
        while (i <= this.lastVertex) {
            float[] c = colorList.get(i - this.firstVertex + offset);
            this.set(i, c);
            ++i;
        }
        this.updateColors();
    }

    public void setNormals(ArrayList<PVector> normalList) {
        this.setNormals(normalList, 0);
    }

    public void setNormals(ArrayList<PVector> normalList, int offset) {
        this.loadNormals();
        int i = this.firstVertex;
        while (i <= this.lastVertex) {
            PVector n = normalList.get(i - this.firstVertex + offset);
            this.set(i, n.x, n.y, n.z);
            ++i;
        }
        this.updateNormals();
    }

    public void setTexcoords(ArrayList<PVector> tcoordList) {
        this.setTexcoords(tcoordList, 0);
    }

    public void setTexcoords(ArrayList<PVector> tcoordList, int offset) {
        this.setTexcoords(0, tcoordList, offset);
    }

    public void setTexcoords(int unit, ArrayList<PVector> tcoordList) {
        this.setTexcoords(unit, tcoordList, 0);
    }

    public void setTexcoords(int unit, ArrayList<PVector> tcoordList, int offset) {
        this.loadTexcoords(unit);
        int i = this.firstVertex;
        while (i <= this.lastVertex) {
            PVector tc = tcoordList.get(i - this.firstVertex + offset);
            this.set(i, tc.x, tc.y);
            ++i;
        }
        this.updateTexcoords();
    }

    public void setChildren(ArrayList<PShape3D> who) {
        if (this.family != 0) {
            return;
        }
        this.childCount = 0;
        int i = 0;
        while (i < who.size()) {
            PShape child = who.get(i);
            this.addChild(child);
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mergeChildren() {
        if (this.family != 0) {
            return;
        }
        if (this.children == null) {
            if (this.root != this) return;
            this.addDefaultChild();
            return;
        } else {
            int n;
            PShape3D child1;
            int ndiff = 1;
            int i0 = 0;
            PShape3D child0 = null;
            int i = 0;
            while (i < this.childCount) {
                child0 = (PShape3D)this.children[i];
                if (child0.family != 0) {
                    i0 = i + 1;
                    break;
                }
                child0.mergeChildren();
                ++i;
            }
            if (i0 == 0) {
                return;
            }
            i = i0;
            while (i < this.childCount) {
                child1 = (PShape3D)this.children[i];
                if (child1.family == 0) {
                    child1.mergeChildren();
                } else if (child0.equalTo(child1, true)) {
                    child0.lastVertex = child1.lastVertex;
                    n = child0.firstVertex;
                    while (n <= child0.lastVertex) {
                        this.vertexChild[n] = child0;
                        ++n;
                    }
                    child1.lastVertex = -1;
                    child1.firstVertex = -1;
                } else {
                    child0 = child1;
                    ++ndiff;
                }
                ++i;
            }
            PShape[] temp = new PShape[ndiff];
            n = 0;
            int i2 = 0;
            while (i2 < this.childCount) {
                child1 = (PShape3D)this.children[i2];
                if (child1.family == 3 && child1.lastVertex == -1 && child1.getName() != null && this.nameTable != null) {
                    this.nameTable.remove(child1.getName());
                } else {
                    temp[n++] = child1;
                }
                ++i2;
            }
            this.children = temp;
            this.childCount = ndiff;
        }
    }

    public void translateVertices(float tx, float ty) {
        this.translateVertices(tx, ty, 0.0f);
    }

    public void translateVertices(float tx, float ty, float tz) {
        this.init();
        this.loadVertices();
        int i = this.firstVertex;
        while (i <= this.lastVertex) {
            int n = 3 * i + 0;
            this.vertices[n] = this.vertices[n] + tx;
            int n2 = 3 * i + 1;
            this.vertices[n2] = this.vertices[n2] + -ty;
            int n3 = 3 * i + 2;
            this.vertices[n3] = this.vertices[n3] + tz;
            ++i;
        }
        this.updateVertices();
    }

    public void rotateVerticesX(float angle) {
        this.rotateVertices(angle, 1.0f, 0.0f, 0.0f);
    }

    public void rotateVerticesY(float angle) {
        this.rotateVertices(angle, 0.0f, 1.0f, 0.0f);
    }

    public void rotateVerticesZ(float angle) {
        this.rotateVertices(angle, 0.0f, 0.0f, 1.0f);
    }

    public void rotateVertices(float angle) {
        this.rotateVertices(angle, 0.0f, 0.0f, 1.0f);
    }

    public void rotateVertices(float angle, float v0, float v1, float v2) {
        float z;
        float y;
        float x;
        this.init();
        float norm2 = v0 * v0 + v1 * v1 + v2 * v2;
        if (Math.abs(norm2 - 1.0f) > 1.0E-4f) {
            float norm = PApplet.sqrt((float)norm2);
            v0 /= norm;
            v1 /= norm;
            v2 /= norm;
        }
        float cx = 0.5f * (this.xmin + this.xmax);
        float cy = 0.5f * (this.ymin + this.ymax);
        float cz = 0.5f * (this.zmin + this.zmax);
        float c = PApplet.cos((float)angle);
        float s = PApplet.sin((float)angle);
        float t = 1.0f - c;
        float[] m = new float[]{t * v0 * v0 + c, t * v0 * v1 - s * v2, t * v0 * v2 + s * v1, t * v0 * v1 + s * v2, t * v1 * v1 + c, t * v1 * v2 - s * v0, t * v0 * v2 - s * v1, t * v1 * v2 + s * v0, t * v2 * v2 + c};
        this.loadVertices();
        int i = this.firstVertex;
        while (i <= this.lastVertex) {
            x = this.vertices[3 * i + 0] - cx;
            y = this.vertices[3 * i + 1] - cy;
            z = this.vertices[3 * i + 2] - cz;
            this.vertices[3 * i + 0] = m[0] * x + m[1] * y + m[2] * z + cx;
            this.vertices[3 * i + 1] = m[3] * x + m[4] * y + m[5] * z + cy;
            this.vertices[3 * i + 2] = m[6] * x + m[7] * y + m[8] * z + cz;
            ++i;
        }
        this.updateVertices();
        this.centerAt(cx, cy, cz);
        this.loadNormals();
        i = this.firstVertex;
        while (i <= this.lastVertex) {
            x = this.normals[3 * i + 0];
            y = this.normals[3 * i + 1];
            z = this.normals[3 * i + 2];
            this.normals[3 * i + 0] = m[0] * x + m[1] * y + m[2] * z + cx;
            this.normals[3 * i + 1] = m[3] * x + m[4] * y + m[5] * z + cy;
            this.normals[3 * i + 2] = m[6] * x + m[7] * y + m[8] * z + cz;
            ++i;
        }
        this.updateNormals();
    }

    public void scaleVertices(float s) {
        this.scaleVertices(s, s, s);
    }

    public void scaleVertices(float sx, float sy) {
        this.scaleVertices(sx, sy, 1.0f);
    }

    public void scaleVertices(float x, float y, float z) {
        this.init();
        this.loadVertices();
        int i = this.firstVertex;
        while (i <= this.lastVertex) {
            int n = 3 * i + 0;
            this.vertices[n] = this.vertices[n] * x;
            int n2 = 3 * i + 1;
            this.vertices[n2] = this.vertices[n2] * y;
            int n3 = 3 * i + 2;
            this.vertices[n3] = this.vertices[n3] * z;
            ++i;
        }
        this.updateVertices();
    }

    public Parameters getParameters() {
        if (this.root != this) {
            return null;
        }
        Parameters res = new Parameters();
        res.drawMode = this.getDrawModeImpl();
        if (this.glUsage == 35044) {
            res.updateMode = 0;
        } else if (this.glUsage == 35048) {
            res.updateMode = 1;
        } else if (this.glUsage == 35042) {
            res.updateMode = 2;
        }
        return res;
    }

    protected void setParameters(Parameters params) {
        if (this.root != this) {
            return;
        }
        this.setDrawModeImpl(params.drawMode);
        if (params.updateMode == 0) {
            this.glUsage = 35044;
        } else if (params.updateMode == 1) {
            this.glUsage = 35048;
        } else if (params.updateMode == 2) {
            this.glUsage = 35042;
        } else {
            throw new RuntimeException("PShape3D: Unknown update mode");
        }
    }

    public void init() {
        if (this.root != this) {
            return;
        }
        if (this.readFromOBJ) {
            this.recordOBJ();
            this.centerAt(0.0f, 0.0f, 0.0f);
        }
        if (this.children == null) {
            this.addDefaultChild();
        }
    }

    protected void initShape(int numVert) {
        this.initShape(numVert, new Parameters());
    }

    protected void initShape(int numVert, Parameters params) {
        this.gl = this.pgl.gl2f;
        if (this.gl == null) {
            throw new RuntimeException("PShape3D: OpenGL ES 1.1 required");
        }
        if (!PGraphicsOpenGL2.vboSupported) {
            throw new RuntimeException("PShape3D: Vertex Buffer Objects are not available");
        }
        this.setParameters(params);
        this.allocateShape(numVert);
        this.updateElement = -1;
        this.resetBounds();
    }

    protected void initShapeOBJ(String filename, Parameters params) {
        this.gl = this.pgl.gl2f;
        if (this.gl == null) {
            throw new RuntimeException("PShape3D: OpenGL ES 1.1 required");
        }
        if (!PGraphicsOpenGL2.vboSupported) {
            throw new RuntimeException("PShape3D: Vertex Buffer Objects are not available");
        }
        this.readFromOBJ = true;
        this.objVertices = new ArrayList();
        this.objNormal = new ArrayList();
        this.objTexCoords = new ArrayList();
        this.objFaces = new ArrayList();
        this.objMaterials = new ArrayList();
        BufferedReader reader = this.getBufferedReader(filename);
        if (reader == null) {
            throw new RuntimeException("PShape3D: Cannot read source file");
        }
        if (params == null) {
            params = PShape3D.newParameters(9, 0);
        } else {
            params.drawMode = 9;
        }
        this.setParameters(params);
        this.parseOBJ(reader, this.objVertices, this.objNormal, this.objTexCoords, this.objFaces, this.objMaterials);
        this.vertexCount = this.objVertices.size();
    }

    protected void allocateShape(int numVert) {
        this.vertexCount = numVert;
        this.numTexBuffers = 1;
        this.firstVertex = 0;
        this.lastVertex = numVert - 1;
        this.initVertexData();
        this.createVertexBuffer();
        this.initColorData();
        this.createColorBuffer();
        this.initNormalData();
        this.createNormalBuffer();
        this.initTexCoordData();
        this.createTexCoordBuffer();
        this.initChildrenData();
    }

    protected void initChildrenData() {
        this.children = null;
        this.vertexChild = new PShape3D[this.vertexCount];
    }

    protected void initVertexData() {
        ByteBuffer vbb = ByteBuffer.allocateDirect(this.vertexCount * 3 * 4);
        vbb.order(ByteOrder.nativeOrder());
        this.vertexBuffer = vbb.asFloatBuffer();
        this.vertices = new float[this.vertexCount * 3];
        this.vertexBuffer.put(this.vertices);
        this.vertexBuffer.flip();
    }

    protected void createVertexBuffer() {
        this.deleteVertexBuffer();
        this.glVertexBufferID = this.pgl.createGLResource(1);
        this.gl.glBindBuffer(34962, this.glVertexBufferID);
        int bufferSize = this.vertexBuffer.capacity() * 4;
        this.gl.glBufferData(34962, (long)bufferSize, (Buffer)this.vertexBuffer, this.glUsage);
        this.gl.glBindBuffer(34962, 0);
    }

    protected void initColorData() {
        ByteBuffer vbb = ByteBuffer.allocateDirect(this.vertexCount * 4 * 4);
        vbb.order(ByteOrder.nativeOrder());
        this.colorBuffer = vbb.asFloatBuffer();
        this.colors = new float[this.vertexCount * 4];
        Arrays.fill(this.colors, 1.0f);
        this.colorBuffer.put(this.colors);
        this.colorBuffer.flip();
    }

    protected void createColorBuffer() {
        this.deleteColorBuffer();
        this.glColorBufferID = this.pgl.createGLResource(1);
        this.gl.glBindBuffer(34962, this.glColorBufferID);
        int bufferSize = this.colorBuffer.capacity() * 4;
        this.gl.glBufferData(34962, (long)bufferSize, (Buffer)this.colorBuffer, this.glUsage);
        this.gl.glBindBuffer(34962, 0);
    }

    protected void initNormalData() {
        ByteBuffer vbb = ByteBuffer.allocateDirect(this.vertexCount * 3 * 4);
        vbb.order(ByteOrder.nativeOrder());
        this.normalBuffer = vbb.asFloatBuffer();
        this.normals = new float[this.vertexCount * 3];
        this.normalBuffer.put(this.normals);
        this.normalBuffer.flip();
    }

    protected void createNormalBuffer() {
        this.deleteNormalBuffer();
        this.glNormalBufferID = this.pgl.createGLResource(1);
        this.gl.glBindBuffer(34962, this.glNormalBufferID);
        int bufferSize = this.normalBuffer.capacity() * 4;
        this.gl.glBufferData(34962, (long)bufferSize, (Buffer)this.normalBuffer, this.glUsage);
        this.gl.glBindBuffer(34962, 0);
    }

    protected void initTexCoordData() {
        ByteBuffer vbb = ByteBuffer.allocateDirect(this.vertexCount * 2 * 4);
        vbb.order(ByteOrder.nativeOrder());
        this.texCoordBuffer = vbb.asFloatBuffer();
        this.allTexcoords = new float[1][this.vertexCount * 2];
        this.texcoords = this.allTexcoords[0];
        this.convTexcoords = new float[this.vertexCount * 2];
        this.texCoordBuffer.put(this.convTexcoords);
        this.texCoordBuffer.flip();
        this.texCoordSet = new boolean[2];
    }

    protected void createTexCoordBuffer() {
        if (this.glTexCoordBufferID == null) {
            this.glTexCoordBufferID = new int[2];
            Arrays.fill(this.glTexCoordBufferID, 0);
        } else {
            this.deleteTexCoordBuffer();
        }
        this.glTexCoordBufferID[0] = this.pgl.createGLResource(1);
        this.gl.glBindBuffer(34962, this.glTexCoordBufferID[0]);
        int bufferSize = this.texCoordBuffer.capacity() * 4;
        this.gl.glBufferData(34962, (long)bufferSize, (Buffer)this.texCoordBuffer, this.glUsage);
        this.gl.glBindBuffer(34962, 0);
    }

    protected void addTexBuffers(int more) {
        int i = 0;
        while (i < more) {
            int t = this.numTexBuffers + i;
            this.deleteTexCoordBuffer(t);
            this.glTexCoordBufferID[t] = this.pgl.createGLResource(1);
            this.gl.glBindBuffer(34962, this.glTexCoordBufferID[t]);
            int bufferSize = this.texCoordBuffer.capacity() * 4;
            this.gl.glBufferData(34962, (long)bufferSize, (Buffer)this.texCoordBuffer, this.glUsage);
            this.gl.glBindBuffer(34962, 0);
            ++i;
        }
        float[][] temp = new float[this.numTexBuffers + more][this.vertexCount * 2];
        int i2 = 0;
        while (i2 < this.numTexBuffers) {
            PApplet.arrayCopy((Object)this.allTexcoords[i2], (Object)temp[i2]);
            ++i2;
        }
        this.allTexcoords = temp;
        this.texcoords = this.allTexcoords[0];
        this.numTexBuffers += more;
        this.updateTexBuffers();
    }

    protected void updateTexBuffers() {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                ((PShape3D)this.children[i]).updateTexBuffers();
                ++i;
            }
        } else {
            this.numTexBuffers = this.root.numTexBuffers;
            this.allTexcoords = this.root.allTexcoords;
            this.texcoords = this.allTexcoords[0];
        }
    }

    protected void deleteVertexBuffer() {
        if (this.glVertexBufferID != 0) {
            this.pgl.deleteGLResource(this.glVertexBufferID, 1);
            this.glVertexBufferID = 0;
        }
    }

    protected void deleteColorBuffer() {
        if (this.glColorBufferID != 0) {
            this.pgl.deleteGLResource(this.glColorBufferID, 1);
            this.glColorBufferID = 0;
        }
    }

    protected void deleteNormalBuffer() {
        if (this.glNormalBufferID != 0) {
            this.pgl.deleteGLResource(this.glNormalBufferID, 1);
            this.glNormalBufferID = 0;
        }
    }

    protected void deleteTexCoordBuffer() {
        int i = 0;
        while (i < this.numTexBuffers) {
            this.deleteTexCoordBuffer(i);
            ++i;
        }
    }

    protected void deleteTexCoordBuffer(int idx) {
        if (this.glTexCoordBufferID[idx] != 0) {
            this.pgl.deleteGLResource(this.glTexCoordBufferID[idx], 1);
            this.glTexCoordBufferID[idx] = 0;
        }
    }

    public float[] getVertex(int index) {
        PGraphics.showMethodWarning((String)"getVertex");
        return null;
    }

    public float getVertexX(int index) {
        PGraphics.showMethodWarning((String)"getVertexX");
        return 0.0f;
    }

    public float getVertexY(int index) {
        PGraphics.showMethodWarning((String)"getVertexY");
        return 0.0f;
    }

    public float getVertexZ(int index) {
        PGraphics.showMethodWarning((String)"getVertexZ");
        return 0.0f;
    }

    public int[] getVertexCodes() {
        PGraphics.showMethodWarning((String)"getVertexCodes");
        return null;
    }

    public int getVertexCodeCount() {
        PGraphics.showMethodWarning((String)"getVertexCodeCount");
        return 0;
    }

    public int getVertexCode(int index) {
        PGraphics.showMethodWarning((String)"getVertexCode");
        return 0;
    }

    public void disableStyle() {
        this.style = false;
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.children[i].disableStyle();
                ++i;
            }
        }
    }

    public void enableStyle() {
        this.style = true;
        if (this.family == 0) {
            this.init();
            int i = 0;
            while (i < this.childCount) {
                this.children[i].enableStyle();
                ++i;
            }
        }
    }

    protected void styles(PGraphics g) {
    }

    public boolean is3D() {
        return true;
    }

    public void draw() {
        this.draw(this.pgl);
    }

    public void draw(PGraphics g) {
        if (this.visible) {
            if (this.matrix != null) {
                g.pushMatrix();
                g.applyMatrix(this.matrix);
            }
            if (this.family == 0) {
                this.init();
                int i = 0;
                while (i < this.childCount) {
                    ((PShape3D)this.children[i]).draw(g);
                    ++i;
                }
            } else {
                this.drawGeometry(g);
            }
            if (this.matrix != null) {
                g.popMatrix();
            }
        }
    }

    protected void pre(PGraphics g) {
        if (this.matrix != null) {
            g.pushMatrix();
            g.applyMatrix(this.matrix);
        }
    }

    public void post(PGraphics g) {
        if (this.matrix != null) {
            g.popMatrix();
        }
    }

    public void drawImpl(PGraphics g) {
        if (this.family == 0) {
            this.drawGroup(g);
        } else {
            this.drawGeometry(g);
        }
    }

    protected void drawGroup(PGraphics g) {
        this.init();
        int i = 0;
        while (i < this.childCount) {
            this.children[i].draw(g);
            ++i;
        }
    }

    protected void drawGeometry(PGraphics g) {
        PTexture tex;
        int t;
        float pointSize;
        if (0.0f < this.strokeWeight && this.style) {
            this.gl.glLineWidth(this.strokeWeight);
            pointSize = PApplet.min((float)this.strokeWeight, (float)PGraphicsOpenGL2.maxPointSize);
        } else {
            this.gl.glLineWidth(g.strokeWeight);
            pointSize = PApplet.min((float)g.strokeWeight, (float)PGraphicsOpenGL2.maxPointSize);
        }
        if (!this.pointSprites) {
            this.gl.glPointSize(pointSize);
        }
        this.gl.glEnableClientState(32885);
        this.gl.glBindBuffer(34962, this.glNormalBufferID);
        this.gl.glNormalPointer(5126, 0, 0L);
        if (this.style) {
            this.gl.glEnableClientState(32886);
            this.gl.glBindBuffer(34962, this.glColorBufferID);
            this.gl.glColorPointer(4, 5126, 0, 0L);
        }
        this.gl.glEnableClientState(32884);
        this.gl.glBindBuffer(34962, this.glVertexBufferID);
        this.gl.glVertexPointer(3, 5126, 0, 0L);
        int numTextures = 0;
        if (this.style) {
            t = 0;
            while (t < this.textures.length) {
                if (this.textures[t] == null) break;
                tex = (PTexture)this.textures[t].getCache((PGraphics)this.pgl);
                tex = this.pgl.getTexture(this.textures[t]);
                if (tex == null) break;
                this.gl.glEnable(tex.getGLTarget());
                this.gl.glActiveTexture(33984 + t);
                this.gl.glBindTexture(tex.getGLTarget(), tex.getGLID());
                this.renderTextures[numTextures] = tex;
                ++numTextures;
                ++t;
            }
        }
        if (numTextures > 0) {
            if (this.pointSprites) {
                this.gl.glPointParameterf(33064, 0.6f * this.maxSpriteSize);
                this.gl.glPointParameterf(33062, 1.0f);
                this.gl.glPointParameterf(33063, this.maxSpriteSize);
                this.gl.glPointSize(this.maxSpriteSize);
                this.gl.glPointParameterfv(33065, this.spriteDistAtt, 0);
                this.gl.glTexEnvf(34913, 34914, 1.0f);
                this.gl.glEnable(34913);
            } else {
                this.gl.glEnableClientState(32888);
                t = 0;
                while (t < numTextures) {
                    this.gl.glClientActiveTexture(33984 + t);
                    this.gl.glBindBuffer(34962, this.glTexCoordBufferID[t]);
                    this.gl.glTexCoordPointer(2, 5126, 0, 0L);
                    ++t;
                }
                if (1 < numTextures) {
                    this.pgl.setMultitextureBlend(this.renderTextures, numTextures);
                }
            }
        }
        if (!this.style) {
            if (numTextures > 0) {
                if (g.tint) {
                    this.pgl.setTintColor();
                } else {
                    this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                }
            } else {
                this.pgl.setFillColor();
            }
        }
        this.gl.glDrawArrays(this.glMode, this.firstVertex, this.lastVertex - this.firstVertex + 1);
        if (numTextures > 0) {
            if (1 < numTextures) {
                this.pgl.clearMultitextureBlend(numTextures);
            }
            if (this.pointSprites) {
                this.gl.glDisable(34913);
            } else {
                this.gl.glDisableClientState(32888);
            }
            t = 0;
            while (t < numTextures) {
                tex = this.renderTextures[t];
                this.gl.glActiveTexture(33984 + t);
                this.gl.glBindTexture(tex.getGLTarget(), 0);
                ++t;
            }
            t = 0;
            while (t < numTextures) {
                tex = this.renderTextures[t];
                this.gl.glDisable(tex.getGLTarget());
                ++t;
            }
        }
        this.gl.glBindBuffer(34962, 0);
        this.gl.glDisableClientState(32884);
        this.gl.glDisableClientState(32886);
        this.gl.glDisableClientState(32885);
    }

    public static Parameters newParameters() {
        return new Parameters();
    }

    public static Parameters newParameters(int drawMode) {
        return new Parameters(drawMode);
    }

    public static Parameters newParameters(int drawMode, int updateMode) {
        return new Parameters(drawMode, updateMode);
    }

    protected BufferedReader getBufferedReader(String filename) {
        BufferedReader retval = this.papplet.createReader(filename);
        if (retval != null) {
            return retval;
        }
        PApplet.println((String)("Could not find this file " + filename));
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseOBJ(BufferedReader reader, ArrayList<PVector> vertices, ArrayList<PVector> normals, ArrayList<PVector> textures, ArrayList<OBJFace> faces, ArrayList<OBJMaterial> materials) {
        Hashtable<String, Integer> mtlTable = new Hashtable<String, Integer>();
        int mtlIdxCur = -1;
        try {
            boolean readvt = false;
            boolean readvn = false;
            boolean readv = false;
            String gname = "object";
            block2: while (true) {
                PVector tempv;
                String[] elements;
                String line;
                if ((line = reader.readLine()) == null) {
                    if (materials.size() != 0) return;
                    OBJMaterial defMtl = new OBJMaterial();
                    materials.add(defMtl);
                    return;
                }
                while (true) {
                    if (!line.contains("\\")) {
                        elements = line.split("\\s+");
                        if (elements.length <= 0) continue block2;
                        if (!elements[0].equals("v")) break;
                        tempv = new PVector(Float.valueOf(elements[1]).floatValue(), Float.valueOf(elements[2]).floatValue(), Float.valueOf(elements[3]).floatValue());
                        vertices.add(tempv);
                        readv = true;
                        continue block2;
                    }
                    line = line.split("\\\\")[0];
                    String s = reader.readLine();
                    if (s == null) continue;
                    line = String.valueOf(line) + s;
                }
                if (elements[0].equals("vn")) {
                    PVector tempn = new PVector(Float.valueOf(elements[1]).floatValue(), Float.valueOf(elements[2]).floatValue(), Float.valueOf(elements[3]).floatValue());
                    normals.add(tempn);
                    readvn = true;
                    continue;
                }
                if (elements[0].equals("vt")) {
                    tempv = new PVector(Float.valueOf(elements[1]).floatValue(), Float.valueOf(elements[2]).floatValue());
                    textures.add(tempv);
                    readvt = true;
                    continue;
                }
                if (elements[0].equals("o")) continue;
                if (elements[0].equals("mtllib")) {
                    if (elements[1] == null) continue;
                    this.parseMTL(this.getBufferedReader(elements[1]), materials, mtlTable);
                    continue;
                }
                if (elements[0].equals("g")) {
                    gname = elements[1];
                    continue;
                }
                if (elements[0].equals("usemtl")) {
                    if (elements[1] == null) continue;
                    String mtlname = elements[1];
                    if (mtlTable.containsKey(mtlname)) {
                        Integer tempInt = mtlTable.get(mtlname);
                        mtlIdxCur = tempInt;
                        continue;
                    }
                    mtlIdxCur = -1;
                    continue;
                }
                if (!elements[0].equals("f")) continue;
                OBJFace face = new OBJFace();
                face.matIdx = mtlIdxCur;
                face.name = gname;
                int i = 1;
                while (true) {
                    block26: {
                        String seg;
                        block24: {
                            String[] forder;
                            block27: {
                                block25: {
                                    if (i >= elements.length) {
                                        faces.add(face);
                                        continue block2;
                                    }
                                    seg = elements[i];
                                    if (seg.indexOf("/") <= 0) break block24;
                                    forder = seg.split("/");
                                    if (forder.length <= 2) break block25;
                                    if (forder[0].length() > 0 && readv) {
                                        face.vertIdx.add(Integer.valueOf(forder[0]));
                                    }
                                    if (forder[1].length() > 0 && readvt) {
                                        face.texIdx.add(Integer.valueOf(forder[1]));
                                    }
                                    if (forder[2].length() > 0 && readvn) {
                                        face.normIdx.add(Integer.valueOf(forder[2]));
                                    }
                                    break block26;
                                }
                                if (forder.length <= 1) break block27;
                                if (forder[0].length() > 0 && readv) {
                                    face.vertIdx.add(Integer.valueOf(forder[0]));
                                }
                                if (forder[1].length() > 0) {
                                    if (readvt) {
                                        face.texIdx.add(Integer.valueOf(forder[1]));
                                        break block26;
                                    } else if (readvn) {
                                        face.normIdx.add(Integer.valueOf(forder[1]));
                                    }
                                }
                                break block26;
                            }
                            if (forder.length > 0 && forder[0].length() > 0 && readv) {
                                face.vertIdx.add(Integer.valueOf(forder[0]));
                            }
                            break block26;
                        }
                        if (seg.length() > 0 && readv) {
                            face.vertIdx.add(Integer.valueOf(seg));
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void parseMTL(BufferedReader reader, ArrayList<OBJMaterial> materials, Hashtable<String, Integer> materialsHash) {
        try {
            String line;
            OBJMaterial currentMtl = null;
            while ((line = reader.readLine()) != null) {
                String[] elements = (line = line.trim()).split("\\s+");
                if (elements.length <= 0) continue;
                if (elements[0].equals("newmtl")) {
                    String mtlname = elements[1];
                    currentMtl = new OBJMaterial(mtlname);
                    materialsHash.put(mtlname, new Integer(materials.size()));
                    materials.add(currentMtl);
                    continue;
                }
                if (elements[0].equals("map_Kd") && elements.length > 1) {
                    String texname = elements[1];
                    currentMtl.kdMap = this.papplet.loadImage(texname);
                    continue;
                }
                if (elements[0].equals("Ka") && elements.length > 3) {
                    currentMtl.ka.x = Float.valueOf(elements[1]).floatValue();
                    currentMtl.ka.y = Float.valueOf(elements[2]).floatValue();
                    currentMtl.ka.z = Float.valueOf(elements[3]).floatValue();
                    continue;
                }
                if (elements[0].equals("Kd") && elements.length > 3) {
                    currentMtl.kd.x = Float.valueOf(elements[1]).floatValue();
                    currentMtl.kd.y = Float.valueOf(elements[2]).floatValue();
                    currentMtl.kd.z = Float.valueOf(elements[3]).floatValue();
                    continue;
                }
                if (elements[0].equals("Ks") && elements.length > 3) {
                    currentMtl.ks.x = Float.valueOf(elements[1]).floatValue();
                    currentMtl.ks.y = Float.valueOf(elements[2]).floatValue();
                    currentMtl.ks.z = Float.valueOf(elements[3]).floatValue();
                    continue;
                }
                if ((elements[0].equals("d") || elements[0].equals("Tr")) && elements.length > 1) {
                    currentMtl.d = Float.valueOf(elements[1]).floatValue();
                    continue;
                }
                if (!elements[0].equals("Ns") || elements.length <= 1) continue;
                currentMtl.ns = Float.valueOf(elements[1]).floatValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void recordOBJ() {
        this.recordOBJ(this.objVertices, this.objNormal, this.objTexCoords, this.objFaces, this.objMaterials);
        this.objVertices = null;
        this.objNormal = null;
        this.objTexCoords = null;
        this.objFaces = null;
        this.objMaterials = null;
        this.readFromOBJ = false;
    }

    protected void recordOBJ(ArrayList<PVector> vertices, ArrayList<PVector> normals, ArrayList<PVector> textures, ArrayList<OBJFace> faces, ArrayList<OBJMaterial> materials) {
        int mtlIdxCur = -1;
        OBJMaterial mtl = null;
        this.pgl.saveDrawingState();
        this.pgl.mergeRecShapes = false;
        this.pgl.colorMode = 1;
        this.pgl.stroke = false;
        this.pgl.autoNormal(true);
        this.pgl.textureMode = 1;
        this.pgl.beginShapeRecorderImpl();
        int i = 0;
        while (i < faces.size()) {
            OBJFace face = faces.get(i);
            if (mtlIdxCur != face.matIdx) {
                mtlIdxCur = PApplet.max((int)0, (int)face.matIdx);
                mtl = materials.get(mtlIdxCur);
                this.pgl.specular(mtl.ks.x * 255.0f, mtl.ks.y * 255.0f, mtl.ks.z * 255.0f);
                this.pgl.ambient(mtl.ka.x * 255.0f, mtl.ka.y * 255.0f, mtl.ka.z * 255.0f);
                if (this.pgl.fill) {
                    this.pgl.fill(mtl.kd.x * 255.0f, mtl.kd.y * 255.0f, mtl.kd.z * 255.0f, mtl.d * 255.0f);
                }
                this.pgl.shininess(mtl.ns);
                if (this.pgl.tint && mtl.kdMap != null) {
                    this.pgl.tint(mtl.kd.x * 255.0f, mtl.kd.y * 255.0f, mtl.kd.z * 255.0f, mtl.d * 255.0f);
                }
            }
            if (face.vertIdx.size() == 3) {
                this.pgl.beginShape(9);
            } else if (face.vertIdx.size() == 4) {
                this.pgl.beginShape(16);
            } else {
                this.pgl.beginShape();
            }
            this.pgl.shapeName(face.name);
            int j = 0;
            while (j < face.vertIdx.size()) {
                int normIdx;
                PVector norms = null;
                PVector vert = null;
                int vertIdx = face.vertIdx.get(j) - 1;
                vert = vertices.get(vertIdx);
                if (j < face.normIdx.size() && -1 < (normIdx = face.normIdx.get(j) - 1)) {
                    norms = normals.get(normIdx);
                }
                if (mtl != null && mtl.kdMap != null) {
                    PTexture texMtl;
                    int texIdx;
                    PVector tex = null;
                    if (j < face.texIdx.size() && -1 < (texIdx = face.texIdx.get(j) - 1)) {
                        tex = textures.get(texIdx);
                    }
                    if ((texMtl = (PTexture)mtl.kdMap.getCache((PGraphics)this.pgl)) != null) {
                        texMtl.setFlippedY(true);
                    }
                    this.pgl.texture(mtl.kdMap);
                    if (norms != null) {
                        this.pgl.normal(norms.x, norms.y, norms.z);
                    }
                    if (tex != null) {
                        this.pgl.vertex(vert.x, vert.y, vert.z, tex.x, tex.y);
                    } else {
                        this.pgl.vertex(vert.x, vert.y, vert.z);
                    }
                } else {
                    if (norms != null) {
                        this.pgl.normal(norms.x, norms.y, norms.z);
                    }
                    this.pgl.vertex(vert.x, vert.y, vert.z);
                }
                ++j;
            }
            this.pgl.endShape(2);
            ++i;
        }
        this.allocateShape(this.pgl.recordedVertices.size());
        this.updateElement = -1;
        this.depth = 0.0f;
        this.height = 0.0f;
        this.width = 0.0f;
        this.zmin = 10000.0f;
        this.ymin = 10000.0f;
        this.xmin = 10000.0f;
        this.zmax = -10000.0f;
        this.ymax = -10000.0f;
        this.xmax = -10000.0f;
        this.pgl.endShapeRecorderImpl(this);
        this.pgl.restoreDrawingState();
    }

    protected class OBJFace {
        ArrayList<Integer> vertIdx = new ArrayList();
        ArrayList<Integer> texIdx = new ArrayList();
        ArrayList<Integer> normIdx = new ArrayList();
        int matIdx = -1;
        String name = "";

        OBJFace() {
        }
    }

    protected class OBJMaterial {
        String name;
        PVector ka;
        PVector kd;
        PVector ks;
        float d;
        float ns;
        PImage kdMap;

        OBJMaterial() {
            this("default");
        }

        OBJMaterial(String name) {
            this.name = name;
            this.ka = new PVector(0.5f, 0.5f, 0.5f);
            this.kd = new PVector(0.5f, 0.5f, 0.5f);
            this.ks = new PVector(0.5f, 0.5f, 0.5f);
            this.d = 1.0f;
            this.ns = 0.0f;
            this.kdMap = null;
        }
    }

    public static class Parameters
    extends PParameters {
        public int drawMode;
        public int updateMode;

        public Parameters() {
            this.drawMode = 2;
            this.updateMode = 0;
        }

        public Parameters(int drawMode) {
            this.drawMode = drawMode;
            this.updateMode = 0;
        }

        public Parameters(int drawMode, int updateMode) {
            this.drawMode = drawMode;
            this.updateMode = updateMode;
        }

        public Parameters(Parameters src) {
            this.drawMode = src.drawMode;
            this.updateMode = src.updateMode;
        }
    }
}

