/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractSymmPackMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpLo;

public class LowerSymmPackMatrix
extends AbstractSymmPackMatrix {
    public LowerSymmPackMatrix(int n) {
        super(n, UpLo.Lower);
    }

    public LowerSymmPackMatrix(Matrix A) {
        this(A, true);
    }

    public LowerSymmPackMatrix(Matrix A, boolean deep) {
        super(A, deep, UpLo.Lower);
    }

    public void add(int row, int column, double value) {
        if (column <= row) {
            int n = this.getIndex(row, column);
            this.data[n] = this.data[n] + value;
        }
    }

    public void set(int row, int column, double value) {
        if (column <= row) {
            this.data[this.getIndex((int)row, (int)column)] = value;
        }
    }

    public double get(int row, int column) {
        if (column <= row) {
            return this.data[this.getIndex(row, column)];
        }
        return this.data[this.getIndex(column, row)];
    }

    int getIndex(int row, int column) {
        this.check(row, column);
        return row + (2 * this.n - (column + 1)) * column / 2;
    }

    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() < e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    public LowerSymmPackMatrix copy() {
        return new LowerSymmPackMatrix(this);
    }
}

