/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.AbstractReceiver;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPortEvent;
import ptolemy.actor.IOPortEventListener;
import ptolemy.actor.IORelation;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.Receiver;
import ptolemy.actor.util.Time;
import ptolemy.data.Token;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class IOPort
extends ComponentPort {
    public static final int CONFIGURATION = 512;
    public static final int RECEIVERS = 1024;
    public static final int REMOTERECEIVERS = 2048;
    protected boolean _hasPortEventListeners = false;
    protected LinkedList _portEventListeners = null;
    private static final Receiver[][] _EMPTY_RECEIVER_ARRAY = new Receiver[0][0];
    private boolean _isInput;
    private boolean _isOutput;
    private transient long _insideInputVersion = -1L;
    private transient long _insideOutputVersion = -1L;
    private boolean _isInputOutputStatusSet = false;
    private boolean _isMultiport = false;
    private transient int _width = 0;
    private transient long _widthVersion = -1L;
    private transient int _insideWidth = 0;
    private transient long _insideWidthVersion = -1L;
    private transient Receiver[][] _farReceivers;
    private transient long _farReceiversVersion = -1L;
    private transient Receiver[][] _localReceivers;
    private transient long _localReceiversVersion = -1L;
    private transient Receiver[][] _localInsideReceivers;
    private transient long _localInsideReceiversVersion = -1L;
    private transient Receiver[][] _insideReceivers;
    private transient long _insideReceiversVersion = -1L;
    private HashMap _localReceiversTable;
    private transient int _numberOfSinks;
    private transient long _numberOfSinksVersion = -1L;
    private transient int _numberOfSources;
    private transient long _numberOfSourcesVersion = -1L;
    private transient LinkedList _sinkPortList;
    private transient long _sinkPortListVersion;
    private transient LinkedList _sourcePortList;
    private transient long _sourcePortListVersion;

    public IOPort() {
    }

    public IOPort(Workspace workspace) {
        super(workspace);
    }

    public IOPort(ComponentEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public IOPort(ComponentEntity container, String name, boolean isInput, boolean isOutput) throws IllegalActionException, NameDuplicationException {
        this(container, name);
        this.setInput(isInput);
        this.setOutput(isOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIOPortEventListener(IOPortEventListener listener) {
        Cloneable cloneable = this;
        synchronized (cloneable) {
            if (this._portEventListeners == null) {
                this._portEventListeners = new LinkedList();
            }
        }
        cloneable = this._portEventListeners;
        synchronized (cloneable) {
            if (this._portEventListeners.contains(listener)) {
                return;
            }
            this._portEventListeners.add(listener);
            this._hasPortEventListeners = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(Token token) throws IllegalActionException, NoRoomException {
        Receiver[][] farReceivers;
        if (this._debugging) {
            this._debug("broadcast " + token);
        }
        if (this._hasPortEventListeners) {
            this._notifyPortEventListeners(new IOPortEvent(this, 1, -1, true, token));
        }
        try {
            this._workspace.getReadAccess();
            farReceivers = this.getRemoteReceivers();
            if (farReceivers == null) {
                return;
            }
        }
        finally {
            this._workspace.doneReading();
        }
        for (int i = 0; i < farReceivers.length; ++i) {
            if (farReceivers[i] == null || farReceivers[i].length <= 0) continue;
            farReceivers[i][0].putToAll(token, farReceivers[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(Token[] tokenArray, int vectorLength) throws IllegalActionException, NoRoomException {
        Receiver[][] farReceivers;
        if (this._debugging) {
            this._debug("broadcast token array of length " + vectorLength);
        }
        if (this._hasPortEventListeners) {
            this._notifyPortEventListeners(new IOPortEvent(this, 1, -1, true, tokenArray, vectorLength));
        }
        try {
            this._workspace.getReadAccess();
            farReceivers = this.getRemoteReceivers();
            if (farReceivers == null) {
                return;
            }
        }
        finally {
            this._workspace.doneReading();
        }
        for (int i = 0; i < farReceivers.length; ++i) {
            if (farReceivers[i] == null || farReceivers[i].length <= 0) continue;
            farReceivers[i][0].putArrayToAll(tokenArray, vectorLength, farReceivers[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastClear() throws IllegalActionException {
        Receiver[][] farReceivers;
        if (this._debugging) {
            this._debug("broadcast clear.");
        }
        try {
            this._workspace.getReadAccess();
            farReceivers = this.getRemoteReceivers();
            if (farReceivers == null) {
                return;
            }
        }
        finally {
            this._workspace.doneReading();
        }
        for (int i = 0; i < farReceivers.length; ++i) {
            if (farReceivers[i] == null) continue;
            for (int j = 0; j < farReceivers[i].length; ++j) {
                farReceivers[i][j].clear();
            }
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        IOPort newObject = (IOPort)super.clone(workspace);
        newObject._insideInputVersion = -1L;
        newObject._insideOutputVersion = -1L;
        newObject._width = 0;
        newObject._widthVersion = -1L;
        newObject._insideWidth = 0;
        newObject._insideWidthVersion = -1L;
        newObject._farReceivers = null;
        newObject._farReceiversVersion = -1L;
        newObject._localReceivers = null;
        newObject._localReceiversVersion = -1L;
        newObject._localInsideReceivers = null;
        newObject._localInsideReceiversVersion = -1L;
        newObject._localReceiversTable = null;
        newObject._insideReceivers = null;
        newObject._insideReceiversVersion = -1L;
        newObject._hasPortEventListeners = false;
        newObject._portEventListeners = null;
        return newObject;
    }

    public Token convert(Token token) throws IllegalActionException {
        return token;
    }

    public void createReceivers() throws IllegalActionException {
        if (!this.isOpaque()) {
            throw new IllegalActionException((Nameable)this, "createReceivers: Can only create receivers on opaque ports. Perhaps there is no top level director?");
        }
        if (this._debugging) {
            this._debug("create receivers");
        }
        if (this._localReceiversTable != null) {
            for (Relation relation : this._localReceiversTable.keySet()) {
                this._removeReceivers(relation);
            }
        }
        this._localReceiversTable = new HashMap();
        this._localReceiversVersion = -1L;
        this._insideReceiversVersion = -1L;
        boolean input = this.isInput();
        boolean output = this.isOutput();
        if (input) {
            Iterator outsideRelations = this.linkedRelationList().iterator();
            int myWidth = this.getWidth();
            boolean madeOne = false;
            while (outsideRelations.hasNext()) {
                List<Receiver[][]> occurrences;
                IORelation relation = (IORelation)outsideRelations.next();
                if (relation == null) continue;
                int width = relation.getWidth();
                if (!madeOne && myWidth == 1 && width > 1) {
                    width = 1;
                }
                Receiver[][] result = new Receiver[width][1];
                for (int i = 0; i < width; ++i) {
                    result[i][0] = this._newReceiver();
                    madeOne = true;
                }
                if (this._localReceiversTable.containsKey(relation)) {
                    occurrences = (List)this._localReceiversTable.get(relation);
                    occurrences.add(result);
                } else {
                    occurrences = new LinkedList<Receiver[][]>();
                    occurrences.add(result);
                    this._localReceiversTable.put(relation, occurrences);
                }
                if (myWidth != 1 || !madeOne) continue;
                break;
            }
        }
        if (output) {
            for (IORelation relation : this.insideRelationList()) {
                List<Receiver[][]> occurrences;
                int width = relation.getWidth();
                Receiver[][] result = new Receiver[width][1];
                for (int i = 0; i < width; ++i) {
                    result[i][0] = this._newInsideReceiver();
                }
                if (this._localReceiversTable.containsKey(relation)) {
                    occurrences = (List)this._localReceiversTable.get(relation);
                    occurrences.add(result);
                    continue;
                }
                occurrences = new LinkedList<Receiver[][]>();
                occurrences.add(result);
                this._localReceiversTable.put(relation, occurrences);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List deepConnectedInPortList() {
        try {
            this._workspace.getReadAccess();
            LinkedList<IOPort> result = new LinkedList<IOPort>();
            for (IOPort port : this.deepConnectedPortList()) {
                if (!port.isInput()) continue;
                result.addLast(port);
            }
            LinkedList<IOPort> linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration deepConnectedInPorts() {
        return Collections.enumeration(this.deepConnectedInPortList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List deepConnectedOutPortList() {
        try {
            this._workspace.getReadAccess();
            LinkedList<IOPort> result = new LinkedList<IOPort>();
            for (IOPort port : this.deepConnectedPortList()) {
                if (!port.isOutput()) continue;
                result.addLast(port);
            }
            LinkedList<IOPort> linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration deepConnectedOutPorts() {
        return Collections.enumeration(this.deepConnectedOutPortList());
    }

    public Receiver[][] deepGetReceivers() {
        if (!this.isInput()) {
            return _EMPTY_RECEIVER_ARRAY;
        }
        int width = this.getWidthInside();
        if (width <= 0) {
            return _EMPTY_RECEIVER_ARRAY;
        }
        if (this._insideReceiversVersion != this._workspace.getVersion()) {
            this._insideReceivers = new Receiver[width][0];
            int index = 0;
            for (IORelation relation : this.insideRelationList()) {
                Receiver[][] deepReceiver = relation.deepReceivers(this);
                if (deepReceiver == null) continue;
                int size = Math.min(deepReceiver.length, width - index);
                for (int i = 0; i < size; ++i) {
                    if (deepReceiver[i] == null) continue;
                    this._insideReceivers[index++] = deepReceiver[i];
                }
            }
            this._insideReceiversVersion = this._workspace.getVersion();
        }
        return this._insideReceivers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token get(int channelIndex) throws NoTokenException, IllegalActionException {
        Receiver[][] localReceivers;
        try {
            this._workspace.getReadAccess();
            localReceivers = this.getReceivers();
            if (channelIndex >= localReceivers.length) {
                if (!this.isInput()) {
                    throw new IllegalActionException((Nameable)this, "Port is not an input port!");
                }
                throw new IllegalActionException((Nameable)this, "Channel index " + channelIndex + " is out of range, because width is only " + this.getWidth() + ".");
            }
            if (localReceivers[channelIndex] == null) {
                throw new NoTokenException(this, "No receiver at index: " + channelIndex + ".");
            }
        }
        finally {
            this._workspace.doneReading();
        }
        Token token = null;
        for (int j = 0; j < localReceivers[channelIndex].length; ++j) {
            Token localToken = localReceivers[channelIndex][j].get();
            if (token != null) continue;
            token = localToken;
            if (!this._hasPortEventListeners) continue;
            this._notifyPortEventListeners(new IOPortEvent(this, 3, channelIndex, true, token));
        }
        if (token == null) {
            throw new NoTokenException(this, "No token to return.");
        }
        if (this._debugging) {
            this._debug("get from channel " + channelIndex + ": " + token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token[] get(int channelIndex, int vectorLength) throws NoTokenException, IllegalActionException {
        Receiver[][] localReceivers;
        try {
            this._workspace.getReadAccess();
            localReceivers = this.getReceivers();
        }
        finally {
            this._workspace.doneReading();
        }
        if (channelIndex >= localReceivers.length) {
            throw new IllegalActionException((Nameable)this, "get: channel index is out of range.");
        }
        if (localReceivers[channelIndex] == null) {
            throw new NoTokenException(this, "get: no receiver at index: " + channelIndex + ".");
        }
        Token[] retArray = localReceivers[channelIndex][0].getArray(vectorLength);
        if (retArray == null) {
            throw new NoTokenException(this, "get: No token array to return.");
        }
        if (this._hasPortEventListeners) {
            this._notifyPortEventListeners(new IOPortEvent(this, 3, channelIndex, true, retArray, vectorLength));
        }
        for (int index = 1; index < localReceivers[channelIndex].length; ++index) {
            localReceivers[channelIndex][index].getArray(vectorLength);
        }
        if (this._debugging) {
            this._debug("get vector from channel " + channelIndex + " of length " + vectorLength);
        }
        return retArray;
    }

    public int getChannelForReceiver(Receiver receiver) throws IllegalActionException {
        IOPort port = receiver.getContainer();
        Receiver[][] receivers = port.getReceivers();
        for (int channel = 0; channel < receivers.length; ++channel) {
            if (receivers[channel] == null) continue;
            for (int copy = 0; copy < receivers[channel].length; ++copy) {
                if (receivers[channel][copy] != receiver) continue;
                return channel;
            }
        }
        throw new IllegalActionException((Nameable)this, "Attempt to get a channel number of receiver that does not belong to this port.");
    }

    public double getCurrentTime(int channelIndex) throws IllegalActionException {
        return this.getModelTime(channelIndex).getDoubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getInside(int channelIndex) throws NoTokenException, IllegalActionException {
        Receiver[][] localReceivers;
        try {
            this._workspace.getReadAccess();
            localReceivers = this.getInsideReceivers();
            if (channelIndex >= localReceivers.length) {
                if (!this.isOutput()) {
                    throw new IllegalActionException((Nameable)this, "Port is not an output port!");
                }
                throw new IllegalActionException((Nameable)this, "Channel index " + channelIndex + " is out of range, because inside width is only " + this.getWidthInside() + ".");
            }
            if (localReceivers[channelIndex] == null) {
                throw new IllegalActionException((Nameable)this, "No receiver at inside index: " + channelIndex + ".");
            }
        }
        finally {
            this._workspace.doneReading();
        }
        Token token = null;
        for (int j = 0; j < localReceivers[channelIndex].length; ++j) {
            Token localToken = localReceivers[channelIndex][j].get();
            if (token != null) continue;
            token = localToken;
            if (!this._hasPortEventListeners) continue;
            this._notifyPortEventListeners(new IOPortEvent(this, 3, channelIndex, true, token));
        }
        if (token == null) {
            throw new NoTokenException(this, "No token to return.");
        }
        if (this._debugging) {
            this._debug("get from inside channel " + channelIndex + ": " + token);
        }
        return token;
    }

    public Receiver[][] getInsideReceivers() {
        try {
            this._workspace.getReadAccess();
            if (!this.isOutput() || !this.isOpaque()) {
                Receiver[][] receiverArray = _EMPTY_RECEIVER_ARRAY;
                return receiverArray;
            }
            if (this._localInsideReceiversVersion == this._workspace.getVersion()) {
                Receiver[][] receiverArray = this._localInsideReceivers;
                return receiverArray;
            }
            int width = this.getWidthInside();
            if (width <= 0) {
                Receiver[][] receiverArray = _EMPTY_RECEIVER_ARRAY;
                return receiverArray;
            }
            this._localInsideReceivers = new Receiver[width][0];
            int index = 0;
            Iterator relations = this.insideRelationList().iterator();
            HashMap<IORelation, Integer> seen = new HashMap<IORelation, Integer>();
            while (relations.hasNext()) {
                IORelation relation = (IORelation)relations.next();
                int occurrence = 0;
                if (seen.containsKey(relation)) {
                    occurrence = (Integer)seen.get(relation);
                    ++occurrence;
                }
                seen.put(relation, occurrence);
                Receiver[][] receivers = this.getReceivers(relation, occurrence);
                if (receivers == null) continue;
                for (int i = 0; i < receivers.length; ++i) {
                    this._localInsideReceivers[index++] = receivers[i];
                }
            }
            this._localInsideReceiversVersion = this._workspace.getVersion();
            Receiver[][] receiverArray = this._localInsideReceivers;
            return receiverArray;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(this, (Throwable)ex, "Expected relation to be connected!");
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getModelTime(int channelIndex) throws IllegalActionException {
        try {
            Receiver[][] localReceivers;
            try {
                this._workspace.getReadAccess();
                localReceivers = this.getReceivers();
                if (localReceivers[channelIndex] == null) {
                    throw new IllegalActionException((Nameable)this, "no receiver at index: " + channelIndex + ".");
                }
            }
            finally {
                this._workspace.doneReading();
            }
            AbstractReceiver receiver = (AbstractReceiver)localReceivers[channelIndex][0];
            return receiver.getModelTime();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalActionException((Nameable)this, "getCurrentTime: channel index is out of range.");
        }
    }

    public Receiver[][] getReceivers() {
        try {
            this._workspace.getReadAccess();
            if (!this.isInput()) {
                Receiver[][] receiverArray = _EMPTY_RECEIVER_ARRAY;
                return receiverArray;
            }
            if (this.isOpaque()) {
                if (this._localReceiversVersion == this._workspace.getVersion()) {
                    Receiver[][] receiverArray = this._localReceivers;
                    return receiverArray;
                }
                int width = this.getWidth();
                if (width <= 0) {
                    Receiver[][] receiverArray = _EMPTY_RECEIVER_ARRAY;
                    return receiverArray;
                }
                this._localReceivers = new Receiver[width][0];
                int index = 0;
                Iterator relations = this.linkedRelationList().iterator();
                HashMap<IORelation, Integer> seen = new HashMap<IORelation, Integer>();
                while (relations.hasNext()) {
                    IORelation relation = (IORelation)relations.next();
                    if (relation == null) continue;
                    int occurrence = 0;
                    if (seen.containsKey(relation)) {
                        occurrence = (Integer)seen.get(relation);
                        ++occurrence;
                    }
                    seen.put(relation, occurrence);
                    Receiver[][] receiverRelation = this.getReceivers(relation, occurrence);
                    if (receiverRelation == null) continue;
                    for (int i = 0; i < receiverRelation.length; ++i) {
                        this._localReceivers[index++] = receiverRelation[i];
                    }
                }
                this._localReceiversVersion = this._workspace.getVersion();
                Receiver[][] receiverArray = this._localReceivers;
                return receiverArray;
            }
            Receiver[][] width = this.deepGetReceivers();
            return width;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(this, (Throwable)ex, "Expected relation to be connected!");
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Receiver[][] getReceivers(IORelation relation) throws IllegalActionException {
        return this.getReceivers(relation, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Receiver[][] getReceivers(IORelation relation, int occurrence) throws IllegalActionException {
        try {
            this._workspace.getReadAccess();
            boolean insideLink = this.isInsideLinked(relation);
            if (!this.isLinked(relation) && !insideLink) {
                throw new IllegalActionException((Nameable)this, relation, "getReceivers: Relation argument is not linked to me.");
            }
            Receiver[][] receiverArray = this._getReceivers(relation, occurrence, insideLink);
            return receiverArray;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Receiver[][] getRemoteReceivers() {
        try {
            this._workspace.getReadAccess();
            if (!this.isOutput()) {
                Receiver[][] receiverArray = _EMPTY_RECEIVER_ARRAY;
                return receiverArray;
            }
            int width = this.getWidth();
            if (width <= 0) {
                Receiver[][] receiverArray = _EMPTY_RECEIVER_ARRAY;
                return receiverArray;
            }
            if (this.isOpaque() && this._farReceiversVersion == this._workspace.getVersion()) {
                Receiver[][] receiverArray = this._farReceivers;
                return receiverArray;
            }
            Receiver[][] farReceivers = new Receiver[width][0];
            Iterator relations = this.linkedRelationList().iterator();
            int index = 0;
            while (relations.hasNext()) {
                IORelation relation = (IORelation)relations.next();
                if (relation == null) continue;
                Receiver[][] deepReceivers = relation.deepReceivers(this);
                if (deepReceivers != null) {
                    for (int i = 0; i < deepReceivers.length; ++i) {
                        farReceivers[index] = deepReceivers[i];
                        ++index;
                    }
                    continue;
                }
                index += relation.getWidth();
            }
            if (this.isOpaque()) {
                this._farReceiversVersion = this._workspace.getVersion();
                this._farReceivers = farReceivers;
            }
            Receiver[][] receiverArray = farReceivers;
            return receiverArray;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Receiver[][] getRemoteReceivers(IORelation relation) throws IllegalActionException {
        try {
            this._workspace.getReadAccess();
            if (!this.isInsideGroupLinked(relation)) {
                throw new IllegalActionException((Nameable)this, relation, "not linked from the inside.");
            }
            if (!this.isOutput()) {
                Receiver[][] receiverArray = _EMPTY_RECEIVER_ARRAY;
                return receiverArray;
            }
            int width = relation.getWidth();
            if (width <= 0) {
                Receiver[][] receiverArray = _EMPTY_RECEIVER_ARRAY;
                return receiverArray;
            }
            Receiver[][] outsideReceivers = this.getRemoteReceivers();
            if (outsideReceivers == null) {
                Receiver[][] receiverArray = _EMPTY_RECEIVER_ARRAY;
                return receiverArray;
            }
            Receiver[][] result = new Receiver[width][];
            Iterator insideRelations = this.insideRelationList().iterator();
            int index = 0;
            while (insideRelations.hasNext()) {
                IORelation insideRelation = (IORelation)insideRelations.next();
                if (insideRelation.relationGroupList().contains(relation)) {
                    int size = Math.min(width, outsideReceivers.length - index);
                    for (int i = 0; i < size; ++i) {
                        result[i] = outsideReceivers[i + index];
                    }
                    break;
                }
                index += insideRelation.getWidth();
            }
            Receiver[][] receiverArray = result;
            return receiverArray;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        try {
            this._workspace.getReadAccess();
            long version = this._workspace.getVersion();
            if (this._widthVersion != version) {
                this._widthVersion = version;
                int sum = 0;
                for (IORelation relation : this.linkedRelationList()) {
                    if (relation == null) continue;
                    sum += relation.getWidth();
                }
                this._width = !this.isMultiport() ? (sum > 0 ? 1 : 0) : sum;
            }
            int n = this._width;
            return n;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidthInside() {
        try {
            this._workspace.getReadAccess();
            long version = this._workspace.getVersion();
            if (this._insideWidthVersion != version) {
                this._insideWidthVersion = version;
                int sum = 0;
                for (IORelation relation : this.insideRelationList()) {
                    if (relation == null) continue;
                    sum += relation.getWidth();
                }
                this._insideWidth = sum;
            }
            int n = this._insideWidth;
            return n;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public boolean hasRoom(int channelIndex) throws IllegalActionException {
        boolean result;
        block5: {
            result = true;
            try {
                Receiver[][] farReceivers = this.getRemoteReceivers();
                if (farReceivers == null || farReceivers[channelIndex] == null) {
                    result = false;
                    break block5;
                }
                for (int j = 0; j < farReceivers[channelIndex].length; ++j) {
                    if (farReceivers[channelIndex][j].hasRoom()) continue;
                    result = false;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new IllegalActionException((Nameable)this, "hasRoom: channel index is out of range.");
            }
        }
        if (this._debugging) {
            this._debug("hasRoom on channel " + channelIndex + " returns " + result);
        }
        return result;
    }

    public boolean hasRoomInside(int channelIndex) throws IllegalActionException {
        boolean result;
        block5: {
            result = true;
            try {
                Receiver[][] farReceivers = this.getInsideReceivers();
                if (farReceivers == null || farReceivers[channelIndex] == null) {
                    result = false;
                    break block5;
                }
                for (int j = 0; j < farReceivers[channelIndex].length; ++j) {
                    if (farReceivers[channelIndex][j].hasRoom()) continue;
                    result = false;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new IllegalActionException((Nameable)this, "hasRoom: channel index is out of range.");
            }
        }
        if (this._debugging) {
            this._debug("hasRoomInside on channel " + channelIndex + " returns " + result);
        }
        return result;
    }

    public boolean hasToken(int channelIndex) throws IllegalActionException {
        Receiver[][] receivers = this.getReceivers();
        boolean result = false;
        if (receivers != null && channelIndex >= receivers.length) {
            if (!this.isInput()) {
                throw new IllegalActionException((Nameable)this, "Port is not an input port!");
            }
            throw new IllegalActionException((Nameable)this, "Channel index " + channelIndex + " is out of range, because width is only " + this.getWidth() + ".");
        }
        if (receivers != null && receivers[channelIndex] != null) {
            for (int j = 0; j < receivers[channelIndex].length; ++j) {
                if (!receivers[channelIndex][j].hasToken()) continue;
                result = true;
                break;
            }
        }
        if (this._debugging) {
            this._debug("hasToken on channel " + channelIndex + " returns " + result);
        }
        return result;
    }

    public boolean hasToken(int channelIndex, int tokens) throws IllegalActionException {
        boolean result;
        block4: {
            result = false;
            try {
                Receiver[][] receivers = this.getReceivers();
                if (receivers == null || receivers[channelIndex] == null) break block4;
                for (int j = 0; j < receivers[channelIndex].length; ++j) {
                    if (!receivers[channelIndex][j].hasToken(tokens)) continue;
                    result = true;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new IllegalActionException((Nameable)this, "hasToken: channel index is out of range.");
            }
        }
        if (this._debugging) {
            this._debug("hasToken on channel " + channelIndex + " returns " + result + ", with " + tokens + " tokens requested");
        }
        return result;
    }

    public boolean hasTokenInside(int channelIndex) throws IllegalActionException {
        Receiver[][] receivers = this.getInsideReceivers();
        boolean result = false;
        if (channelIndex >= receivers.length) {
            if (!this.isOutput()) {
                throw new IllegalActionException((Nameable)this, "Port is not an output port!");
            }
            throw new IllegalActionException((Nameable)this, "Channel index " + channelIndex + " is out of range, because inside width is only " + this.getWidthInside() + ".");
        }
        if (receivers[channelIndex] != null) {
            for (int j = 0; j < receivers[channelIndex].length; ++j) {
                if (!receivers[channelIndex][j].hasToken()) continue;
                result = true;
                break;
            }
        }
        if (this._debugging) {
            this._debug("hasTokenInside on channel " + channelIndex + " returns " + result);
        }
        return result;
    }

    @Override
    public void insertLink(int index, Relation relation) throws IllegalActionException {
        if (!this.isMultiport()) {
            if (index > 0) {
                throw new IllegalActionException((Nameable)this, "Cannot insert link at an index greater than zero in a port that is not a multiport.");
            }
            if (this._isInsideLinkable(relation)) {
                if (this.numInsideLinks() > 0) {
                    throw new IllegalActionException((Nameable)this, "Cannot insert a second inside link in a port that is not a multiport.");
                }
            } else if (this.numLinks() > 0) {
                throw new IllegalActionException((Nameable)this, "Cannot insert a second link in a port that is not a multiport.");
            }
        }
        super.insertLink(index, relation);
        this._invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List insideSinkPortList() {
        try {
            this._workspace.getReadAccess();
            NamedObj container = this.getContainer();
            if (!(container instanceof CompositeActor && this.isInput() && this.isOpaque())) {
                LinkedList linkedList = new LinkedList();
                return linkedList;
            }
            Director dir = ((CompositeActor)container).getDirector();
            int depthOfDirector = dir.depthInHierarchy();
            LinkedList<IOPort> result = new LinkedList<IOPort>();
            for (IOPort port : this.deepInsidePortList()) {
                int depth = port.getContainer().depthInHierarchy();
                if (port.isInput() && depth >= depthOfDirector) {
                    result.addLast(port);
                    continue;
                }
                if (!port.isOutput() || depth >= depthOfDirector) continue;
                result.addLast(port);
            }
            LinkedList<IOPort> linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List insideSourcePortList() {
        try {
            this._workspace.getReadAccess();
            NamedObj container = this.getContainer();
            if (!(container instanceof CompositeActor && this.isOutput() && this.isOpaque())) {
                LinkedList linkedList = new LinkedList();
                return linkedList;
            }
            Director dir = ((CompositeActor)container).getDirector();
            int depthOfDirector = dir.depthInHierarchy();
            LinkedList<IOPort> result = new LinkedList<IOPort>();
            for (IOPort port : this.deepInsidePortList()) {
                int depth = port.getContainer().depthInHierarchy();
                if (port.isInput() && depth < depthOfDirector) {
                    result.addLast(port);
                    continue;
                }
                if (!port.isOutput() || depth < depthOfDirector) continue;
                result.addLast(port);
            }
            LinkedList<IOPort> linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInput() {
        if (this._isInputOutputStatusSet) {
            return this._isInput;
        }
        long version = this._workspace.getVersion();
        if (this._insideInputVersion != version) {
            try {
                this._workspace.getReadAccess();
                this._isInput = false;
                for (IOPort p : this.deepInsidePortList()) {
                    if (p == this || !p.isInput()) continue;
                    this._isInput = true;
                }
                this._insideInputVersion = version;
            }
            finally {
                this._workspace.doneReading();
            }
        }
        return this._isInput;
    }

    public boolean isKnown() throws IllegalActionException {
        boolean result = true;
        for (int j = 0; j < this.getWidth(); ++j) {
            if (this.isKnown(j)) continue;
            result = false;
            break;
        }
        if (this._debugging) {
            this._debug("isKnown returns " + result);
        }
        return result;
    }

    public boolean isKnown(int channelIndex) throws IllegalActionException {
        boolean result;
        block9: {
            result = true;
            try {
                int j;
                Receiver[][] receivers;
                if (this.isInput()) {
                    receivers = this.getReceivers();
                    if (receivers.length <= channelIndex) {
                        throw new IllegalActionException((Nameable)this, "Channel index is out of range: " + channelIndex);
                    }
                    if (receivers[channelIndex] != null) {
                        for (j = 0; j < receivers[channelIndex].length; ++j) {
                            if (receivers[channelIndex][j].isKnown()) continue;
                            result = false;
                            break;
                        }
                    }
                }
                if (!result || !this.isOutput()) break block9;
                receivers = this.getRemoteReceivers();
                if (receivers.length <= channelIndex) {
                    throw new IllegalActionException((Nameable)this, "Channel index is out of range: " + channelIndex);
                }
                if (receivers[channelIndex] == null) break block9;
                for (j = 0; j < receivers[channelIndex].length; ++j) {
                    if (receivers[channelIndex][j].isKnown()) continue;
                    result = false;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new IllegalActionException((Nameable)this, "isKnown: channel index is out of range.");
            }
        }
        if (this._debugging) {
            this._debug("isKnown on channel " + channelIndex + " returns " + result);
        }
        return result;
    }

    public boolean isKnownInside(int channelIndex) throws IllegalActionException {
        boolean result;
        block6: {
            result = true;
            try {
                int j;
                Receiver[][] receivers;
                if (this.isOutput() && (receivers = this.getInsideReceivers()) != null && receivers[channelIndex] != null) {
                    for (j = 0; j < receivers[channelIndex].length; ++j) {
                        if (receivers[channelIndex][j].isKnown()) continue;
                        result = false;
                        break;
                    }
                }
                if (!result || !this.isInput() || (receivers = this.deepGetReceivers()) == null || receivers[channelIndex] == null) break block6;
                for (j = 0; j < receivers[channelIndex].length; ++j) {
                    if (receivers[channelIndex][j].isKnown()) continue;
                    result = false;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new IllegalActionException((Nameable)this, "isKnownInside: channel index is out of range.");
            }
        }
        if (this._debugging) {
            this._debug("isKnownInside on channel " + channelIndex + " returns " + result);
        }
        return result;
    }

    public boolean isMultiport() {
        return this._isMultiport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutput() {
        if (this._isInputOutputStatusSet) {
            return this._isOutput;
        }
        long version = this._workspace.getVersion();
        if (this._insideOutputVersion != version) {
            try {
                this._workspace.getReadAccess();
                this._isOutput = false;
                for (IOPort p : this.deepInsidePortList()) {
                    if (p == this || !p.isOutput()) continue;
                    this._isOutput = true;
                }
                this._insideOutputVersion = version;
            }
            finally {
                this._workspace.doneReading();
            }
        }
        return this._isOutput;
    }

    @Override
    public void liberalLink(ComponentRelation relation) throws IllegalActionException {
        super.liberalLink(relation);
        this._invalidate();
    }

    @Override
    public void link(Relation relation) throws IllegalActionException {
        super.link(relation);
        this._invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfSinks() {
        try {
            this._workspace.getReadAccess();
            if (this._numberOfSinksVersion != this._workspace.getVersion()) {
                NamedObj container = this.getContainer();
                Director excDirector = ((Actor)((Object)container)).getExecutiveDirector();
                int depthOfDirector = excDirector.depthInHierarchy();
                LinkedList<IOPort> result = new LinkedList<IOPort>();
                for (IOPort port : this.deepConnectedPortList()) {
                    int depth = port.getContainer().depthInHierarchy();
                    if (port.isInput() && depth >= depthOfDirector) {
                        result.addLast(port);
                        continue;
                    }
                    if (!port.isOutput() || depth >= depthOfDirector || port.numberOfSinks() <= 0) continue;
                    result.addLast(port);
                }
                this._numberOfSinks = result.size();
                this._numberOfSinksVersion = this._workspace.getVersion();
            }
            int n = this._numberOfSinks;
            return n;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfSources() {
        try {
            this._workspace.getReadAccess();
            if (this._numberOfSourcesVersion != this._workspace.getVersion()) {
                NamedObj container = this.getContainer();
                int depthOfDirector = -1;
                if (container != null) {
                    Director director = ((Actor)((Object)container)).getExecutiveDirector();
                    depthOfDirector = director.depthInHierarchy();
                }
                LinkedList<IOPort> result = new LinkedList<IOPort>();
                for (IOPort port : this.deepConnectedPortList()) {
                    int depth = port.depthInHierarchy();
                    if (port.isInput() && depth <= depthOfDirector && port.numberOfSources() > 0) {
                        result.addLast(port);
                        continue;
                    }
                    if (!port.isOutput() || depth <= depthOfDirector) continue;
                    result.addLast(port);
                }
                this._numberOfSources = result.size();
                this._numberOfSourcesVersion = this._workspace.getVersion();
            }
            int n = this._numberOfSources;
            return n;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIOPortEventListener(IOPortEventListener listener) {
        if (this._portEventListeners == null) {
            return;
        }
        LinkedList linkedList = this._portEventListeners;
        synchronized (linkedList) {
            this._portEventListeners.remove(listener);
            if (this._portEventListeners.size() == 0) {
                this._hasPortEventListeners = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(int channelIndex, Token token) throws IllegalActionException, NoRoomException {
        Receiver[][] farReceivers;
        if (token == null) {
            throw new IllegalActionException((Nameable)this, "Cannot send a null token.");
        }
        if (this._debugging) {
            this._debug("send to channel " + channelIndex + ": " + token);
        }
        if (this._hasPortEventListeners) {
            this._notifyPortEventListeners(new IOPortEvent(this, 1, channelIndex, true, token));
        }
        try {
            this._workspace.getReadAccess();
            farReceivers = this.getRemoteReceivers();
            if (farReceivers == null || farReceivers.length <= channelIndex || farReceivers[channelIndex] == null) {
                return;
            }
        }
        finally {
            this._workspace.doneReading();
        }
        if (farReceivers[channelIndex].length > 0) {
            farReceivers[channelIndex][0].putToAll(token, farReceivers[channelIndex]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(int channelIndex, Token[] tokenArray, int vectorLength) throws IllegalActionException, NoRoomException {
        Receiver[][] farReceivers;
        if (this._debugging) {
            this._debug("send to channel " + channelIndex + " token array of length " + vectorLength);
        }
        if (this._hasPortEventListeners) {
            this._notifyPortEventListeners(new IOPortEvent(this, 1, channelIndex, true, tokenArray, vectorLength));
        }
        try {
            this._workspace.getReadAccess();
            farReceivers = this.getRemoteReceivers();
            if (farReceivers == null || farReceivers.length <= channelIndex || farReceivers[channelIndex] == null) {
                return;
            }
        }
        finally {
            this._workspace.doneReading();
        }
        if (farReceivers[channelIndex].length > 0) {
            farReceivers[channelIndex][0].putArrayToAll(tokenArray, vectorLength, farReceivers[channelIndex]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendClear(int channelIndex) throws IllegalActionException {
        Receiver[][] farReceivers;
        if (this._debugging) {
            this._debug("sendClear to channel " + channelIndex);
        }
        try {
            this._workspace.getReadAccess();
            farReceivers = this.getRemoteReceivers();
            if (farReceivers == null || farReceivers.length <= channelIndex || farReceivers[channelIndex] == null) {
                return;
            }
        }
        finally {
            this._workspace.doneReading();
        }
        for (int j = 0; j < farReceivers[channelIndex].length; ++j) {
            farReceivers[channelIndex][j].clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendClearInside(int channelIndex) throws IllegalActionException {
        Receiver[][] farReceivers;
        if (this._debugging) {
            this._debug("sendClearInside to channel " + channelIndex);
        }
        try {
            this._workspace.getReadAccess();
            farReceivers = this.deepGetReceivers();
            if (farReceivers == null || farReceivers.length <= channelIndex || farReceivers[channelIndex] == null) {
                return;
            }
        }
        finally {
            this._workspace.doneReading();
        }
        for (int j = 0; j < farReceivers[channelIndex].length; ++j) {
            farReceivers[channelIndex][j].clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendInside(int channelIndex, Token token) throws IllegalActionException, NoRoomException {
        Receiver[][] farReceivers;
        if (this._debugging) {
            this._debug("send inside to channel " + channelIndex + ": " + token);
        }
        if (this._hasPortEventListeners) {
            this._notifyPortEventListeners(new IOPortEvent(this, 1, channelIndex, true, token));
        }
        try {
            this._workspace.getReadAccess();
            farReceivers = this.deepGetReceivers();
            if (farReceivers == null || farReceivers.length <= channelIndex || farReceivers[channelIndex] == null) {
                return;
            }
        }
        finally {
            this._workspace.doneReading();
        }
        if (farReceivers[channelIndex].length > 0) {
            farReceivers[channelIndex][0].putToAll(token, farReceivers[channelIndex]);
        }
    }

    @Override
    public void setContainer(Entity container) throws IllegalActionException, NameDuplicationException {
        Director director;
        Actor oldContainer = (Actor)((Object)this.getContainer());
        if (oldContainer != null && (director = oldContainer.getDirector()) != null) {
            director.invalidateSchedule();
            director.invalidateResolvedTypes();
        }
        if (container instanceof Actor && (director = ((Actor)((Object)container)).getDirector()) != null) {
            director.invalidateSchedule();
            director.invalidateResolvedTypes();
        }
        super.setContainer(container);
    }

    public void setInput(boolean isInput) throws IllegalActionException {
        this._workspace.getWriteAccess();
        this._isInput = isInput;
        this._isInputOutputStatusSet = true;
        this._invalidate();
        this._workspace.doneWriting();
    }

    public void setMultiport(boolean isMultiport) throws IllegalActionException {
        this._workspace.getWriteAccess();
        this._isMultiport = isMultiport;
        this._invalidate();
        this._workspace.doneWriting();
    }

    public void setOutput(boolean isOutput) throws IllegalActionException {
        this._workspace.getWriteAccess();
        this._isOutput = isOutput;
        this._isInputOutputStatusSet = true;
        this._invalidate();
        this._workspace.doneWriting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List sinkPortList() {
        try {
            this._workspace.getReadAccess();
            if (this._sinkPortListVersion != this._workspace.getVersion()) {
                NamedObj container = this.getContainer();
                Director excDirector = ((Actor)((Object)container)).getExecutiveDirector();
                int depthOfDirector = excDirector.depthInHierarchy();
                this._sinkPortList = new LinkedList();
                for (IOPort port : this.deepConnectedPortList()) {
                    int depth = port.getContainer().depthInHierarchy();
                    if (port.isInput() && depth >= depthOfDirector) {
                        this._sinkPortList.addLast(port);
                        continue;
                    }
                    if (!port.isOutput() || depth >= depthOfDirector) continue;
                    this._sinkPortList.addLast(port);
                }
                this._sinkPortListVersion = this._workspace.getVersion();
            }
            LinkedList linkedList = this._sinkPortList;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List sourcePortList() {
        try {
            this._workspace.getReadAccess();
            if (this._sourcePortListVersion != this._workspace.getVersion()) {
                NamedObj container = this.getContainer();
                int depthOfDirector = -1;
                if (container != null) {
                    Director director = ((Actor)((Object)container)).getExecutiveDirector();
                    depthOfDirector = director.depthInHierarchy();
                }
                this._sourcePortList = new LinkedList();
                for (IOPort port : this.deepConnectedPortList()) {
                    int depth = port.depthInHierarchy();
                    if (port.isInput() && depth <= depthOfDirector) {
                        this._sourcePortList.addLast(port);
                        continue;
                    }
                    if (!port.isOutput() || depth <= depthOfDirector) continue;
                    this._sourcePortList.addLast(port);
                }
                this._sourcePortListVersion = this._workspace.getVersion();
            }
            LinkedList linkedList = this._sourcePortList;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public boolean transferInputs() throws IllegalActionException {
        if (!this.isInput() || !this.isOpaque()) {
            throw new IllegalActionException((Nameable)this, "transferInputs: this port is not an opaqueinput port.");
        }
        boolean wasTransferred = false;
        for (int i = 0; i < this.getWidth(); ++i) {
            try {
                if (!this.isKnown(i) || !this.hasToken(i)) continue;
                Token t = this.get(i);
                if (this._debugging) {
                    this._debug(this.getName(), "transferring input from " + this.getName());
                }
                this.sendInside(i, t);
                wasTransferred = true;
                continue;
            }
            catch (NoTokenException ex) {
                throw new InternalErrorException(this, (Throwable)ex, null);
            }
        }
        return wasTransferred;
    }

    public boolean transferOutputs() throws IllegalActionException {
        if (this._debugging) {
            this._debug("calling transferOutputs.");
        }
        if (!this.isOutput() || !this.isOpaque()) {
            throw new IllegalActionException((Nameable)this, "transferOutputs: this port is not an opaque output port.");
        }
        boolean wasTransferred = false;
        for (int i = 0; i < this.getWidthInside(); ++i) {
            try {
                if (!this.isKnownInside(i) || !this.hasTokenInside(i)) continue;
                Token t = this.getInside(i);
                this.send(i, t);
                wasTransferred = true;
                continue;
            }
            catch (NoTokenException ex) {
                throw new InternalErrorException(this, (Throwable)ex, null);
            }
        }
        return wasTransferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlink(int index) {
        try {
            this._workspace.getWriteAccess();
            Relation toDelete = (Relation)this._relationsList.get(index);
            if (toDelete != null && this._localReceiversTable != null) {
                this._removeReceivers(toDelete);
                this._localReceiversTable.remove(toDelete);
                this._localReceiversVersion = -1L;
            }
            super.unlink(index);
            this._invalidate();
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlink(Relation relation) {
        try {
            this._workspace.getWriteAccess();
            super.unlink(relation);
            if (this._localReceiversTable != null) {
                this._removeReceivers(relation);
                this._localReceiversTable.remove(relation);
                this._localReceiversVersion = -1L;
                this._insideReceiversVersion = -1L;
            }
            this._invalidate();
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlinkAll() {
        try {
            this._workspace.getWriteAccess();
            if (this._localReceiversTable != null) {
                HashMap clonedMap = (HashMap)this._localReceiversTable.clone();
                for (Relation relation : clonedMap.keySet()) {
                    if (this.isInsideLinked(relation)) continue;
                    this._removeReceivers(relation);
                    this._localReceiversTable.remove(relation);
                    this._localReceiversVersion = -1L;
                    this._insideReceiversVersion = -1L;
                }
            }
            super.unlinkAll();
            this._invalidate();
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlinkAllInside() {
        try {
            this._workspace.getWriteAccess();
            if (this._localReceiversTable != null) {
                HashMap clonedMap = (HashMap)this._localReceiversTable.clone();
                for (Relation relation : clonedMap.keySet()) {
                    if (!this.isInsideLinked(relation)) continue;
                    this._removeReceivers(relation);
                    this._localReceiversTable.remove(relation);
                    this._localReceiversVersion = -1L;
                    this._insideReceiversVersion = -1L;
                }
            }
            super.unlinkAllInside();
            this._invalidate();
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlinkInside(int index) {
        try {
            this._workspace.getWriteAccess();
            Relation toDelete = (Relation)this._insideLinks.get(index);
            if (toDelete != null && this._localReceiversTable != null) {
                this._removeReceivers(toDelete);
                this._localReceiversTable.remove(toDelete);
                this._insideReceiversVersion = -1L;
            }
            super.unlinkInside(index);
            this._invalidate();
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlinkInside(Relation relation) {
        try {
            this._workspace.getWriteAccess();
            super.unlinkInside(relation);
            if (this._localReceiversTable != null) {
                this._removeReceivers(relation);
                this._localReceiversTable.remove(relation);
                this._insideReceiversVersion = -1L;
            }
            this._invalidate();
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    @Override
    protected void _checkContainer(Entity container) throws IllegalActionException {
        if (!(container instanceof Actor) && container != null) {
            throw new IllegalActionException((Nameable)container, this, "IOPort can only be contained by objects implementing the Actor interface.");
        }
    }

    @Override
    protected void _checkLiberalLink(Relation relation) throws IllegalActionException {
        if (!(relation instanceof IORelation)) {
            throw new IllegalActionException((Nameable)this, relation, "Attempt to link to an incompatible relation. IOPort requires IORelation.");
        }
        this._checkMultiportLink((IORelation)relation);
        super._checkLiberalLink(relation);
    }

    @Override
    protected void _checkLink(Relation relation) throws IllegalActionException {
        if (!(relation instanceof IORelation)) {
            throw new IllegalActionException((Nameable)this, relation, "Attempt to link to an incompatible relation. IOPort requires IORelation.");
        }
        this._checkMultiportLink((IORelation)relation);
        super._checkLink(relation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _description(int detail, int indent, int bracket) {
        try {
            int j;
            int i;
            this._workspace.getReadAccess();
            StringBuffer result = new StringBuffer();
            if (bracket == 1 || bracket == 2) {
                result.append(super._description(detail, indent, 1));
            } else {
                result.append(super._description(detail, indent, 0));
            }
            if ((detail & 0x200) != 0) {
                if (result.toString().trim().length() > 0) {
                    result.append(" ");
                }
                result.append("configuration {");
                boolean space = false;
                if (this.isInput()) {
                    space = true;
                    result.append("input");
                }
                if (this.isOutput()) {
                    if (space) {
                        result.append(" ");
                    }
                    space = true;
                    result.append("output");
                }
                if (this.isMultiport()) {
                    if (space) {
                        result.append(" ");
                    }
                    space = true;
                    result.append("multiport");
                }
                if (this.isOpaque()) {
                    if (space) {
                        result.append(" ");
                    }
                    space = true;
                    result.append("opaque");
                }
                if (space) {
                    result.append(" ");
                }
                result.append("{width " + this.getWidth() + "}}");
            }
            if ((detail & 0x400) != 0) {
                if (result.toString().trim().length() > 0) {
                    result.append(" ");
                }
                result.append("receivers {\n");
                Receiver[][] receivers = this.getReceivers();
                for (i = 0; i < receivers.length; ++i) {
                    result.append(IOPort._getIndentPrefix(indent + 1) + "{\n");
                    for (j = 0; j < receivers[i].length; ++j) {
                        result.append(IOPort._getIndentPrefix(indent + 2));
                        result.append("{");
                        if (receivers[i][j] != null) {
                            result.append(receivers[i][j].getClass().getName());
                        }
                        result.append("}\n");
                    }
                    result.append(IOPort._getIndentPrefix(indent + 1) + "}\n");
                }
                result.append(IOPort._getIndentPrefix(indent) + "}");
            }
            if ((detail & 0x800) != 0) {
                if (result.toString().trim().length() > 0) {
                    result.append(" ");
                }
                result.append("remotereceivers {\n");
                Receiver[][] receivers = null;
                receivers = this.getRemoteReceivers();
                if (receivers != null) {
                    for (i = 0; i < receivers.length; ++i) {
                        result.append(IOPort._getIndentPrefix(indent + 1) + "{\n");
                        if (receivers[i] != null) {
                            for (j = 0; j < receivers[i].length; ++j) {
                                result.append(IOPort._getIndentPrefix(indent + 2));
                                result.append("{");
                                if (receivers[i][j] != null) {
                                    result.append(receivers[i][j].getClass().getName());
                                    result.append(" in ");
                                    result.append(receivers[i][j].getContainer().getFullName());
                                }
                                result.append("}\n");
                            }
                        }
                        result.append(IOPort._getIndentPrefix(indent + 1) + "}\n");
                    }
                }
                result.append(IOPort._getIndentPrefix(indent) + "}");
            }
            if (bracket == 2) {
                result.append("}");
            }
            String string = result.toString();
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    @Override
    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        if (this._isInput) {
            output.write(IOPort._getIndentPrefix(depth) + "<property name=\"input\"/>\n");
        }
        if (this._isOutput) {
            output.write(IOPort._getIndentPrefix(depth) + "<property name=\"output\"/>\n");
        }
        if (this._isMultiport) {
            output.write(IOPort._getIndentPrefix(depth) + "<property name=\"multiport\"/>\n");
        }
        super._exportMoMLContents(output, depth);
    }

    protected int _getInsideWidth(IORelation except) {
        int result = 0;
        for (IORelation relation : this.insideRelationList()) {
            if (relation == except) continue;
            if (!relation.isWidthFixed()) {
                throw new InvalidStateException(this, "Width of inside relations cannot be determined.");
            }
            result += relation.getWidth();
        }
        return result;
    }

    protected int _getOutsideWidth(IORelation except) {
        int result = 0;
        for (IORelation relation : this.linkedRelationList()) {
            if (relation == except) continue;
            if (!relation.isWidthFixed()) {
                throw new InvalidStateException(this, "Width of outside relations cannot be determined.");
            }
            result += relation.getWidth();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Receiver[][] _getReceiversLinkedToGroup(IORelation relation, int occurrence) throws IllegalActionException {
        try {
            this._workspace.getReadAccess();
            boolean insideLink = this.isInsideGroupLinked(relation);
            if (!this.isGroupLinked(relation) && !insideLink) {
                throw new IllegalActionException((Nameable)this, relation, "getReceivers: Relation argument is not linked to me on the inside.");
            }
            List groupRelationsList = relation.relationGroupList();
            if (groupRelationsList.size() == 1) {
                Receiver[][] receiverArray = this._getReceivers(relation, occurrence, insideLink);
                return receiverArray;
            }
            Receiver[][][] results = new Receiver[groupRelationsList.size()][][];
            int index = 0;
            int width = 0;
            for (IORelation groupRelation : groupRelationsList) {
                Receiver[][] oneResult = this._getReceivers(groupRelation, occurrence, insideLink);
                results[index] = oneResult;
                ++index;
                if (oneResult == null || oneResult.length <= width) continue;
                width = oneResult.length;
            }
            Receiver[][] result = new Receiver[width][];
            for (int i = 0; i < width; ++i) {
                int j;
                int numberOfReplicas = 0;
                for (j = 0; j < results.length; ++j) {
                    if (results[j] == null || i >= results[j].length || results[j][i] == null) continue;
                    numberOfReplicas += results[j][i].length;
                }
                result[i] = new Receiver[numberOfReplicas];
                index = 0;
                for (j = 0; j < results.length; ++j) {
                    if (results[j] == null || i >= results[j].length || results[j][i] == null) continue;
                    for (int k = 0; k < results[j][i].length; ++k) {
                        result[i][index] = results[j][i][k];
                        ++index;
                    }
                }
            }
            Receiver[][] receiverArray = result;
            return receiverArray;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    protected Receiver _newInsideReceiver() throws IllegalActionException {
        CompositeActor castContainer;
        NamedObj container = this.getContainer();
        if (container instanceof CompositeActor && (castContainer = (CompositeActor)container).isOpaque() && !castContainer.isAtomic()) {
            Receiver receiver = castContainer.newInsideReceiver();
            receiver.setContainer(this);
            return receiver;
        }
        throw new IllegalActionException((Nameable)this, "Can only create inside receivers for a port of a non-atomic, opaque entity.");
    }

    protected Receiver _newReceiver() throws IllegalActionException {
        Actor container = (Actor)((Object)this.getContainer());
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Cannot create a receiver without a container.");
        }
        Receiver receiver = container.newReceiver();
        receiver.setContainer(this);
        return receiver;
    }

    protected void _removeReceivers(Relation relation) {
        List receivers;
        if (this._localReceiversTable != null && (receivers = (List)this._localReceiversTable.get(relation)) != null) {
            for (Receiver[][] receiverArray : receivers) {
                for (int i = 0; i < receiverArray.length; ++i) {
                    if (receiverArray[i] == null) continue;
                    for (int j = 0; j < receiverArray[i].length; ++j) {
                        if (receiverArray[i][j] == null) continue;
                        try {
                            receiverArray[i][j].setContainer(null);
                            continue;
                        }
                        catch (IllegalActionException e) {
                            throw new InternalErrorException(e);
                        }
                    }
                }
            }
        }
    }

    protected final void _notifyPortEventListeners(IOPortEvent event) {
        if (this._hasPortEventListeners) {
            Iterator listeners = this._portEventListeners.iterator();
            while (listeners.hasNext()) {
                ((IOPortEventListener)listeners.next()).portEvent(event);
            }
        }
    }

    private void _checkMultiportLink(IORelation relation) throws IllegalActionException {
        if (this._isInsideLinkable(relation.getContainer())) {
            if (!this.isMultiport() && this.numInsideLinks() >= 1) {
                throw new IllegalActionException((Nameable)this, relation, "Attempt to link more than one relation to a single port.");
            }
            if (relation.getWidth() != 1 || !relation.isWidthFixed()) {
                if (!this.isMultiport()) {
                    throw new IllegalActionException((Nameable)this, relation, "Attempt to link a bus relation to a single port.");
                }
                if (!relation.isWidthFixed()) {
                    try {
                        this._getInsideWidth(null);
                    }
                    catch (InvalidStateException ex) {
                        throw new IllegalActionException((Nameable)this, relation, "Attempt to link a second bus relation with unspecified width to the inside of a port.");
                    }
                }
            }
        } else {
            if (!this.isMultiport() && this.numLinks() >= 1) {
                throw new IllegalActionException((Nameable)this, relation, "Attempt to link more than one relation to a single port.");
            }
            if (relation.getWidth() != 1 || !relation.isWidthFixed()) {
                for (IORelation theRelation : this.linkedRelationList()) {
                    if (theRelation == null || theRelation.isWidthFixed()) continue;
                    throw new IllegalActionException((Nameable)this, relation, "Attempt to link a second bus relation with unspecified width to the outside of a port.");
                }
            }
        }
    }

    private Receiver[][] _getReceivers(IORelation relation, int occurrence, boolean insideLink) throws IllegalActionException {
        boolean opaque = this.isOpaque();
        if (!(this.isInput() || opaque && insideLink && this.isOutput())) {
            return _EMPTY_RECEIVER_ARRAY;
        }
        int width = relation.getWidth();
        if (this.getWidth() == 1 && width > 1) {
            width = 1;
        }
        if (width <= 0) {
            return _EMPTY_RECEIVER_ARRAY;
        }
        Receiver[][] result = null;
        if (opaque) {
            if (this._localReceiversTable == null) {
                return _EMPTY_RECEIVER_ARRAY;
            }
            if (this._localReceiversTable.containsKey(relation)) {
                List list = (List)this._localReceiversTable.get(relation);
                try {
                    result = (Receiver[][])list.get(occurrence);
                }
                catch (IndexOutOfBoundsException ex) {
                    return _EMPTY_RECEIVER_ARRAY;
                }
                if (result.length != width) {
                    throw new InvalidStateException(this, "getReceivers(IORelation, int): Invalid receivers. Need to call createReceivers().");
                }
            }
            return result;
        }
        Receiver[][] insideReceivers = this.getReceivers();
        if (insideReceivers == null) {
            return _EMPTY_RECEIVER_ARRAY;
        }
        int insideWidth = insideReceivers.length;
        int index = 0;
        result = new Receiver[width][];
        Iterator outsideRelations = this.linkedRelationList().iterator();
        int seen = 0;
        while (outsideRelations.hasNext()) {
            IORelation outsideRelation = (IORelation)outsideRelations.next();
            if (outsideRelation == null) continue;
            if (outsideRelation == relation) {
                if (seen == occurrence) {
                    result = new Receiver[width][];
                    int receiverSize = Math.min(width, insideWidth - index);
                    for (int i = 0; i < receiverSize; ++i) {
                        result[i] = insideReceivers[index++];
                    }
                    break;
                }
                ++seen;
                if ((index += outsideRelation.getWidth()) <= insideWidth) continue;
                break;
            }
            if ((index += outsideRelation.getWidth()) <= insideWidth) continue;
            break;
        }
        return result;
    }

    private void _invalidate() {
        Director director;
        NamedObj container = this.getContainer();
        if (container instanceof Actor && (director = ((Actor)((Object)container)).getDirector()) != null) {
            director.invalidateSchedule();
            director.invalidateResolvedTypes();
        }
    }
}

