/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import ptolemy.actor.gt.ParameterAttribute;
import ptolemy.actor.gt.Pattern;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.ValueListener;
import ptolemy.kernel.util.Workspace;

public class DefaultDirectoryAttribute
extends ParameterAttribute
implements ValueListener {
    public FileParameter directory;
    public StringParameter fileFilter;
    public Parameter subdirs;

    public DefaultDirectoryAttribute(NamedObj container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
    }

    public DefaultDirectoryAttribute(Workspace workspace) {
        super(workspace);
    }

    @Override
    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        super.setContainer(container);
        if (container != null) {
            this._checkContainerClass(container, Pattern.class, false);
            this._checkUniqueness(container);
        }
    }

    @Override
    public void valueChanged(Settable settable) {
        String display = this.directory.getExpression() + "/";
        String filter = this.fileFilter.getExpression();
        display = filter.equals("") ? display + "*.xml" : display + filter;
        try {
            if (this.subdirs.getToken().equals(BooleanToken.TRUE)) {
                display = display + " [...]";
            }
        }
        catch (IllegalActionException e) {
            // empty catch block
        }
        this.parameter.setExpression(display);
    }

    @Override
    protected void _initParameter() throws IllegalActionException, NameDuplicationException {
        this.parameter = new StringParameter(this, "display");
        this.parameter.setDisplayName("Display (./)");
        this.parameter.setPersistent(false);
        this.parameter.setVisibility(NONE);
        this.directory = new FileParameter(this, "directory");
        this.directory.setDisplayName("Directory");
        this.directory.setExpression(".");
        this.directory.addValueListener(this);
        Parameter allowFiles = new Parameter(this.directory, "allowFiles");
        allowFiles.setTypeEquals(BaseType.BOOLEAN);
        allowFiles.setToken(BooleanToken.FALSE);
        Parameter allowDirectories = new Parameter(this.directory, "allowDirectories");
        allowDirectories.setTypeEquals(BaseType.BOOLEAN);
        allowDirectories.setToken(BooleanToken.TRUE);
        this.fileFilter = new StringParameter(this, "filter");
        this.fileFilter.setDisplayName("File filter (*.xml)");
        this.fileFilter.setExpression("");
        this.fileFilter.addValueListener(this);
        this.subdirs = new Parameter(this, "subdirs");
        this.subdirs.setDisplayName("Include subdirs");
        this.subdirs.setTypeEquals(BaseType.BOOLEAN);
        this.subdirs.setExpression("true");
        this.subdirs.addValueListener(this);
    }
}

