/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.util.Arrays;
import java.util.Iterator;
import ptolemy.actor.gt.GTIngredientElement;
import ptolemy.actor.gt.GTIngredientList;
import ptolemy.actor.gt.ValidationException;
import ptolemy.kernel.util.KernelRuntimeException;

public abstract class GTIngredient {
    public static final String FIELD_SEPARATOR = "/";
    private boolean[] _enablements;
    private GTIngredientList _owner;

    public void disableAll() {
        Arrays.fill(this._enablements, false);
    }

    public void enableAll() {
        Arrays.fill(this._enablements, true);
    }

    public abstract GTIngredientElement[] getElements();

    public GTIngredientList getOwner() {
        return this._owner;
    }

    public abstract Object getValue(int var1);

    public abstract String getValues();

    public boolean isEnabled(int index) {
        if (!this.getElements()[index].canDisable()) {
            return true;
        }
        return this._enablements[index];
    }

    public void setEnabled(int index, boolean isEnabled) {
        this._enablements[index] = isEnabled;
    }

    public abstract void setValue(int var1, Object var2);

    public abstract void setValues(String var1);

    public String toString() {
        return this.getValues();
    }

    public abstract void validate() throws ValidationException;

    protected GTIngredient(GTIngredientList owner) {
        this._owner = owner;
    }

    protected GTIngredient(GTIngredientList owner, int elementCount) {
        this(owner);
        this._enablements = new boolean[elementCount];
        this.enableAll();
    }

    protected boolean _decodeBooleanField(int index, FieldIterator iterator) {
        this._enablements[index] = iterator.hasNext() ? Boolean.parseBoolean(iterator.next()) : false;
        return iterator.hasNext() ? Boolean.parseBoolean(iterator.next()) : false;
    }

    protected String _decodeStringField(int index, FieldIterator iterator) {
        this._enablements[index] = iterator.hasNext() ? Boolean.parseBoolean(iterator.next()) : false;
        return iterator.hasNext() ? GTIngredient._unescapeElementString(iterator.next()) : "";
    }

    protected void _encodeBooleanField(StringBuffer buffer, int index, boolean value) {
        if (buffer.length() > 0) {
            buffer.append(FIELD_SEPARATOR);
        }
        buffer.append(this._enablements[index]);
        buffer.append(FIELD_SEPARATOR);
        buffer.append(value);
    }

    protected void _encodeStringField(StringBuffer buffer, int index, String value) {
        if (buffer.length() > 0) {
            buffer.append(FIELD_SEPARATOR);
        }
        buffer.append(this._enablements[index]);
        buffer.append(FIELD_SEPARATOR);
        buffer.append(GTIngredient._escapeElementString(value));
    }

    protected static String _escapeElementString(String elementString) {
        if (elementString.equals("")) {
            return "";
        }
        elementString = elementString.replace("\\", "\\\\");
        elementString = elementString.replace("\"", "\\\"");
        elementString = elementString.replace("'", "\\'");
        return "\"" + elementString + "\"";
    }

    protected static int _findMatchingParen(String s, int startPos) {
        if (s.charAt(startPos) == '(') {
            int parenNum = 1;
            boolean inDblQuote = false;
            boolean inSngQuote = false;
            boolean escaped = false;
            for (int i = startPos + 1; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\\' && (inDblQuote || inSngQuote)) {
                    escaped = !escaped;
                } else if (c == '\"' && !escaped) {
                    inDblQuote = !inDblQuote;
                } else if (c == '\'' && !inDblQuote && !escaped) {
                    inSngQuote = !inSngQuote;
                } else if (c == ')' && !inDblQuote && !inSngQuote) {
                    --parenNum;
                }
                if (c != '\\') {
                    escaped = false;
                }
                if (parenNum != 0) continue;
                return i;
            }
        }
        return -1;
    }

    protected static int _findSeparator(String s, int startPos, char separator) {
        boolean inDblQuote = false;
        boolean inSngQuote = false;
        boolean escaped = false;
        for (int i = startPos; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && (inDblQuote || inSngQuote)) {
                escaped = !escaped;
            } else if (c == '\"' && !escaped) {
                inDblQuote = !inDblQuote;
            } else if (c == '\'' && !inDblQuote && !escaped) {
                inSngQuote = !inSngQuote;
            } else if (c == separator && !inDblQuote && !inSngQuote) {
                return i;
            }
            if (c == '\\') continue;
            escaped = false;
        }
        return -1;
    }

    protected static String _unescapeElementString(String elementString) {
        if (elementString.equals("")) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(elementString);
        buffer.deleteCharAt(0);
        buffer.deleteCharAt(buffer.length() - 1);
        for (int i = 0; i < buffer.length(); ++i) {
            if (buffer.charAt(i) != '\\') continue;
            buffer.deleteCharAt(i);
        }
        return buffer.toString();
    }

    protected static class FieldIterator
    implements Iterator<String> {
        private String _values;

        public FieldIterator(String values) {
            this._values = values;
        }

        @Override
        public boolean hasNext() {
            return this._values != null && this._values.length() > 0;
        }

        @Override
        public String next() {
            String next;
            int position = this._values.indexOf(GTIngredient.FIELD_SEPARATOR);
            if (position < 0) {
                next = this._values;
                this._values = null;
            } else {
                next = this._values.substring(0, position);
                this._values = this._values.substring(position + 1);
            }
            return next;
        }

        @Override
        public void remove() {
            throw new KernelRuntimeException();
        }
    }

    public static enum NamedObjMatchResult {
        MATCH,
        NOT_MATCH,
        UNAPPLICABLE;

    }
}

