/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TwoWayHashMap<K, V>
extends HashMap<K, V> {
    private HashMap<V, K> _reverseMap = new HashMap();

    public TwoWayHashMap() {
    }

    public TwoWayHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TwoWayHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TwoWayHashMap(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this._reverseMap.clear();
    }

    @Override
    public Object clone() {
        TwoWayHashMap map = (TwoWayHashMap)super.clone();
        map._reverseMap = new HashMap<K, V>(this._reverseMap);
        return map;
    }

    @Override
    public boolean containsValue(Object value) {
        return this._reverseMap.containsKey(value);
    }

    public K getKey(Object value) {
        return this._reverseMap.get(value);
    }

    @Override
    public V put(K key, V value) {
        V oldValue = super.put(key, value);
        this._reverseMap.put(value, key);
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        Object oldValue = super.remove(key);
        if (oldValue != null) {
            this._reverseMap.remove(oldValue);
        }
        return oldValue;
    }

    @Override
    public Set<V> values() {
        return Collections.unmodifiableSet(this._reverseMap.keySet());
    }
}

