/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt.ingredients.criteria;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gt.GTIngredient;
import ptolemy.actor.gt.GTIngredientElement;
import ptolemy.actor.gt.GTIngredientList;
import ptolemy.actor.gt.ValidationException;
import ptolemy.actor.gt.ingredients.criteria.BooleanCriterionElement;
import ptolemy.actor.gt.ingredients.criteria.ChoiceCriterionElement;
import ptolemy.actor.gt.ingredients.criteria.Criterion;
import ptolemy.actor.gt.ingredients.criteria.CriterionElement;
import ptolemy.actor.gt.ingredients.criteria.StringCriterionElement;
import ptolemy.actor.gt.util.PtolemyExpressionString;
import ptolemy.actor.gt.util.RegularExpressionString;
import ptolemy.data.expr.Constants;
import ptolemy.data.type.Type;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;

public class PortCriterion
extends Criterion {
    private static final CriterionElement[] _ELEMENTS = new CriterionElement[]{new StringCriterionElement("name", true, true, false), new ChoiceCriterionElement("type", true, false, true, true), new BooleanCriterionElement("input", true), new BooleanCriterionElement("output", true), new BooleanCriterionElement("multi", true), new StringCriterionElement("matcherName", true, false, false)};
    private boolean _input;
    private String _matcherName;
    private boolean _multiport;
    private boolean _output;
    private RegularExpressionString _portName;
    private PtolemyExpressionString _portType;

    public PortCriterion(GTIngredientList owner) {
        this(owner, "");
    }

    public PortCriterion(GTIngredientList owner, String values) {
        this(owner, null, null, false, false, false, "");
        this.setValues(values);
    }

    public PortCriterion(GTIngredientList owner, String portName, String portType, boolean input, boolean output, boolean multiport, String matcherName) {
        super(owner, 6);
        NamedObj container = owner.getOwner().getContainer();
        this._portName = new RegularExpressionString(portName);
        this._portType = new PtolemyExpressionString(container, portType);
        this._input = input;
        this._output = output;
        this._multiport = multiport;
        this._matcherName = matcherName;
    }

    @Override
    public GTIngredientElement[] getElements() {
        return _ELEMENTS;
    }

    public String getMatcherName() {
        return this._matcherName;
    }

    public String getPortID(GTIngredientList list) {
        if (!this.isMatcherNameEnabled() || this._matcherName.equals("")) {
            int position = list.indexOf(this);
            return this._getUniqueName(list, "criterion" + (position + 1));
        }
        return this._getUniqueName(list, this._matcherName);
    }

    public String getPortName() {
        return this._portName.get();
    }

    public String getPortType() {
        return this._portType.get();
    }

    @Override
    public Object getValue(int index) {
        switch (index) {
            case 0: {
                return this._portName;
            }
            case 1: {
                return this._portType;
            }
            case 2: {
                return this._input;
            }
            case 3: {
                return this._output;
            }
            case 4: {
                return this._multiport;
            }
            case 5: {
                return this._matcherName;
            }
        }
        return null;
    }

    @Override
    public String getValues() {
        StringBuffer buffer = new StringBuffer();
        this._encodeStringField(buffer, 0, this._portName.get());
        this._encodeStringField(buffer, 1, this._portType.get());
        this._encodeBooleanField(buffer, 2, this._input);
        this._encodeBooleanField(buffer, 3, this._output);
        this._encodeBooleanField(buffer, 4, this._multiport);
        this._encodeStringField(buffer, 5, this._matcherName);
        return buffer.toString();
    }

    public boolean isInput() {
        return this._input;
    }

    public boolean isInputEnabled() {
        return this.isEnabled(2);
    }

    public boolean isMatcherNameEnabled() {
        return this.isEnabled(5);
    }

    public boolean isMultiport() {
        return this._multiport;
    }

    public boolean isMultiportEnabled() {
        return this.isEnabled(4);
    }

    public boolean isOutput() {
        return this._output;
    }

    public boolean isOutputEnabled() {
        return this.isEnabled(3);
    }

    public boolean isPortNameEnabled() {
        return this.isEnabled(0);
    }

    public boolean isPortTypeEnabled() {
        return this.isEnabled(1);
    }

    @Override
    public GTIngredient.NamedObjMatchResult match(NamedObj object) {
        Pattern pattern;
        Matcher matcher;
        if (object instanceof IOPort) {
            IOPort port = (IOPort)object;
            if (this.isInputEnabled() && this._input != port.isInput()) {
                return GTIngredient.NamedObjMatchResult.NOT_MATCH;
            }
            if (this.isOutputEnabled() && this._output != port.isOutput()) {
                return GTIngredient.NamedObjMatchResult.NOT_MATCH;
            }
            if (this.isMultiportEnabled() && this._multiport != port.isMultiport()) {
                return GTIngredient.NamedObjMatchResult.NOT_MATCH;
            }
        } else if (object instanceof Port) {
            if (this.isInputEnabled() || this.isOutputEnabled() || this.isMultiportEnabled()) {
                return GTIngredient.NamedObjMatchResult.NOT_MATCH;
            }
        } else {
            return GTIngredient.NamedObjMatchResult.UNAPPLICABLE;
        }
        if (this.isPortNameEnabled() && !(matcher = (pattern = this._portName.getPattern()).matcher(object.getName())).matches()) {
            return GTIngredient.NamedObjMatchResult.NOT_MATCH;
        }
        if (this.isPortTypeEnabled() && object instanceof TypedIOPort) {
            TypedIOPort typedIOPort = (TypedIOPort)object;
            try {
                Type lhsType = this._portType.getToken().getType();
                Type hostType = typedIOPort.getType();
                boolean isTypeCompatible = true;
                if (this.isInputEnabled() && this._input) {
                    boolean bl = isTypeCompatible = isTypeCompatible && hostType.isCompatible(lhsType);
                }
                if (this.isOutputEnabled() && this._output) {
                    boolean bl = isTypeCompatible = isTypeCompatible && lhsType.isCompatible(hostType);
                }
                if (!isTypeCompatible) {
                    return GTIngredient.NamedObjMatchResult.NOT_MATCH;
                }
            }
            catch (IllegalActionException e) {
                return GTIngredient.NamedObjMatchResult.NOT_MATCH;
            }
        }
        return GTIngredient.NamedObjMatchResult.MATCH;
    }

    public void setInputEnabled(boolean enabled) {
        this.setEnabled(2, enabled);
    }

    public void setMatcherNameEnabled(boolean enabled) {
        this.setEnabled(5, enabled);
    }

    public void setMultiportEnabled(boolean enabled) {
        this.setEnabled(4, enabled);
    }

    public void setOutputEnabled(boolean enabled) {
        this.setEnabled(3, enabled);
    }

    public void setPortNameEnabled(boolean enabled) {
        this.setEnabled(0, enabled);
    }

    public void setPortTypeEnabled(boolean enabled) {
        this.setEnabled(1, enabled);
    }

    @Override
    public void setValue(int index, Object value) {
        switch (index) {
            case 0: {
                this._portName.set((String)value);
                break;
            }
            case 1: {
                this._portType.set((String)value);
                break;
            }
            case 2: {
                this._input = (Boolean)value;
                break;
            }
            case 3: {
                this._output = (Boolean)value;
                break;
            }
            case 4: {
                this._multiport = (Boolean)value;
                break;
            }
            case 5: {
                this._matcherName = (String)value;
            }
        }
    }

    @Override
    public void setValues(String values) {
        GTIngredient.FieldIterator fieldIterator = new GTIngredient.FieldIterator(values);
        this._portName.set(this._decodeStringField(0, fieldIterator));
        this._portType.set(this._decodeStringField(1, fieldIterator));
        this._input = this._decodeBooleanField(2, fieldIterator);
        this._output = this._decodeBooleanField(3, fieldIterator);
        this._multiport = this._decodeBooleanField(4, fieldIterator);
        this._matcherName = this._decodeStringField(5, fieldIterator);
    }

    @Override
    public void validate() throws ValidationException {
        if (this.isPortNameEnabled()) {
            if (this._portName.get().equals("")) {
                throw new ValidationException("Port name must not be empty.");
            }
            try {
                this._portName.getPattern();
            }
            catch (PatternSyntaxException e) {
                throw new ValidationException("Regular expression \"" + this._portName + "\" cannot be compiled.", e);
            }
        }
        if (this.isPortTypeEnabled()) {
            if (this._portType.get().equals("")) {
                throw new ValidationException("Port type must not be empty.");
            }
            try {
                this._portType.getToken().getType();
            }
            catch (IllegalActionException e) {
                throw new ValidationException("Type expression \"" + this._portType + "\" cannot be parsed.", e);
            }
        }
    }

    private String _getUniqueName(GTIngredientList list, String name) {
        int pos = 1;
        String id = null;
        boolean success = false;
        block0: while (!success) {
            GTIngredient ingredient;
            success = true;
            id = pos >= 2 ? name + pos : name;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (ingredient = (GTIngredient)iterator.next()) != this) {
                PortCriterion portCriterion;
                String portId;
                if (!(ingredient instanceof PortCriterion) || !(portId = (portCriterion = (PortCriterion)ingredient).getPortID(list)).equals(id)) continue;
                success = false;
                continue block0;
            }
        }
        return id;
    }

    static {
        ChoiceCriterionElement portTypes = (ChoiceCriterionElement)_ELEMENTS[1];
        portTypes.addChoices(Constants.types().keySet());
        portTypes.addChoice("arrayType(int)");
        portTypes.addChoice("arrayType(int,5)");
        portTypes.addChoice("[double]");
        portTypes.addChoice("{x=double, y=double}");
    }
}

