/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt.ingredients.operations;

import ptolemy.actor.gt.GTIngredient;
import ptolemy.actor.gt.GTIngredientElement;
import ptolemy.actor.gt.GTIngredientList;
import ptolemy.actor.gt.GTParameter;
import ptolemy.actor.gt.NamedObjVariable;
import ptolemy.actor.gt.Pattern;
import ptolemy.actor.gt.Replacement;
import ptolemy.actor.gt.ValidationException;
import ptolemy.actor.gt.data.MatchResult;
import ptolemy.actor.gt.ingredients.operations.Operation;
import ptolemy.actor.gt.ingredients.operations.OperationElement;
import ptolemy.actor.gt.ingredients.operations.StringOperationElement;
import ptolemy.actor.gt.util.PtolemyExpressionString;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtLeafNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ASTPtSumNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParseTreeWriter;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.expr.PtParser;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.StringUtilities;

public class AttributeOperation
extends Operation {
    private static final OperationElement[] _ELEMENTS = new OperationElement[]{new StringOperationElement("name", false, false), new StringOperationElement("type", true, false), new StringOperationElement("value", false, true)};
    private String _attributeClass;
    private String _attributeName;
    private PtolemyExpressionString _attributeValue;
    private ParseTreeWriter _parseTreeWriter = new ParseTreeWriter();
    private PtParser _parser = new PtParser();
    private ASTPtRootNode _valueParseTree;

    public AttributeOperation(GTIngredientList owner) {
        this(owner, "");
    }

    public AttributeOperation(GTIngredientList owner, String values) {
        this(owner, null, null, null);
        this.setValues(values);
    }

    public AttributeOperation(GTIngredientList owner, String attributeName, String attributeClass, String attributeValue) {
        super(owner, 3);
        NamedObj container = owner.getOwner().getContainer();
        this._attributeName = attributeName;
        this._attributeClass = attributeClass;
        this._attributeValue = new PtolemyExpressionString(container, attributeValue);
    }

    @Override
    public ChangeRequest getChangeRequest(Pattern pattern, Replacement replacement, MatchResult matchResult, Entity patternEntity, Entity replacementEntity, Entity hostEntity) throws IllegalActionException {
        String expression;
        String attributeClass;
        if (this._valueParseTree == null) {
            this._reparse();
        }
        if (this.isAttributeClassEnabled()) {
            attributeClass = this._attributeClass;
        } else {
            Attribute oldAttribute = hostEntity.getAttribute(this._attributeName);
            if (oldAttribute == null) {
                throw new IllegalActionException("Unable to determine the class of attribute " + this._attributeName + " for entity " + hostEntity + ".");
            }
            attributeClass = oldAttribute.getClassName();
        }
        ParserScope scope = NamedObjVariable.getNamedObjVariable(hostEntity, true).getParserScope();
        GTParameter.Evaluator evaluator = new GTParameter.Evaluator(pattern, matchResult);
        if (this._valueParseTree instanceof ASTPtSumNode) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this._valueParseTree.jjtGetNumChildren(); ++i) {
                ASTPtRootNode child = (ASTPtRootNode)this._valueParseTree.jjtGetChild(i);
                if (!child.isConstant() || !(child.getToken() instanceof StringToken)) {
                    ASTPtLeafNode newNode = this._evaluate(child, evaluator, scope);
                    buffer.append(this._parseTreeWriter.parseTreeToExpression(newNode));
                    continue;
                }
                buffer.append(((StringToken)child.getToken()).stringValue());
            }
            expression = buffer.toString();
        } else if (!this._valueParseTree.isConstant() || !(this._valueParseTree.getToken() instanceof StringToken)) {
            ASTPtLeafNode newRoot = this._evaluate(this._valueParseTree, evaluator, scope);
            expression = this._parseTreeWriter.parseTreeToExpression(newRoot);
        } else {
            expression = this._attributeValue.get();
        }
        String moml = "<property name=\"" + this._attributeName + "\" class=\"" + attributeClass + "\" value=\"" + StringUtilities.escapeForXML(expression) + "\"/>";
        return new MoMLChangeRequest(this, hostEntity, moml, null);
    }

    @Override
    public GTIngredientElement[] getElements() {
        return _ELEMENTS;
    }

    @Override
    public Object getValue(int index) {
        switch (index) {
            case 0: {
                return this._attributeName;
            }
            case 1: {
                return this._attributeClass;
            }
            case 2: {
                return this._attributeValue;
            }
        }
        return null;
    }

    @Override
    public String getValues() {
        StringBuffer buffer = new StringBuffer();
        this._encodeStringField(buffer, 0, this._attributeName);
        this._encodeStringField(buffer, 1, this._attributeClass);
        this._encodeStringField(buffer, 2, this._attributeValue.get());
        return buffer.toString();
    }

    public boolean isAttributeClassEnabled() {
        return this.isEnabled(1);
    }

    public boolean isAttributeNameEnabled() {
        return this.isEnabled(0);
    }

    public boolean isAttributeValueEnabled() {
        return this.isEnabled(2);
    }

    public void setAttributeClass(String attributeClass) {
        this._attributeClass = attributeClass;
    }

    public void setAttributeName(String attributeName) {
        this._attributeName = attributeName;
    }

    public void setAttributeValue(String attributeValue) {
        this._attributeValue.set(attributeValue);
        this._valueParseTree = null;
    }

    @Override
    public void setValue(int index, Object value) {
        switch (index) {
            case 0: {
                this._attributeName = (String)value;
                break;
            }
            case 1: {
                this._attributeClass = (String)value;
                break;
            }
            case 2: {
                this.setAttributeValue((String)value);
            }
        }
    }

    @Override
    public void setValues(String values) {
        GTIngredient.FieldIterator fieldIterator = new GTIngredient.FieldIterator(values);
        this._attributeName = this._decodeStringField(0, fieldIterator);
        this._attributeClass = this._decodeStringField(1, fieldIterator);
        this.setAttributeValue(this._decodeStringField(2, fieldIterator));
    }

    @Override
    public void validate() throws ValidationException {
        if (this._attributeName.equals("")) {
            throw new ValidationException("Name must not be empty.");
        }
        if (this._attributeName.contains(".")) {
            throw new ValidationException("Name must not have period (\".\") in it.");
        }
        if (this.isAttributeClassEnabled()) {
            if (this._attributeClass.equals("")) {
                throw new ValidationException("Class must not be empty.");
            }
            try {
                Class.forName(this._attributeClass);
            }
            catch (Throwable t) {
                throw new ValidationException("Cannot load class \"" + this._attributeClass + "\".", t);
            }
        }
        if (this._valueParseTree == null) {
            try {
                this._reparse();
            }
            catch (IllegalActionException e) {
                throw new ValidationException("Unable to parse attribute value.");
            }
        }
    }

    protected void _reparse() throws IllegalActionException {
        this._valueParseTree = this._parser.generateStringParseTree(this._attributeValue.get());
    }

    private ASTPtLeafNode _evaluate(ASTPtRootNode node, ParseTreeEvaluator evaluator, ParserScope scope) throws IllegalActionException {
        Token token = evaluator.evaluateParseTree(node, scope);
        ASTPtLeafNode newNode = new ASTPtLeafNode(4);
        newNode.setToken(token);
        newNode.setType(token.getType());
        newNode.setConstant(true);
        return newNode;
    }
}

