/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.ApplicationConfigurer;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.EffigyFactory;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.graph.Inequality;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.InstantiableNamedObj;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;

public class Configuration
extends CompositeEntity
implements ApplicationConfigurer {
    public static final String _DIRECTORY_NAME = "directory";
    private static List _configurations = new LinkedList();

    public Configuration(Workspace workspace) {
        super(workspace);
        _configurations.add(this);
    }

    public String check() throws Exception {
        StringBuffer results = new StringBuffer();
        Configuration cloneConfiguration = (Configuration)this.clone();
        List entityList = this.allAtomicEntityList();
        for (Object entity : entityList) {
            if (!(entity instanceof TypedAtomicActor)) continue;
            TypedAtomicActor actor = (TypedAtomicActor)entity;
            String fullName = actor.getName(this);
            TypedAtomicActor clone = (TypedAtomicActor)cloneConfiguration.getEntity(fullName);
            if (clone == null) {
                results.append("Actor " + fullName + " was not cloned!");
                continue;
            }
            List constraints = actor.typeConstraintList();
            List cloneConstraints = clone.typeConstraintList();
            if (constraints.size() != cloneConstraints.size()) {
                results.append(actor.getFullName() + " has " + constraints.size() + " constraints that " + "differ from " + cloneConstraints.size() + " constraints its clone has.\n");
            }
            StringBuffer constraintsDescription = new StringBuffer();
            try {
                for (Inequality constraint : constraints) {
                    constraintsDescription.append(constraint.toString());
                }
            }
            catch (Throwable throwable) {
                throw new IllegalActionException((Nameable)actor, throwable, "Failed to iterate through constraints.");
            }
            StringBuffer cloneConstraintsDescription = new StringBuffer();
            for (Inequality constraint : cloneConstraints) {
                cloneConstraintsDescription.append(constraint.toString());
            }
            if (!constraintsDescription.toString().equals(cloneConstraintsDescription.toString())) {
                results.append(actor.getFullName() + " and its clone do " + "not have the same constraints:\n" + constraintsDescription.toString() + "\nClone:\n" + cloneConstraintsDescription.toString() + "\n");
            }
            for (Inequality constraint : cloneConstraints) {
                InequalityTerm greaterTerm = constraint.getGreaterTerm();
                InequalityTerm lesserTerm = constraint.getLesserTerm();
                Object greaterAssociatedObject = greaterTerm.getAssociatedObject();
                Object lesserAssociatedObject = lesserTerm.getAssociatedObject();
                if (!(greaterAssociatedObject instanceof NamedObj) || !(lesserAssociatedObject instanceof NamedObj)) continue;
                NamedObj greaterNamedObj = (NamedObj)greaterAssociatedObject;
                NamedObj lesserNamedObj = (NamedObj)lesserAssociatedObject;
                if (greaterNamedObj == null || lesserNamedObj == null || greaterNamedObj.getContainer() == lesserNamedObj.getContainer()) continue;
                results.append(clone.getFullName() + " has type constraints with " + "associated objects that don't have " + "the same container:\n" + greaterNamedObj.getFullName() + " has a container:\n" + greaterNamedObj.getContainer() + "\n" + lesserNamedObj.getFullName() + " has a container:\n" + lesserNamedObj.getContainer() + "\n" + "This can occur if the clone(Workspace) " + "method is not present or does not set " + "the constraints like the constructor " + "does or if a Parameter or Port is not " + "declared public.\n");
            }
        }
        return results.toString();
    }

    public static List configurations() {
        return _configurations;
    }

    public Tableau createPrimaryTableau(Effigy effigy) {
        block19: {
            NamedObj model;
            TableauFactory factory = null;
            if (effigy instanceof PtolemyEffigy && (model = ((PtolemyEffigy)effigy).getModel()) != null) {
                Iterator factories = model.attributeList(TableauFactory.class).iterator();
                while (factories.hasNext() && factory == null) {
                    factory = (TableauFactory)factories.next();
                    try {
                        Tableau tableau = factory.createTableau(effigy);
                        if (tableau == null) continue;
                        if (effigy.masterEffigy() == effigy) {
                            tableau.setMaster(true);
                        }
                        tableau.setEditable(effigy.isModifiable());
                        tableau.show();
                        return tableau;
                    }
                    catch (Exception ex) {
                        factory = null;
                    }
                }
            }
            if ((factory = (TableauFactory)this.getAttribute("tableauFactory")) != null) {
                try {
                    Tableau tableau = factory.createTableau(effigy);
                    if (tableau == null) {
                        throw new Exception("Tableau factory returns null.");
                    }
                    if (effigy.getContainer() instanceof ModelDirectory) {
                        tableau.setMaster(true);
                    }
                    tableau.setEditable(effigy.isModifiable());
                    tableau.show();
                    return tableau;
                }
                catch (Exception ex) {
                    boolean calledMessageHandler = false;
                    try {
                        if (effigy.getContainer() instanceof ModelDirectory) {
                            if (effigy instanceof PtolemyEffigy) {
                                MessageHandler.error("Failed to open " + ((PtolemyEffigy)effigy).getModel().getFullName(), ex);
                                calledMessageHandler = true;
                            } else {
                                MessageHandler.error("Failed to open " + effigy.identifier.getExpression(), ex);
                                calledMessageHandler = true;
                            }
                        }
                        effigy.setContainer(null);
                    }
                    catch (Throwable throwable) {
                        calledMessageHandler = false;
                        throw new InternalErrorException(this, throwable, null);
                    }
                    if (effigy instanceof PtolemyEffigy) {
                        NamedObj object = ((PtolemyEffigy)effigy).getModel();
                        String filename = StringUtilities.objectToSourceFileName(object);
                        try {
                            URL toRead = this.getClass().getClassLoader().getResource(filename);
                            if (toRead != null) {
                                return this.openModel(null, toRead, toRead.toExternalForm());
                            }
                            MessageHandler.error("Cannot find a tableau or the source code for " + object.getFullName());
                        }
                        catch (Exception exception) {
                            MessageHandler.error("Failed to open the source code for " + object.getFullName(), exception);
                        }
                    }
                    if (calledMessageHandler) break block19;
                    MessageHandler.error("Failed to open tableau for " + effigy.identifier.getExpression(), ex);
                }
            }
        }
        return null;
    }

    public static Effigy findEffigy(NamedObj model) {
        for (Configuration configuration : _configurations) {
            PtolemyEffigy effigy = configuration.getEffigy(model);
            if (effigy == null) continue;
            return effigy;
        }
        return null;
    }

    public ModelDirectory getDirectory() {
        ComponentEntity directory = this.getEntity(_DIRECTORY_NAME);
        if (directory instanceof ModelDirectory) {
            return (ModelDirectory)directory;
        }
        return null;
    }

    public PtolemyEffigy getEffigy(NamedObj model) {
        ComponentEntity directory = this.getEntity(_DIRECTORY_NAME);
        if (directory instanceof ModelDirectory) {
            return this._findEffigyForModel((ModelDirectory)directory, model);
        }
        return null;
    }

    public Tableau openInstance(NamedObj entity) throws IllegalActionException, NameDuplicationException {
        return this.openInstance(entity, null);
    }

    public Tableau openInstance(NamedObj entity, CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        return this._openModel(entity, container);
    }

    public Tableau openModel(URL base, URL in, String identifier) throws Exception {
        return this.openModel(base, in, identifier, null);
    }

    public Tableau openModel(URL base, URL in, String identifier, EffigyFactory factory) throws Exception {
        ModelDirectory directory = (ModelDirectory)this.getEntity(_DIRECTORY_NAME);
        if (directory == null) {
            throw new InternalErrorException("No model directory!");
        }
        Effigy effigy = directory.getEffigy(identifier);
        if (effigy == null) {
            if (factory == null) {
                factory = (EffigyFactory)this.getEntity("effigyFactory");
            }
            if (factory == null) {
                throw new InternalErrorException("No effigy factories in the configuration!");
            }
            effigy = factory.createEffigy(directory, base, in);
            if (effigy == null) {
                MessageHandler.error("Unsupported file type or connection not available: " + in.toExternalForm());
                return null;
            }
            if (effigy.identifier.getExpression().compareTo("Unnamed") == 0) {
                effigy.identifier.setExpression(identifier);
            }
            if (in != null && in.getProtocol().equals("file")) {
                String filename = in.getFile();
                File file = new File(filename);
                try {
                    if (!file.canWrite() && !(file = new File(filename = StringUtilities.substitute(filename, "%20", " "))).canWrite()) {
                        effigy.setModifiable(false);
                    }
                }
                catch (AccessControlException accessControl) {
                    effigy.setModifiable(false);
                }
            } else {
                effigy.setModifiable(false);
            }
            return this.createPrimaryTableau(effigy);
        }
        return effigy.showTableaux();
    }

    public Tableau openModel(NamedObj entity) throws IllegalActionException, NameDuplicationException {
        return this.openModel(entity, null);
    }

    public Tableau openModel(NamedObj entity, CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        InstantiableNamedObj deferredTo = null;
        boolean isClass = false;
        if (entity instanceof InstantiableNamedObj) {
            deferredTo = (InstantiableNamedObj)((InstantiableNamedObj)entity).getParent();
            isClass = ((InstantiableNamedObj)entity).isClassDefinition();
        }
        if (deferredTo != null && !isClass) {
            entity = deferredTo;
        }
        return this._openModel(entity, container);
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException {
        if (container != null) {
            throw new IllegalActionException((Nameable)this, "Configuration can only be at the top level of a hierarchy.");
        }
    }

    public void showAll() {
        ModelDirectory directory = (ModelDirectory)this.getEntity(_DIRECTORY_NAME);
        if (directory == null) {
            return;
        }
        this._showTableaux(directory);
    }

    @Override
    protected void _removeEntity(ComponentEntity entity) {
        super._removeEntity(entity);
        if (entity.getName().equals(_DIRECTORY_NAME)) {
            StringUtilities.exit(0);
        }
    }

    private String _effigyIdentifier(Effigy effigy, NamedObj entity) {
        NamedObj parent = effigy.getContainer();
        if (!(parent instanceof Effigy)) {
            return effigy.getFullName();
        }
        Effigy parentEffigy = (Effigy)parent;
        String entityName = parentEffigy.identifier.getExpression();
        String separator = "#";
        if (entityName.indexOf("#") >= 0) {
            separator = ".";
        }
        return entityName + separator + entity.getName();
    }

    private PtolemyEffigy _findEffigyForModel(CompositeEntity composite, NamedObj model) {
        if (composite != null) {
            for (PtolemyEffigy effigy : composite.entityList(PtolemyEffigy.class)) {
                if (effigy.getModel() == model) {
                    return effigy;
                }
                PtolemyEffigy inside = this._findEffigyForModel(effigy, model);
                if (inside == null) continue;
                return inside;
            }
        }
        return null;
    }

    private Tableau _openModel(NamedObj entity, CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        PtolemyEffigy effigy = this.getEffigy(entity);
        if (effigy != null) {
            return effigy.showTableaux();
        }
        effigy = new PtolemyEffigy(this.workspace());
        effigy.setModel(entity);
        List attributes = entity.attributeList(URIAttribute.class);
        if (attributes.size() > 0) {
            URI uri = ((URIAttribute)attributes.get(0)).getURI();
            effigy.uri.setURI(uri);
            if (uri == null) {
                effigy.identifier.setExpression(this._effigyIdentifier(effigy, entity));
            } else {
                effigy.identifier.setExpression(uri.toString());
            }
            if (container == null) {
                ModelDirectory directory = this.getDirectory();
                effigy.setName(directory.uniqueName(entity.getName()));
                effigy.setContainer(directory);
            } else {
                effigy.setName(container.uniqueName(entity.getName()));
                effigy.setContainer(container);
            }
            return this.createPrimaryTableau(effigy);
        }
        PtolemyEffigy parentEffigy = null;
        for (NamedObj parent = entity.getContainer(); parent != null && parentEffigy == null; parent = parent.getContainer()) {
            parentEffigy = this.getEffigy(parent);
        }
        boolean isContainerSet = false;
        if (parentEffigy != null) {
            effigy.setName(parentEffigy.uniqueName(entity.getName()));
            effigy.setContainer(parentEffigy);
            effigy.uri.setURI(parentEffigy.uri.getURI());
            isContainerSet = true;
        }
        if (!isContainerSet) {
            if (container == null) {
                ModelDirectory directory = this.getDirectory();
                effigy.setName(directory.uniqueName(entity.getName()));
                effigy.setContainer(directory);
            } else {
                effigy.setName(container.uniqueName(entity.getName()));
                effigy.setContainer(container);
            }
        }
        effigy.identifier.setExpression(this._effigyIdentifier(effigy, entity));
        return this.createPrimaryTableau(effigy);
    }

    private void _showTableaux(CompositeEntity container) {
        for (Object entity : container.entityList()) {
            if (entity instanceof Tableau) {
                ((Tableau)entity).show();
                continue;
            }
            if (!(entity instanceof CompositeEntity)) continue;
            this._showTableaux((CompositeEntity)entity);
        }
    }
}

