/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;
import ptolemy.actor.gui.BrowserEffigy;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.HTMLAbout;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.gui.Top;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.basic.GetDocumentationAction;

public class HTMLViewer
extends TableauFrame
implements Printable,
HyperlinkListener {
    public JEditorPane pane = new JEditorPane();
    protected JScrollPane _scroller;
    private URL _base;
    private static URL _styleSheetURL;

    public HTMLViewer() {
        this._init();
    }

    public HTMLViewer(Tableau tableau) {
        super(tableau);
        this._init();
    }

    public URL getPage() {
        return this.pane.getPage();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            if (event.getURL() != null) {
                this.report(event.getURL().toString());
            } else if (event.getDescription() != null) {
                this.report(event.getDescription());
            }
        } else if (event.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.report("");
        } else if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL newURL = event.getURL();
            if (event.getDescription().startsWith("about:")) {
                try {
                    newURL = HTMLAbout.hyperlinkUpdate(event, this.getConfiguration());
                }
                catch (Throwable throwable) {
                    MessageHandler.error("Problem processing '" + event.getDescription() + "'.", throwable);
                }
            }
            if (event.getDescription().startsWith("ptdoc:")) {
                try {
                    GetDocumentationAction.getDocumentation((Configuration)this.getConfiguration(), (String)event.getDescription().substring(6), (Effigy)this.getEffigy());
                }
                catch (Throwable throwable) {
                    MessageHandler.error("Problem processing '" + event.getDescription() + "'.", throwable);
                }
            }
            boolean useBrowser = false;
            if (newURL != null) {
                String protocol;
                String ref = newURL.getRef();
                if (ref != null) {
                    useBrowser = ref.equals("in_browser");
                }
                if ((protocol = newURL.getProtocol()) != null) {
                    useBrowser |= protocol.equals("mailto");
                }
            } else {
                try {
                    newURL = new URL(this._base, event.getDescription());
                }
                catch (MalformedURLException e) {
                    this.report("Link error: " + event.getDescription());
                    return;
                }
            }
            if (!useBrowser && event instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent frameHyperlinkEvent = (HTMLFrameHyperlinkEvent)event;
                String target = frameHyperlinkEvent.getTarget();
                if (target.equals("_browser")) {
                    useBrowser = true;
                } else if (!target.equals("_blank") && !target.equals("_top")) {
                    HTMLDocument doc = (HTMLDocument)this.pane.getDocument();
                    try {
                        doc.processHTMLFrameHyperlinkEvent(frameHyperlinkEvent);
                    }
                    catch (Exception ex) {
                        MessageHandler.error("Hyperlink reference failed", ex);
                    }
                    return;
                }
            }
            try {
                if (this.getPage() != null && newURL.getFile().equals(this.getPage().getFile())) {
                    this.pane.setPage(newURL);
                } else {
                    Configuration configuration = this.getConfiguration();
                    if (configuration != null) {
                        if (useBrowser && BrowserEffigy.staticFactory != null) {
                            configuration.openModel(newURL, newURL, newURL.toExternalForm(), BrowserEffigy.staticFactory);
                        } else {
                            configuration.openModel(newURL, newURL, newURL.toExternalForm());
                        }
                    } else {
                        this.pane.setPage(newURL);
                    }
                }
            }
            catch (Exception ex) {
                MessageHandler.error("Hyperlink reference failed", ex);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat format, int index) throws PrinterException {
        Dimension dimension = this.pane.getSize();
        double scale = format.getImageableWidth() / dimension.getWidth();
        double scaledHeight = dimension.getHeight() * scale;
        int lastPage = (int)(scaledHeight / format.getImageableHeight());
        if (index > lastPage) {
            return 1;
        }
        AffineTransform at = new AffineTransform();
        at.translate((int)format.getImageableX(), (int)format.getImageableY());
        at.translate(0.0, -(format.getImageableHeight() * (double)index));
        at.scale(scale, scale);
        ((Graphics2D)graphics).transform(at);
        this.pane.paint(graphics);
        return 0;
    }

    public void setBase(URL base) {
        this._base = base;
    }

    public void setPage(URL page) throws IOException {
        this.pane.setPage(page);
    }

    @Override
    public void setSize(final int width, final int height) {
        Runnable doSet = new Runnable(){

            @Override
            public void run() {
                HTMLViewer.this._setScrollerSize(width, height);
                HTMLViewer.super.setSize(width, height);
            }
        };
        Top.deferIfNecessary(doSet);
    }

    public void setText(String text) {
        this.pane.setText(text);
    }

    protected void _addMainPane() {
        this._scroller.setPreferredSize(new Dimension(800, 600));
        this.getContentPane().add(this._scroller);
    }

    protected void _setScrollerSize(int width, int height) {
        this._scroller.setPreferredSize(new Dimension(width, height));
        this._scroller.setSize(new Dimension(width, height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _writeFile(File file) throws IOException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(this.pane.getText());
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    private void _init() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.pane.setContentType("text/html");
        this.pane.setEditable(false);
        this.pane.addHyperlinkListener(this);
        if (_styleSheetURL != null) {
            HTMLDocument doc = (HTMLDocument)this.pane.getDocument();
            StyleSheet styleSheet = doc.getStyleSheet();
            styleSheet.importStyleSheet(_styleSheetURL);
            new HTMLEditorKit().setStyleSheet(styleSheet);
            _styleSheetURL = null;
        }
        try {
            Class<?> swingUtilities = Class.forName("com.sun.java.swing.SwingUtilities2");
            Field propertyField = swingUtilities.getDeclaredField("AA_TEXT_PROPERTY_KEY");
            this.pane.putClientProperty(propertyField.get(null), Boolean.TRUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._scroller = new JScrollPane(this.pane);
        this._addMainPane();
    }

    static {
        try {
            Class<?> refClass = Class.forName("ptolemy.kernel.util.NamedObj");
            _styleSheetURL = refClass.getClassLoader().getResource("doc/default.css");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

