/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.PtolemyFrame;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class JVMTableau
extends Tableau {
    public JVMTableau(PtolemyEffigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        NamedObj model = container.getModel();
        JVMFrame frame = new JVMFrame((CompositeEntity)model, this);
        this.setFrame(frame);
    }

    private void updateMemoryStatistics(JTextArea textArea) {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory() / 1024L;
        long freeMemory = runtime.freeMemory() / 1024L;
        long maxMemory = runtime.maxMemory() / 1024L;
        textArea.setText("Memory: " + totalMemory + "K Free: " + freeMemory + "K (" + Math.round((double)freeMemory / (double)totalMemory * 100.0) + "%) Max: " + maxMemory + "K (" + Math.round((double)totalMemory / (double)maxMemory * 100.0) + "%)");
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        @Override
        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof PtolemyEffigy) {
                JVMTableau tableau = (JVMTableau)effigy.getEntity("JVMTableau");
                if (tableau == null) {
                    tableau = new JVMTableau((PtolemyEffigy)effigy, "JVMTableau");
                }
                return tableau;
            }
            return null;
        }
    }

    public class JVMFrame
    extends PtolemyFrame {
        public JVMFrame(CompositeEntity model, Tableau tableau) throws IllegalActionException, NameDuplicationException {
            super(model, tableau);
            JPanel component = new JPanel();
            component.setLayout(new BoxLayout(component, 1));
            final JTextArea memoryArea = new JTextArea("", 1, 100);
            JVMTableau.this.updateMemoryStatistics(memoryArea);
            memoryArea.setEditable(false);
            component.add(memoryArea);
            JButton GCButton = new JButton("Request Garbage Collection");
            GCButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    System.gc();
                    JVMTableau.this.updateMemoryStatistics(memoryArea);
                }
            });
            component.add(GCButton);
            String lineSeparator = System.getProperty("line.separator");
            StringBuffer propertyBuffer = new StringBuffer();
            try {
                Properties properties = System.getProperties();
                Enumeration<?> propertyNamesEnumeration = properties.propertyNames();
                ArrayList<String> propertyNamesList = Collections.list(propertyNamesEnumeration);
                Collections.sort(propertyNamesList);
                for (String propertyName : propertyNamesList) {
                    propertyBuffer.append(propertyName + " = " + properties.getProperty(propertyName) + lineSeparator);
                }
            }
            catch (AccessControlException accessControl) {
                propertyBuffer.append("AccessControlException, probably from System.getProperties():\n" + accessControl);
            }
            try {
                Class<?> printThreadsClass = Class.forName("util.testsuite.PrintThreads");
                Method allThreads = printThreadsClass.getMethod("allThreads", Boolean.TYPE);
                propertyBuffer.append("\nThreads:\n" + (String)allThreads.invoke(null, Boolean.TRUE));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            JTextArea messageArea = new JTextArea(propertyBuffer.toString(), 20, 100);
            messageArea.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(messageArea);
            component.add(scrollPane);
            this.getContentPane().add((Component)component, "Center");
        }
    }
}

