/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Rectangle;
import java.awt.Window;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class LocationAttribute
extends Parameter {
    public LocationAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setVisibility(Settable.NONE);
    }

    public void recordLocation(Window component) {
        try {
            Rectangle location = component.getBounds();
            int[][] locationMatrix = new int[1][2];
            locationMatrix[0][0] = location.x;
            locationMatrix[0][1] = location.y;
            IntMatrixToken token = new IntMatrixToken(locationMatrix);
            this.setToken(token);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("Can't set bounds value!");
        }
    }

    public boolean setLocation(Window component) {
        try {
            IntMatrixToken token = (IntMatrixToken)this.getToken();
            if (token != null) {
                int x = token.getElementAt(0, 0);
                int y = token.getElementAt(0, 1);
                component.setLocation(x, y);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

