/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.Manager;
import ptolemy.actor.gui.Configurer;
import ptolemy.actor.gui.Placeable;
import ptolemy.data.expr.Parameter;
import ptolemy.gui.CloseListener;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.util.MessageHandler;

public class ModelPane
extends JPanel
implements CloseListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int CONTROLS_ONLY = 2;
    public static final int BUTTONS = 1;
    public static final int TOP_PARAMETERS = 2;
    public static final int DIRECTOR_PARAMETERS = 4;
    protected Container _displays;
    private JPanel _buttonPanel;
    private JPanel _controlPanel;
    private Configurer _directorQuery;
    private JButton _goButton;
    private int _layout;
    private Manager _manager;
    private CompositeActor _model;
    private Configurer _parameterQuery;
    private JButton _stopButton;
    private JButton _pauseButton;
    private JButton _resumeButton;
    private int _show;

    public ModelPane(CompositeActor model) {
        this(model, 0, 7);
    }

    public ModelPane(CompositeActor model, int layout, int show) {
        if (layout == 0) {
            this.setLayout(new BoxLayout(this, 0));
        } else {
            this.setLayout(new BoxLayout(this, 1));
        }
        this._layout = layout;
        if (show != 0) {
            this._controlPanel = new JPanel();
            this._controlPanel.setLayout(new BoxLayout(this._controlPanel, 1));
            this._controlPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            ClickListener clickListener = new ClickListener();
            this._controlPanel.addMouseListener(clickListener);
            this._controlPanel.addKeyListener(new CommandListener());
            if ((show & 1) != 0) {
                this._buttonPanel = new JPanel();
                this._buttonPanel.setLayout(new BoxLayout(this._buttonPanel, 0));
                this._buttonPanel.addMouseListener(clickListener);
                this._buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
                this._buttonPanel.setAlignmentX(0.0f);
                this._goButton = new JButton("Go");
                this._goButton.setToolTipText("Execute the model");
                this._goButton.setAlignmentX(0.0f);
                this._buttonPanel.add(this._goButton);
                this._buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                this._goButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        ModelPane.this.startRun();
                    }
                });
                this._pauseButton = new JButton("Pause");
                this._pauseButton.setToolTipText("Pause execution of the model");
                this._buttonPanel.add(this._pauseButton);
                this._buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                this._pauseButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        ModelPane.this.pauseRun();
                    }
                });
                this._resumeButton = new JButton("Resume");
                this._resumeButton.setToolTipText("Resume executing the model");
                this._buttonPanel.add(this._resumeButton);
                this._buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                this._resumeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        ModelPane.this.resumeRun();
                    }
                });
                this._stopButton = new JButton("Stop");
                this._stopButton.setToolTipText("Stop executing the model");
                this._buttonPanel.add(this._stopButton);
                this._stopButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        ModelPane.this.stopRun();
                    }
                });
                this._controlPanel.add(this._buttonPanel);
                this._buttonPanel.setBackground(null);
            }
            this.add(this._controlPanel);
            this._controlPanel.setBackground(null);
        }
        this._show = show;
        this.setModel(model);
    }

    public Container getDisplayPane() {
        if (this._displays == null) {
            this._displays = new JPanel();
            this._displays.setBackground(null);
            this.add(this._displays);
        }
        return this._displays;
    }

    public CompositeActor getModel() {
        return this._model;
    }

    public void pauseRun() {
        if (this._manager != null) {
            this._manager.pause();
        }
    }

    public void resumeRun() {
        if (this._manager != null) {
            this._manager.resume();
        }
    }

    public void setDefaultButton() {
        JRootPane root = this.getRootPane();
        if (root != null && (this._show & 1) != 0) {
            root.setDefaultButton(this._goButton);
            this._goButton.setMnemonic(71);
            this._pauseButton.setMnemonic(80);
            this._resumeButton.setMnemonic(82);
            this._stopButton.setMnemonic(83);
        }
    }

    public void setDisplayPane(Container pane) {
        if (this._displays != null) {
            this.remove(this._displays);
        }
        this._displays = pane;
        this.add(this._displays);
        this._displays.setBackground(null);
    }

    public void setModel(CompositeActor model) {
        this._closeDisplays();
        this._model = model;
        this._closeDisplays();
        if (this._parameterQuery != null) {
            this._controlPanel.remove(this._parameterQuery);
            this._parameterQuery = null;
        }
        if (this._directorQuery != null) {
            this._controlPanel.remove(this._directorQuery);
            this._directorQuery = null;
        }
        if (model != null) {
            List dirParameterList;
            Director director;
            List parameterList;
            this._manager = this._model.getManager();
            if ((this._show & 2) != 0 && (parameterList = this._model.attributeList(Parameter.class)).size() > 0) {
                JLabel pTitle = new JLabel("Model parameters:");
                pTitle.setForeground(new Color(0, 0, 128));
                this._controlPanel.add(pTitle);
                this._controlPanel.add(Box.createRigidArea(new Dimension(0, 8)));
                this._parameterQuery = new Configurer(model);
                if (this._layout == 0) {
                    this._parameterQuery.setAlignmentX(0.0f);
                } else {
                    this._parameterQuery.setAlignmentX(0.5f);
                }
                this._parameterQuery.setBackground(null);
                this._controlPanel.add(this._parameterQuery);
                if ((this._show & 4) != 0) {
                    this._controlPanel.add(Box.createRigidArea(new Dimension(0, 15)));
                }
            }
            if ((this._show & 4) != 0 && (director = this._model.getDirector()) != null && (dirParameterList = director.attributeList(Parameter.class)).size() > 0) {
                JLabel pTitle = new JLabel("Director parameters:");
                pTitle.setForeground(new Color(0, 0, 128));
                this._controlPanel.add(pTitle);
                this._controlPanel.add(Box.createRigidArea(new Dimension(0, 8)));
                this._directorQuery = new Configurer(director);
                if (this._layout == 0) {
                    this._directorQuery.setAlignmentX(0.0f);
                } else {
                    this._directorQuery.setAlignmentX(0.5f);
                }
                this._directorQuery.setBackground(null);
                this._controlPanel.add(this._directorQuery);
            }
            if (this._controlPanel != null && this._layout == 0) {
                this._controlPanel.add(Box.createVerticalGlue());
            }
            if (this._parameterQuery != null && this._directorQuery != null) {
                Dimension modelSize = this._parameterQuery.getPreferredSize();
                Dimension directorSize = this._directorQuery.getPreferredSize();
                if (directorSize.width > modelSize.width) {
                    this._parameterQuery.setPreferredSize(new Dimension(directorSize.width, modelSize.height));
                } else {
                    this._directorQuery.setPreferredSize(new Dimension(modelSize.width, directorSize.height));
                }
            }
            if (this._layout != 2) {
                this._createPlaceable(model);
            }
        }
    }

    public void startRun() {
        if (this._manager != null) {
            try {
                this._manager.startRun();
            }
            catch (IllegalActionException illegalActionException) {
                // empty catch block
            }
        }
    }

    public void stopRun() {
        if (this._manager != null) {
            this._manager.stop();
        }
    }

    @Override
    public void windowClosed(Window window, String button) {
        if (this._directorQuery != null) {
            this._directorQuery.windowClosed(window, button);
        }
        if (this._parameterQuery != null) {
            this._parameterQuery.windowClosed(window, button);
        }
        if (this._model != null) {
            this._closeDisplays();
        }
    }

    protected void _createPlaceable(CompositeActor model) {
        if (this._displays != null) {
            this.remove(this._displays);
            this._displays = null;
        }
        this._displays = new JPanel();
        this.add(this._displays);
        this._displays.setLayout(new BoxLayout(this._displays, 1));
        this._displays.setBackground(null);
        for (Object object : model.allAtomicEntityList()) {
            if (!(object instanceof Placeable)) continue;
            ((Placeable)object).place(this._displays);
        }
    }

    private void _closeDisplays() {
        if (this._model != null) {
            for (Object object : this._model.allAtomicEntityList()) {
                if (!(object instanceof Placeable)) continue;
                ((Placeable)object).place(null);
            }
        }
    }

    private class CommandListener
    extends KeyAdapter {
        private boolean _control = false;
        private boolean _shift = false;
        private String _helpString = "Key bindings in button panel:\n  Control-G: Start a run.\n  Control-H: Display help.\n  Control-M: Export MoML to standard out.\n  Control-P: Pause a run.\n  Control-R: Resume a run.\n  Control-S: Stop a run.\n  Control-?: Display help.\n";

        private CommandListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keycode = e.getKeyCode();
            switch (keycode) {
                case 17: {
                    this._control = true;
                    break;
                }
                case 16: {
                    this._shift = true;
                    break;
                }
                case 10: {
                    ModelPane.this.startRun();
                    break;
                }
                case 71: {
                    if (!this._control) break;
                    ModelPane.this.startRun();
                    break;
                }
                case 72: {
                    if (!this._control) break;
                    MessageHandler.message(this._helpString);
                    break;
                }
                case 77: {
                    if (!this._control || ModelPane.this._model == null) break;
                    System.out.println(ModelPane.this._model.exportMoML());
                    MessageHandler.message("Exported MoML to standard out.");
                    break;
                }
                case 80: {
                    if (!this._control) break;
                    ModelPane.this.pauseRun();
                    break;
                }
                case 82: {
                    if (!this._control) break;
                    ModelPane.this.resumeRun();
                    break;
                }
                case 83: {
                    if (!this._control) break;
                    ModelPane.this.stopRun();
                    break;
                }
                case 47: {
                    if (!this._shift) break;
                    MessageHandler.message(this._helpString);
                    break;
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int keycode = e.getKeyCode();
            switch (keycode) {
                case 17: {
                    this._control = false;
                    break;
                }
                case 16: {
                    this._shift = false;
                    break;
                }
            }
        }
    }

    private class ClickListener
    extends MouseAdapter {
        private ClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ModelPane.this._controlPanel.requestFocus();
        }
    }
}

