/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class AddSubtract
extends TypedAtomicActor {
    public TypedIOPort minus;
    public TypedIOPort output;
    public TypedIOPort plus = new TypedIOPort(this, "plus", true, false);

    public AddSubtract(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.plus.setMultiport(true);
        this.minus = new TypedIOPort(this, "minus", true, false);
        this.minus.setMultiport(true);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeAtLeast(this.plus);
        this.output.setTypeAtLeast(this.minus);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:white\"/>\n<text x=\"-13\" y=\"-5\" style=\"font-size:18\">\n+ \n</text>\n<text x=\"-13\" y=\"7\" style=\"font-size:18\">\n_ \n</text>\n</svg>\n");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        AddSubtract newObject = (AddSubtract)super.clone(workspace);
        newObject.output.setTypeAtLeast(newObject.plus);
        newObject.output.setTypeAtLeast(newObject.minus);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        int i;
        super.fire();
        Token sum = null;
        for (i = 0; i < this.plus.getWidth(); ++i) {
            if (!this.plus.hasToken(i)) continue;
            sum = sum == null ? this.plus.get(i) : sum.add(this.plus.get(i));
        }
        for (i = 0; i < this.minus.getWidth(); ++i) {
            if (!this.minus.hasToken(i)) continue;
            Token in = this.minus.get(i);
            if (sum == null) {
                sum = in.zero();
            }
            sum = sum.subtract(in);
        }
        if (sum != null) {
            this.output.send(0, sum);
        }
    }
}

