/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class BooleanMultiplexor
extends TypedAtomicActor {
    public TypedIOPort trueInput = new TypedIOPort(this, "trueInput", true, false);
    public TypedIOPort falseInput = new TypedIOPort(this, "falseInput", true, false);
    public TypedIOPort select = new TypedIOPort(this, "select", true, false);
    public TypedIOPort output;

    public BooleanMultiplexor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.select.setTypeEquals(BaseType.BOOLEAN);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeAtLeast(this.trueInput);
        this.output.setTypeAtLeast(this.falseInput);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        boolean control = ((BooleanToken)this.select.get(0)).booleanValue();
        Token trueToken = this.trueInput.get(0);
        Token falseToken = this.falseInput.get(0);
        if (control) {
            this.output.send(0, trueToken);
        } else {
            this.output.send(0, falseToken);
        }
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.select.hasToken(0)) {
            return false;
        }
        if (!this.trueInput.hasToken(0)) {
            return false;
        }
        if (!this.falseInput.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

