/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.SequenceActor;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class Commutator
extends Transformer
implements SequenceActor {
    public Parameter blockSize;
    public Parameter input_tokenConsumptionRate;
    public Parameter output_tokenProductionRate;
    private int _currentInputPosition;
    private int _tentativeInputPosition;

    public Commutator(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setMultiport(true);
        this.output_tokenProductionRate = new Parameter(this.output, "tokenProductionRate");
        this.output_tokenProductionRate.setExpression("0");
        this.input_tokenConsumptionRate = new Parameter(this.input, "tokenConsumptionRate");
        this.input_tokenConsumptionRate.setExpression("blockSize");
        this.blockSize = new Parameter(this, "blockSize");
        this.blockSize.setTypeEquals(BaseType.INT);
        this.blockSize.setExpression("1");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Commutator newObject = (Commutator)super.clone(workspace);
        newObject.output_tokenProductionRate = (Parameter)newObject.output.getAttribute("tokenProductionRate");
        return newObject;
    }

    @Override
    public void connectionsChanged(Port port) {
        super.connectionsChanged(port);
        if (port == this.input) {
            this.output_tokenProductionRate.setExpression(this.input.getWidth() + " * blockSize");
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._tentativeInputPosition = this._currentInputPosition;
        int width = this.input.getWidth();
        int blockSizeValue = ((IntToken)this.blockSize.getToken()).intValue();
        for (int i = 0; i < width && this.input.hasToken(this._tentativeInputPosition, blockSizeValue); ++i) {
            Token[] inputs = this.input.get(this._tentativeInputPosition++, blockSizeValue);
            this.output.send(0, inputs, blockSizeValue);
            if (this._tentativeInputPosition < width) continue;
            this._tentativeInputPosition = 0;
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._currentInputPosition = 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._currentInputPosition = this._tentativeInputPosition;
        return super.postfire();
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(this._currentInputPosition)) {
            return false;
        }
        return super.prefire();
    }
}

