/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class ElementsToArray
extends Transformer {
    public ElementsToArray(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeAtLeast(ArrayType.arrayOf(this.input));
        this.input.setMultiport(true);
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ElementsToArray newObject = (ElementsToArray)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.arrayOf(newObject.input));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int size = this.input.getWidth();
        Token[] valueArray = new Token[size];
        for (int i = 0; i < size; ++i) {
            valueArray[i] = this.input.get(i);
        }
        this.output.send(0, new ArrayToken(this.input.getType(), valueArray));
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        for (int i = 0; i < this.input.getWidth(); ++i) {
            if (this.input.hasToken(i)) continue;
            return false;
        }
        return true;
    }
}

