/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class OrderedMerge
extends TypedAtomicActor {
    public TypedIOPort inputA = new TypedIOPort(this, "inputA", true, false);
    public TypedIOPort inputB = new TypedIOPort(this, "inputB", true, false);
    public TypedIOPort output;
    public TypedIOPort selectedA;
    private ScalarToken _recordedToken = null;
    private TypedIOPort _nextPort = null;
    private boolean _readFromA;
    private boolean _tentativeReadFromA;
    private ScalarToken _tentativeRecordedToken = null;
    private TypedIOPort _tentativeNextPort = null;

    public OrderedMerge(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.inputB.setTypeSameAs(this.inputA);
        this.inputA.setTypeAtMost(BaseType.SCALAR);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeSameAs(this.inputA);
        this.selectedA = new TypedIOPort(this, "selectedA", false, true);
        this.selectedA.setTypeEquals(BaseType.BOOLEAN);
        StringAttribute channelCardinal = new StringAttribute(this.selectedA, "_cardinal");
        channelCardinal.setExpression("SOUTH");
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-10,20 10,10 10,-10, -10,-20\" style=\"fill:blue\"/>\n</svg>\n");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        OrderedMerge newObject = (OrderedMerge)super.clone(workspace);
        newObject.inputA.setTypeAtMost(BaseType.SCALAR);
        newObject.inputB.setTypeSameAs(newObject.inputA);
        newObject.output.setTypeSameAs(newObject.inputA);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this._nextPort.hasToken(0)) {
            ScalarToken readToken = (ScalarToken)this._nextPort.get(0);
            if (this._debugging) {
                this._debug("Read input token from " + this._nextPort.getName() + " with value " + readToken);
            }
            if (this._recordedToken == null) {
                this._tentativeRecordedToken = readToken;
                this._tentativeReadFromA = true;
                this._tentativeNextPort = this.inputB;
            } else if (readToken.isLessThan(this._recordedToken).booleanValue()) {
                this.output.send(0, readToken);
                if (this._debugging) {
                    this._debug("Sent output token with value " + readToken);
                }
                if (this._nextPort == this.inputA) {
                    this.selectedA.send(0, BooleanToken.TRUE);
                } else {
                    this.selectedA.send(0, BooleanToken.FALSE);
                }
            } else {
                this.output.send(0, this._recordedToken);
                if (this._debugging) {
                    this._debug("Sent output token with value " + this._recordedToken);
                }
                if (this._readFromA) {
                    this.selectedA.send(0, BooleanToken.TRUE);
                } else {
                    this.selectedA.send(0, BooleanToken.FALSE);
                }
                this._tentativeRecordedToken = readToken;
                this._tentativeReadFromA = this._nextPort == this.inputA;
                this._tentativeNextPort = this._nextPort == this.inputA ? this.inputB : this.inputA;
            }
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._nextPort = this.inputA;
        this._recordedToken = null;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._recordedToken = this._tentativeRecordedToken;
        this._readFromA = this._tentativeReadFromA;
        this._nextPort = this._tentativeNextPort;
        if (this._debugging) {
            this._debug("Next port to read input from is " + this._nextPort.getName());
        }
        return super.postfire();
    }

    protected TypedIOPort _getNextPort() {
        return this._nextPort;
    }
}

