/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.RecordToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.MonotonicFunction;
import ptolemy.data.type.RecordType;
import ptolemy.data.type.Type;
import ptolemy.graph.Inequality;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class RecordDisassembler
extends TypedAtomicActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);

    public RecordDisassembler(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"0\" y=\"0\" width=\"6\" height=\"40\" style=\"fill:red\"/>\n</svg>\n");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        Director director = this.getDirector();
        if (director == null) {
            throw new IllegalActionException((Nameable)this, "No director!");
        }
        if (this.input.hasToken(0)) {
            RecordToken record = (RecordToken)this.input.get(0);
            for (String label : record.labelSet()) {
                Token value = record.get(label);
                IOPort port = (IOPort)this.getPort(label);
                if (port == null) continue;
                port.send(0, value);
            }
        }
    }

    @Override
    public List typeConstraintList() {
        Object[] portArray = this.outputPortList().toArray();
        int size = portArray.length;
        String[] labels = new String[size];
        Type[] types = new Type[size];
        for (int i = 0; i < size; ++i) {
            labels[i] = ((Port)portArray[i]).getName();
            types[i] = BaseType.GENERAL;
        }
        RecordType declaredType = new RecordType(labels, types);
        this.input.setTypeAtMost(declaredType);
        LinkedList<Inequality> constraints = new LinkedList<Inequality>();
        for (TypedIOPort outputPort : this.outputPortList()) {
            String label = outputPort.getName();
            Inequality inequality = new Inequality(new PortFunction(label), outputPort.getTypeTerm());
            constraints.add(inequality);
        }
        return constraints;
    }

    private class PortFunction
    extends MonotonicFunction {
        private String _name;

        private PortFunction(String name) {
            this._name = name;
        }

        @Override
        public Object getValue() throws IllegalActionException {
            if (RecordDisassembler.this.input.getType() == BaseType.UNKNOWN) {
                return BaseType.UNKNOWN;
            }
            if (RecordDisassembler.this.input.getType() instanceof RecordType) {
                RecordType type = (RecordType)RecordDisassembler.this.input.getType();
                Type fieldType = type.get(this._name);
                if (fieldType == null) {
                    return BaseType.UNKNOWN;
                }
                return fieldType;
            }
            throw new IllegalActionException((Nameable)RecordDisassembler.this, "Invalid type for input port");
        }

        @Override
        public String getVerboseString() {
            RecordType type;
            Type fieldType;
            if (RecordDisassembler.this.input.getType() instanceof RecordType && (fieldType = (type = (RecordType)RecordDisassembler.this.input.getType()).get(this._name)) == null) {
                return "Input Record doesn't have field named " + this._name;
            }
            return null;
        }

        @Override
        public InequalityTerm[] getVariables() {
            InequalityTerm portTerm = RecordDisassembler.this.input.getTypeTerm();
            if (portTerm.isSettable()) {
                InequalityTerm[] variable = new InequalityTerm[]{portTerm};
                return variable;
            }
            return new InequalityTerm[0];
        }
    }
}

